(function() {
  var Task, fs;

  fs = require('fs-plus');

  Task = require('atom').Task;

  module.exports = {
    startTask: function(callback) {
      var followSymlinks, ignoreVcsIgnores, ignoredNames, projectPaths, ref, ref1, results, task, taskPath;
      results = [];
      taskPath = require.resolve('./load-paths-handler');
      followSymlinks = atom.config.get('core.followSymlinks');
      ignoredNames = (ref = atom.config.get('fuzzy-finder.ignoredNames')) != null ? ref : [];
      ignoredNames = ignoredNames.concat((ref1 = atom.config.get('core.ignoredNames')) != null ? ref1 : []);
      ignoreVcsIgnores = atom.config.get('core.excludeVcsIgnoredPaths');
      projectPaths = atom.project.getPaths().map((function(_this) {
        return function(path) {
          return fs.realpathSync(path);
        };
      })(this));
      task = Task.once(taskPath, projectPaths, followSymlinks, ignoreVcsIgnores, ignoredNames, function() {
        return callback(results);
      });
      task.on('load-paths:paths-found', function(paths) {
        return results.push.apply(results, paths);
      });
      return task;
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
