(function() {
  var Emitter, FindOptions, Params, _;

  _ = require('underscore-plus');

  Emitter = require('atom').Emitter;

  Params = ['findPattern', 'replacePattern', 'pathsPattern', 'useRegex', 'wholeWord', 'caseSensitive', 'inCurrentSelection'];

  module.exports = FindOptions = (function() {
    function FindOptions(state) {
      var ref, ref1, ref2, ref3, ref4, ref5, ref6, ref7, ref8, ref9;
      if (state == null) {
        state = {};
      }
      this.emitter = new Emitter;
      this.findPattern = '';
      this.replacePattern = (ref = state.replacePattern) != null ? ref : '';
      this.pathsPattern = (ref1 = state.pathsPattern) != null ? ref1 : '';
      this.useRegex = (ref2 = (ref3 = state.useRegex) != null ? ref3 : atom.config.get('find-and-replace.useRegex')) != null ? ref2 : false;
      this.caseSensitive = (ref4 = (ref5 = state.caseSensitive) != null ? ref5 : atom.config.get('find-and-replace.caseSensitive')) != null ? ref4 : false;
      this.wholeWord = (ref6 = (ref7 = state.wholeWord) != null ? ref7 : atom.config.get('find-and-replace.wholeWord')) != null ? ref6 : false;
      this.inCurrentSelection = (ref8 = (ref9 = state.inCurrentSelection) != null ? ref9 : atom.config.get('find-and-replace.inCurrentSelection')) != null ? ref8 : false;
    }

    FindOptions.prototype.onDidChange = function(callback) {
      return this.emitter.on('did-change', callback);
    };

    FindOptions.prototype.onDidChangeReplacePattern = function(callback) {
      return this.emitter.on('did-change-replacePattern', callback);
    };

    FindOptions.prototype.serialize = function() {
      var i, len, param, result;
      result = {};
      for (i = 0, len = Params.length; i < len; i++) {
        param = Params[i];
        result[param] = this[param];
      }
      return result;
    };

    FindOptions.prototype.set = function(newParams) {
      var changedParams, i, key, len, param, val;
      if (newParams == null) {
        newParams = {};
      }
      changedParams = null;
      for (i = 0, len = Params.length; i < len; i++) {
        key = Params[i];
        if ((newParams[key] != null) && newParams[key] !== this[key]) {
          if (changedParams == null) {
            changedParams = {};
          }
          this[key] = changedParams[key] = newParams[key];
        }
      }
      if (changedParams != null) {
        for (param in changedParams) {
          val = changedParams[param];
          this.emitter.emit("did-change-" + param);
        }
        return this.emitter.emit('did-change', changedParams);
      }
    };

    FindOptions.prototype.getFindPatternRegex = function() {
      var expression, flags;
      flags = 'g';
      if (!this.caseSensitive) {
        flags += 'i';
      }
      if (this.useRegex) {
        expression = this.findPattern;
      } else {
        expression = _.escapeRegExp(this.findPattern);
      }
      if (this.wholeWord) {
        expression = "\\b" + expression + "\\b";
      }
      return new RegExp(expression, flags);
    };

    return FindOptions;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
