Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _iconvLite = require('iconv-lite');

var _iconvLite2 = _interopRequireDefault(_iconvLite);

var _jschardet = require('jschardet');

var _jschardet2 = _interopRequireDefault(_jschardet);

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var EncodingListView = (function () {
  function EncodingListView(encodings) {
    var _this = this;

    _classCallCheck(this, EncodingListView);

    this.encodings = encodings;
    this.selectListView = new _atomSelectList2['default']({
      itemsClassList: ['mark-active'],
      items: [],
      filterKeyForItem: function filterKeyForItem(encoding) {
        return encoding.name;
      },
      elementForItem: function elementForItem(encoding) {
        var element = document.createElement('li');
        if (encoding.id === _this.currentEncoding) {
          element.classList.add('active');
        }
        element.textContent = encoding.name;
        element.dataset.encoding = encoding.id;
        return element;
      },
      didConfirmSelection: function didConfirmSelection(encoding) {
        _this.cancel();
        if (encoding.id === 'detect') {
          _this.detectEncoding();
        } else {
          atom.workspace.getActiveTextEditor().setEncoding(encoding.id);
        }
      },
      didCancelSelection: function didCancelSelection() {
        _this.cancel();
      }
    });
    this.selectListView.element.classList.add('encoding-selector');
  }

  _createClass(EncodingListView, [{
    key: 'destroy',
    value: function destroy() {
      this.cancel();
      return this.selectListView.destroy();
    }
  }, {
    key: 'cancel',
    value: function cancel() {
      if (this.panel != null) {
        this.panel.destroy();
      }
      this.panel = null;
      this.currentEncoding = null;
      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'attach',
    value: function attach() {
      this.previouslyFocusedElement = document.activeElement;
      if (this.panel == null) {
        this.panel = atom.workspace.addModalPanel({ item: this.selectListView });
      }
      this.selectListView.focus();
      this.selectListView.reset();
    }
  }, {
    key: 'toggle',
    value: _asyncToGenerator(function* () {
      if (this.panel != null) {
        this.cancel();
      } else if (atom.workspace.getActiveTextEditor()) {
        var editor = atom.workspace.getActiveTextEditor();
        this.currentEncoding = editor.getEncoding();
        var encodingItems = [];

        if (_fs2['default'].existsSync(editor.getPath())) {
          encodingItems.push({ id: 'detect', name: 'Auto Detect' });
        }

        for (var id in this.encodings) {
          encodingItems.push({ id: id, name: this.encodings[id].list });
        }

        yield this.selectListView.update({ items: encodingItems });
        this.attach();
      }
    })
  }, {
    key: 'detectEncoding',
    value: function detectEncoding() {
      var editor = atom.workspace.getActiveTextEditor();
      var filePath = editor.getPath();
      if (_fs2['default'].existsSync(filePath)) {
        _fs2['default'].readFile(filePath, function (error, buffer) {
          if (!error) {
            var _ref = _jschardet2['default'].detect(buffer) || {};

            var encoding = _ref.encoding;

            if (encoding === 'ascii') {
              encoding = 'utf8';
            }

            if (_iconvLite2['default'].encodingExists(encoding)) {
              editor.setEncoding(encoding.toLowerCase().replace(/[^0-9a-z]|:\d{4}$/g, ''));
            }
          }
        });
      }
    }
  }]);

  return EncodingListView;
})();

exports['default'] = EncodingListView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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