(function() {
  var BaseThemeWatcher, Watcher, fs, path,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  fs = require('fs-plus');

  path = require('path');

  Watcher = require('./watcher');

  module.exports = BaseThemeWatcher = (function(superClass) {
    extend(BaseThemeWatcher, superClass);

    function BaseThemeWatcher() {
      BaseThemeWatcher.__super__.constructor.call(this);
      this.stylesheetsPath = path.dirname(atom.themes.resolveStylesheet('../static/atom.less'));
      this.watch();
    }

    BaseThemeWatcher.prototype.watch = function() {
      var filePath, filePaths, i, len, results;
      filePaths = fs.readdirSync(this.stylesheetsPath).filter(function(filePath) {
        return path.extname(filePath).indexOf('less') > -1;
      });
      results = [];
      for (i = 0, len = filePaths.length; i < len; i++) {
        filePath = filePaths[i];
        results.push(this.watchFile(path.join(this.stylesheetsPath, filePath)));
      }
      return results;
    };

    BaseThemeWatcher.prototype.loadStylesheet = function() {
      return this.loadAllStylesheets();
    };

    BaseThemeWatcher.prototype.loadAllStylesheets = function() {
      return atom.themes.reloadBaseStylesheets();
    };

    return BaseThemeWatcher;

  })(Watcher);

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
