(function() {
  var Bookmarks, BookmarksView, CompositeDisposable, ReactBookmarks, disposables, editorsBookmarks;

  CompositeDisposable = require('atom').CompositeDisposable;

  Bookmarks = null;

  ReactBookmarks = null;

  BookmarksView = require('./bookmarks-view');

  editorsBookmarks = null;

  disposables = null;

  module.exports = {
    activate: function(bookmarksByEditorId) {
      var bookmarksView;
      editorsBookmarks = [];
      bookmarksView = null;
      disposables = new CompositeDisposable;
      atom.commands.add('atom-workspace', 'bookmarks:view-all', function() {
        if (bookmarksView == null) {
          bookmarksView = new BookmarksView(editorsBookmarks);
        }
        return bookmarksView.show();
      });
      return atom.workspace.observeTextEditors(function(textEditor) {
        var bookmarks, state;
        if (Bookmarks == null) {
          Bookmarks = require('./bookmarks');
        }
        if (state = bookmarksByEditorId[textEditor.id]) {
          bookmarks = Bookmarks.deserialize(textEditor, state);
        } else {
          bookmarks = new Bookmarks(textEditor);
        }
        editorsBookmarks.push(bookmarks);
        return disposables.add(textEditor.onDidDestroy(function() {
          var index;
          index = editorsBookmarks.indexOf(bookmarks);
          if (index !== -1) {
            editorsBookmarks.splice(index, 1);
          }
          return bookmarks.destroy();
        }));
      });
    },
    deactivate: function() {
      var bookmarks, i, len;
      if (typeof bookmarksView !== "undefined" && bookmarksView !== null) {
        bookmarksView.destroy();
      }
      for (i = 0, len = editorsBookmarks.length; i < len; i++) {
        bookmarks = editorsBookmarks[i];
        bookmarks.deactivate();
      }
      return disposables.dispose();
    },
    serialize: function() {
      var bookmarks, bookmarksByEditorId, i, len;
      bookmarksByEditorId = {};
      for (i = 0, len = editorsBookmarks.length; i < len; i++) {
        bookmarks = editorsBookmarks[i];
        bookmarksByEditorId[bookmarks.editor.id] = bookmarks.serialize();
      }
      return bookmarksByEditorId;
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
