Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _fileView = require('./file-view');

var _fileView2 = _interopRequireDefault(_fileView);

var DirectoryView = (function () {
  function DirectoryView(parentView, indexInParentView, archivePath, entry) {
    _classCallCheck(this, DirectoryView);

    this.entries = [];
    this.parentView = parentView;
    this.indexInParentView = indexInParentView;
    this.element = document.createElement('li');
    this.element.classList.add('list-nested-item', 'entry');

    var listItem = document.createElement('span');
    listItem.classList.add('list-item');

    var entrySpan = document.createElement('span');
    entrySpan.classList.add('directory', 'icon', 'icon-file-directory');
    entrySpan.textContent = entry.getName();
    listItem.appendChild(entrySpan);
    this.element.appendChild(listItem);

    this.entriesTree = document.createElement('ol');
    this.entriesTree.classList.add('list-tree');
    var index = 0;
    for (var child of entry.children) {
      if (child.isDirectory()) {
        var entryView = new DirectoryView(this, index, archivePath, child);
        this.entries.push(entryView);
        this.entriesTree.appendChild(entryView.element);
      } else {
        var entryView = new _fileView2['default'](this, index, archivePath, child);
        this.entries.push(entryView);
        this.entriesTree.appendChild(entryView.element);
      }

      index++;
    }
    this.element.appendChild(this.entriesTree);
  }

  _createClass(DirectoryView, [{
    key: 'destroy',
    value: function destroy() {
      while (this.entries.length > 0) {
        this.entries.pop().destroy();
      }

      this.element.remove();
    }
  }, {
    key: 'selectFileBeforeIndex',
    value: function selectFileBeforeIndex(index) {
      for (var i = index - 1; i >= 0; i--) {
        var previousEntry = this.entries[i];
        if (previousEntry instanceof _fileView2['default']) {
          previousEntry.select();
          return;
        } else {
          if (previousEntry.selectLastFile()) {
            return;
          }
        }
      }

      this.parentView.selectFileBeforeIndex(this.indexInParentView);
    }
  }, {
    key: 'selectFileAfterIndex',
    value: function selectFileAfterIndex(index) {
      for (var i = index + 1; i < this.entries.length; i++) {
        var nextEntry = this.entries[i];
        if (nextEntry instanceof _fileView2['default']) {
          nextEntry.select();
          return;
        } else {
          if (nextEntry.selectFirstFile()) {
            return;
          }
        }
      }

      this.parentView.selectFileAfterIndex(this.indexInParentView);
    }
  }, {
    key: 'selectFirstFile',
    value: function selectFirstFile() {
      for (var entry of this.entries) {
        if (entry instanceof _fileView2['default']) {
          entry.select();
          return true;
        } else {
          if (entry.selectFirstFile()) {
            return true;
          }
        }
      }

      return false;
    }
  }, {
    key: 'selectLastFile',
    value: function selectLastFile() {
      for (var i = this.entries.length - 1; i >= 0; i--) {
        var entry = this.entries[i];
        if (entry instanceof _fileView2['default']) {
          entry.select();
          return true;
        } else {
          if (entry.selectLastFile()) {
            return true;
          }
        }
      }

      return false;
    }
  }]);

  return DirectoryView;
})();

exports['default'] = DirectoryView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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