Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _humanizePlus = require('humanize-plus');

var _humanizePlus2 = _interopRequireDefault(_humanizePlus);

var _lsArchive = require('ls-archive');

var _lsArchive2 = _interopRequireDefault(_lsArchive);

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _fileView = require('./file-view');

var _fileView2 = _interopRequireDefault(_fileView);

var _directoryView = require('./directory-view');

var _directoryView2 = _interopRequireDefault(_directoryView);

var ArchiveEditorView = (function () {
  function ArchiveEditorView(editor) {
    var _this = this;

    _classCallCheck(this, ArchiveEditorView);

    this.disposables = new _atom.CompositeDisposable();
    this.entries = [];
    _etch2['default'].initialize(this);
    this.setModel(editor);

    var focusHandler = function focusHandler() {
      _this.focusSelectedFile();
    };
    this.element.addEventListener('focus', focusHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.element.removeEventListener('focus', focusHandler);
    }));
  }

  _createClass(ArchiveEditorView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      while (this.entries.length > 0) {
        this.entries.pop().destroy();
      }
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'archive-editor', tabIndex: '-1' },
        _etch2['default'].dom(
          'div',
          { className: 'archive-container' },
          _etch2['default'].dom(
            'div',
            { ref: 'loadingMessage', className: 'padded icon icon-hourglass text-info' },
            'Loading archive…'
          ),
          _etch2['default'].dom('div', { ref: 'errorMessage', className: 'padded icon icon-alert text-error' }),
          _etch2['default'].dom(
            'div',
            { className: 'inset-panel' },
            _etch2['default'].dom('div', { ref: 'summary', className: 'panel-heading' }),
            _etch2['default'].dom('ol', { ref: 'tree', className: 'archive-tree padded list-tree has-collapsable-children' })
          )
        )
      );
    }
  }, {
    key: 'setPath',
    value: function setPath(path) {
      if (path && this.path !== path) {
        this.path = path;
        this.refresh();
      }
    }
  }, {
    key: 'refresh',
    value: function refresh() {
      var _this2 = this;

      this.refs.summary.style.display = 'none';
      this.refs.tree.style.display = 'none';
      this.refs.loadingMessage.style.display = '';
      this.refs.errorMessage.style.display = 'none';

      var originalPath = this.path;
      _lsArchive2['default'].list(this.path, { tree: true }, function (error, entries) {
        if (originalPath !== _this2.path) {
          return;
        }

        _this2.refs.loadingMessage.style.display = 'none';
        if (error != null) {
          var message = 'Reading the archive file failed';
          if (error.message) {
            message += ': ' + error.message;
          }
          _this2.refs.errorMessage.style.display = '';
          _this2.refs.errorMessage.textContent = message;
        } else {
          _this2.createTreeEntries(entries);
          _this2.updateSummary();
        }
      });
    }
  }, {
    key: 'createTreeEntries',
    value: function createTreeEntries(entries) {
      while (this.entries.length > 0) {
        this.entries.pop().destroy();
      }

      var index = 0;
      for (var entry of entries) {
        if (entry.isDirectory()) {
          var entryView = new _directoryView2['default'](this, index, this.path, entry);
          this.entries.push(entryView);
          this.refs.tree.appendChild(entryView.element);
        } else {
          var entryView = new _fileView2['default'](this, index, this.path, entry);
          this.entries.push(entryView);
          this.refs.tree.appendChild(entryView.element);
        }
        index++;
      }

      this.refs.tree.style.display = '';
      this.selectFileAfterIndex(-1);
    }
  }, {
    key: 'updateSummary',
    value: function updateSummary() {
      var fileCount = this.entries.filter(function (entry) {
        return entry instanceof _fileView2['default'];
      }).length;
      var fileLabel = fileCount === 1 ? '1 file' : _humanizePlus2['default'].intComma(fileCount) + ' files';

      var directoryCount = this.entries.filter(function (entry) {
        return entry instanceof _directoryView2['default'];
      }).length;
      var directoryLabel = directoryCount === 1 ? '1 folder' : _humanizePlus2['default'].intComma(directoryCount) + ' folders';

      this.refs.summary.style.display = '';
      this.refs.summary.textContent = _humanizePlus2['default'].fileSize(_fsPlus2['default'].getSizeSync(this.path)) + ' with ' + fileLabel + ' and ' + directoryLabel;
    }
  }, {
    key: 'focusSelectedFile',
    value: function focusSelectedFile() {
      var selectedFile = this.refs.tree.querySelector('.selected');
      if (selectedFile) {
        selectedFile.focus();
      }
    }
  }, {
    key: 'selectFileBeforeIndex',
    value: function selectFileBeforeIndex(index) {
      for (var i = index - 1; i >= 0; i--) {
        var previousEntry = this.entries[i];
        if (previousEntry instanceof _fileView2['default']) {
          previousEntry.select();
          break;
        } else {
          if (previousEntry.selectLastFile()) {
            break;
          }
        }
      }
    }
  }, {
    key: 'selectFileAfterIndex',
    value: function selectFileAfterIndex(index) {
      for (var i = index + 1; i < this.entries.length; i++) {
        var nextEntry = this.entries[i];
        if (nextEntry instanceof _fileView2['default']) {
          nextEntry.select();
          break;
        } else {
          if (nextEntry.selectFirstFile()) {
            break;
          }
        }
      }
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.focusSelectedFile();
    }
  }, {
    key: 'setModel',
    value: function setModel(editor) {
      var _this3 = this;

      if (!editor) {
        return;
      }

      this.editor = editor;
      this.setPath(this.editor.getPath());
      this.disposables.add(this.editor.file.onDidChange(function () {
        _this3.refresh();
      }));
      this.disposables.add(this.editor.file.onDidDelete(function () {
        var pane = atom.workspace.paneForItem(_this3.editor);
        if (pane) {
          pane.destroyItem(_this3.editor);
        }
      }));
    }
  }]);

  return ArchiveEditorView;
})();

exports['default'] = ArchiveEditorView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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