(function() {
  var IsJapaneseKanaCharacter, hasPairedCharacter, isCJKCharacter, isCJKUnifiedIdeograph, isCombinedCharacter, isCombiningCharacter, isDoubleWidthCharacter, isFullWidthForm, isHalfWidthCharacter, isHighSurrogate, isKoreanCharacter, isLowSurrogate, isPairedCharacter, isSurrogatePair, isVariationSelector, isVariationSequence, isWordStart, isWrapBoundary;

  isHighSurrogate = function(charCode) {
    return (0xD800 <= charCode && charCode <= 0xDBFF);
  };

  isLowSurrogate = function(charCode) {
    return (0xDC00 <= charCode && charCode <= 0xDFFF);
  };

  isVariationSelector = function(charCode) {
    return (0xFE00 <= charCode && charCode <= 0xFE0F);
  };

  isCombiningCharacter = function(charCode) {
    return (0x0300 <= charCode && charCode <= 0x036F) || (0x1AB0 <= charCode && charCode <= 0x1AFF) || (0x1DC0 <= charCode && charCode <= 0x1DFF) || (0x20D0 <= charCode && charCode <= 0x20FF) || (0xFE20 <= charCode && charCode <= 0xFE2F);
  };

  isSurrogatePair = function(charCodeA, charCodeB) {
    return isHighSurrogate(charCodeA) && isLowSurrogate(charCodeB);
  };

  isVariationSequence = function(charCodeA, charCodeB) {
    return !isVariationSelector(charCodeA) && isVariationSelector(charCodeB);
  };

  isCombinedCharacter = function(charCodeA, charCodeB) {
    return !isCombiningCharacter(charCodeA) && isCombiningCharacter(charCodeB);
  };

  isPairedCharacter = function(string, index) {
    var charCodeA, charCodeB;
    if (index == null) {
      index = 0;
    }
    charCodeA = string.charCodeAt(index);
    charCodeB = string.charCodeAt(index + 1);
    return isSurrogatePair(charCodeA, charCodeB) || isVariationSequence(charCodeA, charCodeB) || isCombinedCharacter(charCodeA, charCodeB);
  };

  IsJapaneseKanaCharacter = function(charCode) {
    return (0x3000 <= charCode && charCode <= 0x30FF);
  };

  isCJKUnifiedIdeograph = function(charCode) {
    return (0x4E00 <= charCode && charCode <= 0x9FFF);
  };

  isFullWidthForm = function(charCode) {
    return (0xFF01 <= charCode && charCode <= 0xFF5E) || (0xFFE0 <= charCode && charCode <= 0xFFE6);
  };

  isDoubleWidthCharacter = function(character) {
    var charCode;
    charCode = character.charCodeAt(0);
    return IsJapaneseKanaCharacter(charCode) || isCJKUnifiedIdeograph(charCode) || isFullWidthForm(charCode);
  };

  isHalfWidthCharacter = function(character) {
    var charCode;
    charCode = character.charCodeAt(0);
    return (0xFF65 <= charCode && charCode <= 0xFFDC) || (0xFFE8 <= charCode && charCode <= 0xFFEE);
  };

  isKoreanCharacter = function(character) {
    var charCode;
    charCode = character.charCodeAt(0);
    return (0xAC00 <= charCode && charCode <= 0xD7A3) || (0x1100 <= charCode && charCode <= 0x11FF) || (0x3130 <= charCode && charCode <= 0x318F) || (0xA960 <= charCode && charCode <= 0xA97F) || (0xD7B0 <= charCode && charCode <= 0xD7FF);
  };

  isCJKCharacter = function(character) {
    return isDoubleWidthCharacter(character) || isHalfWidthCharacter(character) || isKoreanCharacter(character);
  };

  isWordStart = function(previousCharacter, character) {
    return (previousCharacter === ' ' || previousCharacter === '\t') && (character !== ' ' && character !== '\t');
  };

  isWrapBoundary = function(previousCharacter, character) {
    return isWordStart(previousCharacter, character) || isCJKCharacter(character);
  };

  hasPairedCharacter = function(string) {
    var index;
    index = 0;
    while (index < string.length) {
      if (isPairedCharacter(string, index)) {
        return true;
      }
      index++;
    }
    return false;
  };

  module.exports = {
    isPairedCharacter: isPairedCharacter,
    hasPairedCharacter: hasPairedCharacter,
    isDoubleWidthCharacter: isDoubleWidthCharacter,
    isHalfWidthCharacter: isHalfWidthCharacter,
    isKoreanCharacter: isKoreanCharacter,
    isWrapBoundary: isWrapBoundary
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
