(function() {
  var BufferedProcess, ProgressElement;

  BufferedProcess = require('atom').BufferedProcess;

  ProgressElement = require('./progress-element');

  module.exports = {
    activate: function() {
      return atom.commands.add("atom-workspace", 'update-package-dependencies:update', (function(_this) {
        return function() {
          return _this.update();
        };
      })(this));
    },
    update: function() {
      var args, command, exit, options, panel, view;
      view = new ProgressElement;
      view.displayLoading();
      panel = atom.workspace.addModalPanel({
        item: view
      });
      command = atom.packages.getApmPath();
      args = ['install'];
      options = {
        cwd: this.getActiveProjectPath()
      };
      exit = function(code) {
        view.element.focus();
        atom.commands.add(view.element, 'core:cancel', function() {
          return panel.destroy();
        });
        if (code === 0) {
          atom.notifications.addSuccess("Success!", {
            detail: "Package dependencies updated."
          });
          return panel.destroy();
        } else {
          atom.notifications.addError("Error!", {
            detail: "Failed to update package dependencies."
          });
          return panel.destroy();
        }
      };
      return this.runBufferedProcess({
        command: command,
        args: args,
        exit: exit,
        options: options
      });
    },
    runBufferedProcess: function(params) {
      return new BufferedProcess(params);
    },
    getActiveProjectPath: function() {
      var activeItemPath, ref;
      if (activeItemPath = (ref = atom.workspace.getActivePaneItem()) != null ? typeof ref.getPath === "function" ? ref.getPath() : void 0 : void 0) {
        return atom.project.relativizePath(activeItemPath)[0];
      } else {
        return atom.project.getPaths()[0];
      }
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
