Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var TagGenerator = (function () {
  function TagGenerator(path1, scopeName) {
    _classCallCheck(this, TagGenerator);

    this.path = path1;
    this.scopeName = scopeName;
  }

  _createClass(TagGenerator, [{
    key: 'getPackageRoot',
    value: function getPackageRoot() {
      var _atom$getLoadSettings = atom.getLoadSettings();

      var resourcePath = _atom$getLoadSettings.resourcePath;

      var currentFileWasRequiredFromSnapshot = !_fsPlus2['default'].isAbsolute(__dirname);
      if (currentFileWasRequiredFromSnapshot) {
        return _path2['default'].join(resourcePath, 'node_modules', 'symbols-view');
      } else {
        var packageRoot = _path2['default'].resolve(__dirname, '..');
        if (_path2['default'].extname(resourcePath) === '.asar') {
          if (packageRoot.indexOf(resourcePath) === 0) {
            return _path2['default'].join(resourcePath + '.unpacked', 'node_modules', 'symbols-view');
          }
        }
        return packageRoot;
      }
    }
  }, {
    key: 'parseTagLine',
    value: function parseTagLine(line) {
      var sections = line.split('\t');
      if (sections.length > 3) {
        return {
          position: new _atom.Point(parseInt(sections[2], 10) - 1),
          name: sections[0]
        };
      }
      return null;
    }
  }, {
    key: 'getLanguage',
    value: function getLanguage() {
      if (['.cson', '.gyp'].includes(_path2['default'].extname(this.path))) {
        return 'Cson';
      }

      switch (this.scopeName) {
        case 'source.c':
          return 'C';
        case 'source.cpp':
          return 'C++';
        case 'source.clojure':
          return 'Lisp';
        case 'source.capnp':
          return 'Capnp';
        case 'source.coffee':
          return 'CoffeeScript';
        case 'source.css':
          return 'Css';
        case 'source.css.less':
          return 'Css';
        case 'source.css.scss':
          return 'Css';
        case 'source.elixir':
          return 'Elixir';
        case 'source.fountain':
          return 'Fountain';
        case 'source.gfm':
          return 'Markdown';
        case 'source.go':
          return 'Go';
        case 'source.java':
          return 'Java';
        case 'source.js':
          return 'JavaScript';
        case 'source.js.jsx':
          return 'JavaScript';
        case 'source.jsx':
          return 'JavaScript';
        case 'source.json':
          return 'Json';
        case 'source.julia':
          return 'Julia';
        case 'source.makefile':
          return 'Make';
        case 'source.objc':
          return 'C';
        case 'source.objcpp':
          return 'C++';
        case 'source.python':
          return 'Python';
        case 'source.ruby':
          return 'Ruby';
        case 'source.sass':
          return 'Sass';
        case 'source.yaml':
          return 'Yaml';
        case 'text.html':
          return 'Html';
        case 'text.html.php':
          return 'Php';
        case 'text.tex.latex':
          return 'Latex';
      }
      return undefined;
    }
  }, {
    key: 'generate',
    value: function generate() {
      var _this = this;

      var tags = {};
      var packageRoot = this.getPackageRoot();
      var command = _path2['default'].join(packageRoot, 'vendor', 'ctags-' + process.platform);
      var defaultCtagsFile = _path2['default'].join(packageRoot, 'lib', 'ctags-config');
      var args = ['--options=' + defaultCtagsFile, '--fields=+KS'];

      if (atom.config.get('symbols-view.useEditorGrammarAsCtagsLanguage')) {
        var language = this.getLanguage();
        if (language) {
          args.push('--language-force=' + language);
        }
      }

      args.push('-nf', '-', this.path);

      return new Promise(function (resolve) {
        var result = undefined,
            tag = undefined;
        return new _atom.BufferedProcess({
          command: command,
          args: args,
          stdout: function stdout(lines) {
            return (function () {
              result = [];
              for (var line of Array.from(lines.split('\n'))) {
                var item = undefined;
                if (tag = _this.parseTagLine(line)) {
                  item = tags[tag.position.row] ? tags[tag.position.row] : tags[tag.position.row] = tag;
                }
                result.push(item);
              }
              return result;
            })();
          },
          stderr: function stderr() {},
          exit: function exit() {
            tags = (function () {
              result = [];
              for (var row in tags) {
                tag = tags[row];
                result.push(tag);
              }
              return result;
            })();
            return resolve(tags);
          }
        });
      });
    }
  }]);

  return TagGenerator;
})();

exports['default'] = TagGenerator;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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