(function() {
  var CursorPositionView, Disposable;

  Disposable = require('atom').Disposable;

  module.exports = CursorPositionView = (function() {
    function CursorPositionView() {
      var ref;
      this.viewUpdatePending = false;
      this.element = document.createElement('status-bar-cursor');
      this.element.classList.add('cursor-position', 'inline-block');
      this.goToLineLink = document.createElement('a');
      this.goToLineLink.classList.add('inline-block');
      this.goToLineLink.href = '#';
      this.element.appendChild(this.goToLineLink);
      this.formatString = (ref = atom.config.get('status-bar.cursorPositionFormat')) != null ? ref : '%L:%C';
      if (atom.workspace.onDidChangeActiveTextEditor) {
        this.activeItemSubscription = atom.workspace.onDidChangeActiveTextEditor((function(_this) {
          return function(activeEditor) {
            return _this.subscribeToActiveTextEditor();
          };
        })(this));
      } else {
        this.activeItemSubscription = atom.workspace.onDidChangeActivePaneItem((function(_this) {
          return function(activeItem) {
            return _this.subscribeToActiveTextEditor();
          };
        })(this));
      }
      this.subscribeToConfig();
      this.subscribeToActiveTextEditor();
      this.tooltip = atom.tooltips.add(this.element, {
        title: (function(_this) {
          return function() {
            return "Line " + _this.row + ", Column " + _this.column;
          };
        })(this)
      });
      this.handleClick();
    }

    CursorPositionView.prototype.destroy = function() {
      var ref, ref1, ref2;
      this.activeItemSubscription.dispose();
      if ((ref = this.cursorSubscription) != null) {
        ref.dispose();
      }
      this.tooltip.dispose();
      if ((ref1 = this.configSubscription) != null) {
        ref1.dispose();
      }
      this.clickSubscription.dispose();
      return (ref2 = this.updateSubscription) != null ? ref2.dispose() : void 0;
    };

    CursorPositionView.prototype.subscribeToActiveTextEditor = function() {
      var activeEditor, ref, selectionsMarkerLayer;
      if ((ref = this.cursorSubscription) != null) {
        ref.dispose();
      }
      activeEditor = this.getActiveTextEditor();
      selectionsMarkerLayer = activeEditor != null ? activeEditor.selectionsMarkerLayer : void 0;
      this.cursorSubscription = selectionsMarkerLayer != null ? selectionsMarkerLayer.onDidUpdate(this.scheduleUpdate.bind(this)) : void 0;
      return this.scheduleUpdate();
    };

    CursorPositionView.prototype.subscribeToConfig = function() {
      var ref;
      if ((ref = this.configSubscription) != null) {
        ref.dispose();
      }
      return this.configSubscription = atom.config.observe('status-bar.cursorPositionFormat', (function(_this) {
        return function(value) {
          _this.formatString = value != null ? value : '%L:%C';
          return _this.scheduleUpdate();
        };
      })(this));
    };

    CursorPositionView.prototype.handleClick = function() {
      var clickHandler;
      clickHandler = (function(_this) {
        return function() {
          return atom.commands.dispatch(atom.views.getView(_this.getActiveTextEditor()), 'go-to-line:toggle');
        };
      })(this);
      this.element.addEventListener('click', clickHandler);
      return this.clickSubscription = new Disposable((function(_this) {
        return function() {
          return _this.element.removeEventListener('click', clickHandler);
        };
      })(this));
    };

    CursorPositionView.prototype.getActiveTextEditor = function() {
      return atom.workspace.getActiveTextEditor();
    };

    CursorPositionView.prototype.scheduleUpdate = function() {
      if (this.viewUpdatePending) {
        return;
      }
      this.viewUpdatePending = true;
      return this.updateSubscription = atom.views.updateDocument((function(_this) {
        return function() {
          var position, ref;
          _this.viewUpdatePending = false;
          if (position = (ref = _this.getActiveTextEditor()) != null ? ref.getCursorBufferPosition() : void 0) {
            _this.row = position.row + 1;
            _this.column = position.column + 1;
            _this.goToLineLink.textContent = _this.formatString.replace('%L', _this.row).replace('%C', _this.column);
            return _this.element.classList.remove('hide');
          } else {
            _this.goToLineLink.textContent = '';
            return _this.element.classList.add('hide');
          }
        };
      })(this));
    };

    return CursorPositionView;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
