(function() {
  var SpellCheckTask, idCounter;

  idCounter = 0;

  module.exports = SpellCheckTask = (function() {
    SpellCheckTask.handler = null;

    SpellCheckTask.callbacksById = {};

    function SpellCheckTask(task) {
      this.task = task;
      this.id = idCounter++;
    }

    SpellCheckTask.prototype.terminate = function() {
      return delete this.constructor.callbacksById[this.id];
    };

    SpellCheckTask.prototype.start = function(buffer) {
      var args, projectPath, ref, ref1, ref2, relativePath;
      projectPath = null;
      relativePath = null;
      if (buffer != null ? (ref = buffer.file) != null ? ref.path : void 0 : void 0) {
        ref1 = atom.project.relativizePath(buffer.file.path), projectPath = ref1[0], relativePath = ref1[1];
      }
      args = {
        id: this.id,
        projectPath: projectPath,
        relativePath: relativePath,
        text: buffer.getText()
      };
      return (ref2 = this.task) != null ? ref2.start(args, this.constructor.dispatchMisspellings) : void 0;
    };

    SpellCheckTask.prototype.onDidSpellCheck = function(callback) {
      return this.constructor.callbacksById[this.id] = callback;
    };

    SpellCheckTask.dispatchMisspellings = function(data) {
      var base, name;
      return typeof (base = SpellCheckTask.callbacksById)[name = data.id] === "function" ? base[name](data.misspellings) : void 0;
    };

    return SpellCheckTask;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
