(function() {
  var SpellCheckView, Task, spellCheckViews,
    indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  Task = require('atom').Task;

  SpellCheckView = null;

  spellCheckViews = {};

  module.exports = {
    activate: function() {
      var handlerFilename, that;
      handlerFilename = require.resolve('./spell-check-handler');
      if (this.task == null) {
        this.task = new Task(handlerFilename);
      }
      that = this;
      this.task.on("spell-check:settings-changed", function(ignore) {
        return that.updateViews();
      });
      this.globalArgs = {
        locales: atom.config.get('spell-check.locales'),
        localePaths: atom.config.get('spell-check.localePaths'),
        useLocales: atom.config.get('spell-check.useLocales'),
        knownWords: atom.config.get('spell-check.knownWords'),
        addKnownWords: atom.config.get('spell-check.addKnownWords'),
        checkerPaths: []
      };
      this.sendGlobalArgs();
      atom.config.onDidChange('spell-check.locales', function(arg) {
        var newValue, oldValue;
        newValue = arg.newValue, oldValue = arg.oldValue;
        that.globalArgs.locales = newValue;
        return that.sendGlobalArgs();
      });
      atom.config.onDidChange('spell-check.localePaths', function(arg) {
        var newValue, oldValue;
        newValue = arg.newValue, oldValue = arg.oldValue;
        that.globalArgs.localePaths = newValue;
        return that.sendGlobalArgs();
      });
      atom.config.onDidChange('spell-check.useLocales', function(arg) {
        var newValue, oldValue;
        newValue = arg.newValue, oldValue = arg.oldValue;
        that.globalArgs.useLocales = newValue;
        return that.sendGlobalArgs();
      });
      atom.config.onDidChange('spell-check.knownWords', function(arg) {
        var newValue, oldValue;
        newValue = arg.newValue, oldValue = arg.oldValue;
        that.globalArgs.knownWords = newValue;
        return that.sendGlobalArgs();
      });
      atom.config.onDidChange('spell-check.addKnownWords', function(arg) {
        var newValue, oldValue;
        newValue = arg.newValue, oldValue = arg.oldValue;
        that.globalArgs.addKnownWords = newValue;
        return that.sendGlobalArgs();
      });
      this.commandSubscription = atom.commands.add('atom-workspace', {
        'spell-check:toggle': (function(_this) {
          return function() {
            return _this.toggle();
          };
        })(this)
      });
      this.viewsByEditor = new WeakMap;
      this.contextMenuEntries = [];
      return this.disposable = atom.workspace.observeTextEditors((function(_this) {
        return function(editor) {
          var editorId, spellCheckView;
          if (editor.largeFileMode) {
            return;
          }
          if (SpellCheckView == null) {
            SpellCheckView = require('./spell-check-view');
          }
          spellCheckView = new SpellCheckView(editor, _this.task, _this, function() {
            return _this.getInstance(_this.globalArgs);
          });
          editorId = editor.id;
          spellCheckViews[editorId] = {};
          spellCheckViews[editorId]['view'] = spellCheckView;
          spellCheckViews[editorId]['active'] = true;
          spellCheckViews[editorId]['editor'] = editor;
          return _this.viewsByEditor.set(editor, spellCheckView);
        };
      })(this));
    },
    deactivate: function() {
      var editorId, ref, ref1, view;
      if ((ref = this.instance) != null) {
        ref.deactivate();
      }
      this.instance = null;
      if ((ref1 = this.task) != null) {
        ref1.terminate();
      }
      this.task = null;
      this.commandSubscription.dispose();
      this.commandSubscription = null;
      for (editorId in spellCheckViews) {
        view = spellCheckViews[editorId].view;
        view.destroy();
      }
      spellCheckViews = {};
      this.viewsByEditor = new WeakMap;
      return this.disposable.dispose();
    },
    consumeSpellCheckers: function(checkerPaths) {
      var checkerPath, i, len, ref, ref1, results;
      if (!(checkerPaths instanceof Array)) {
        checkerPaths = [checkerPaths];
      }
      results = [];
      for (i = 0, len = checkerPaths.length; i < len; i++) {
        checkerPath = checkerPaths[i];
        if (indexOf.call(this.globalArgs.checkerPaths, checkerPath) < 0) {
          if ((ref = this.task) != null) {
            ref.send({
              type: "checker",
              checkerPath: checkerPath
            });
          }
          if ((ref1 = this.instance) != null) {
            ref1.addCheckerPath(checkerPath);
          }
          results.push(this.globalArgs.checkerPaths.push(checkerPath));
        } else {
          results.push(void 0);
        }
      }
      return results;
    },
    misspellingMarkersForEditor: function(editor) {
      return this.viewsByEditor.get(editor).markerLayer.getMarkers();
    },
    updateViews: function() {
      var editorId, results, view;
      results = [];
      for (editorId in spellCheckViews) {
        view = spellCheckViews[editorId];
        if (view['active']) {
          results.push(view['view'].updateMisspellings());
        } else {
          results.push(void 0);
        }
      }
      return results;
    },
    sendGlobalArgs: function() {
      return this.task.send({
        type: "global",
        global: this.globalArgs
      });
    },
    getInstance: function(globalArgs) {
      var SpellCheckerManager, checkerPath, i, len, ref;
      if (!this.instance) {
        SpellCheckerManager = require('./spell-check-manager');
        this.instance = SpellCheckerManager;
        this.instance.setGlobalArgs(globalArgs);
        ref = globalArgs.checkerPaths;
        for (i = 0, len = ref.length; i < len; i++) {
          checkerPath = ref[i];
          this.instance.addCheckerPath(checkerPath);
        }
      }
      return this.instance;
    },
    toggle: function() {
      var editorId;
      if (!atom.workspace.getActiveTextEditor()) {
        return;
      }
      editorId = atom.workspace.getActiveTextEditor().id;
      if (spellCheckViews[editorId]['active']) {
        spellCheckViews[editorId]['active'] = false;
        return spellCheckViews[editorId]['view'].unsubscribeFromBuffer();
      } else {
        spellCheckViews[editorId]['active'] = true;
        return spellCheckViews[editorId]['view'].subscribeToBuffer();
      }
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
