(function() {
  var ownerFromRepository, packageComparatorAscending;

  ownerFromRepository = function(repository) {
    var loginRegex, ref, ref1, repo, repoName;
    if (!repository) {
      return '';
    }
    loginRegex = /github\.com\/([\w-]+)\/.+/;
    if (typeof repository === "string") {
      repo = repository;
    } else {
      repo = repository.url;
      if (repo.match('git@github')) {
        repoName = repo.split(':')[1];
        repo = "https://github.com/" + repoName;
      }
    }
    if (!repo.match("github.com/")) {
      repo = "https://github.com/" + repo;
    }
    return (ref = (ref1 = repo.match(loginRegex)) != null ? ref1[1] : void 0) != null ? ref : '';
  };

  packageComparatorAscending = function(left, right) {
    var leftStatus, rightStatus;
    leftStatus = atom.packages.isPackageDisabled(left.name);
    rightStatus = atom.packages.isPackageDisabled(right.name);
    if (leftStatus === rightStatus) {
      if (left.name > right.name) {
        return -1;
      } else if (left.name < right.name) {
        return 1;
      } else {
        return 0;
      }
    } else if (leftStatus > rightStatus) {
      return -1;
    } else {
      return 1;
    }
  };

  module.exports = {
    ownerFromRepository: ownerFromRepository,
    packageComparatorAscending: packageComparatorAscending
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
