Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/** @babel */
/** @jsx etch.dom */

var _fuzzaldrin = require('fuzzaldrin');

var _fuzzaldrin2 = _interopRequireDefault(_fuzzaldrin);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _collapsibleSectionPanel = require('./collapsible-section-panel');

var _collapsibleSectionPanel2 = _interopRequireDefault(_collapsibleSectionPanel);

var _packageCard = require('./package-card');

var _packageCard2 = _interopRequireDefault(_packageCard);

var _errorView = require('./error-view');

var _errorView2 = _interopRequireDefault(_errorView);

var _list = require('./list');

var _list2 = _interopRequireDefault(_list);

var _listView = require('./list-view');

var _listView2 = _interopRequireDefault(_listView);

var _utils = require('./utils');

var ThemesPanel = (function (_CollapsibleSectionPanel) {
  _inherits(ThemesPanel, _CollapsibleSectionPanel);

  _createClass(ThemesPanel, null, [{
    key: 'loadPackagesDelay',
    value: function loadPackagesDelay() {
      return 300;
    }
  }]);

  function ThemesPanel(settingsView, packageManager) {
    var _this = this;

    _classCallCheck(this, ThemesPanel);

    _get(Object.getPrototypeOf(ThemesPanel.prototype), 'constructor', this).call(this);

    this.settingsView = settingsView;
    this.packageManager = packageManager;
    _etch2['default'].initialize(this);
    this.items = {
      dev: new _list2['default']('name'),
      core: new _list2['default']('name'),
      user: new _list2['default']('name'),
      git: new _list2['default']('name')
    };
    this.itemViews = {
      dev: new _listView2['default'](this.items.dev, this.refs.devPackages, this.createPackageCard.bind(this)),
      core: new _listView2['default'](this.items.core, this.refs.corePackages, this.createPackageCard.bind(this)),
      user: new _listView2['default'](this.items.user, this.refs.communityPackages, this.createPackageCard.bind(this)),
      git: new _listView2['default'](this.items.git, this.refs.gitPackages, this.createPackageCard.bind(this))
    };

    this.disposables = new _atom.CompositeDisposable();
    this.disposables.add(this.packageManager.on('theme-install-failed theme-uninstall-failed', function (_ref) {
      var pack = _ref.pack;
      var error = _ref.error;

      _this.refs.themeErrors.appendChild(new _errorView2['default'](_this.packageManager, error).element);
    }));
    this.disposables.add(this.handleEvents());
    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));
    this.loadPackages();

    this.disposables.add(this.packageManager.on('theme-installed theme-uninstalled', function () {
      var loadPackagesTimeout = undefined;
      clearTimeout(loadPackagesTimeout);
      loadPackagesTimeout = setTimeout(function () {
        _this.populateThemeMenus();
        _this.loadPackages();
      }, ThemesPanel.loadPackagesDelay());
    }));

    this.disposables.add(atom.themes.onDidChangeActiveThemes(function () {
      return _this.updateActiveThemes();
    }));
    this.disposables.add(atom.tooltips.add(this.refs.activeUiThemeSettings, { title: 'Settings' }));
    this.disposables.add(atom.tooltips.add(this.refs.activeSyntaxThemeSettings, { title: 'Settings' }));
    this.updateActiveThemes();

    this.disposables.add(this.refs.filterEditor.onDidStopChanging(function () {
      _this.matchPackages();
    }));
  }

  _createClass(ThemesPanel, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'focus',
    value: function focus() {
      this.refs.filterEditor.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'panels-item', tabIndex: '-1' },
        _etch2['default'].dom(
          'div',
          { className: 'section packages themes-panel' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container' },
            _etch2['default'].dom(
              'div',
              { className: 'section-heading icon icon-paintcan' },
              'Choose a Theme'
            ),
            _etch2['default'].dom(
              'div',
              { className: 'text native-key-bindings', tabIndex: '-1' },
              _etch2['default'].dom(
                'span',
                { className: 'icon icon-question' },
                'You can also style Atom by editing '
              ),
              _etch2['default'].dom(
                'a',
                { className: 'link', onclick: this.didClickOpenUserStyleSheet },
                'your stylesheet'
              )
            ),
            _etch2['default'].dom(
              'div',
              { className: 'themes-picker' },
              _etch2['default'].dom(
                'div',
                { className: 'themes-picker-item control-group' },
                _etch2['default'].dom(
                  'div',
                  { className: 'controls' },
                  _etch2['default'].dom(
                    'label',
                    { className: 'control-label' },
                    _etch2['default'].dom(
                      'div',
                      { className: 'setting-title themes-label text' },
                      'UI Theme'
                    ),
                    _etch2['default'].dom(
                      'div',
                      { className: 'setting-description text theme-description' },
                      'This styles the tabs, status bar, tree view, and dropdowns'
                    )
                  ),
                  _etch2['default'].dom(
                    'div',
                    { className: 'select-container' },
                    _etch2['default'].dom('select', { ref: 'uiMenu', className: 'form-control', onchange: this.didChangeUiMenu.bind(this) }),
                    _etch2['default'].dom('button', {
                      ref: 'activeUiThemeSettings',
                      className: 'btn icon icon-gear active-theme-settings',
                      onclick: this.didClickActiveUiThemeSettings.bind(this) })
                  )
                )
              ),
              _etch2['default'].dom(
                'div',
                { className: 'themes-picker-item control-group' },
                _etch2['default'].dom(
                  'div',
                  { className: 'controls' },
                  _etch2['default'].dom(
                    'label',
                    { className: 'control-label' },
                    _etch2['default'].dom(
                      'div',
                      { className: 'setting-title themes-label text' },
                      'Syntax Theme'
                    ),
                    _etch2['default'].dom(
                      'div',
                      { className: 'setting-description text theme-description' },
                      'This styles the text inside the editor'
                    )
                  ),
                  _etch2['default'].dom(
                    'div',
                    { className: 'select-container' },
                    _etch2['default'].dom('select', { ref: 'syntaxMenu', className: 'form-control', onchange: this.didChangeSyntaxMenu.bind(this) }),
                    _etch2['default'].dom('button', {
                      ref: 'activeSyntaxThemeSettings',
                      className: 'btn icon icon-gear active-syntax-settings',
                      onclick: this.didClickActiveSyntaxThemeSettings.bind(this) })
                  )
                )
              )
            )
          )
        ),
        _etch2['default'].dom(
          'section',
          { className: 'section' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container' },
            _etch2['default'].dom(
              'div',
              { className: 'section-heading icon icon-paintcan' },
              'Installed Themes',
              _etch2['default'].dom(
                'span',
                { ref: 'totalPackages', className: 'section-heading-count badge badge-flexible' },
                '…'
              )
            ),
            _etch2['default'].dom(
              'div',
              { className: 'editor-container' },
              _etch2['default'].dom(_atom.TextEditor, { ref: 'filterEditor', mini: true, placeholderText: 'Filter themes by name' })
            ),
            _etch2['default'].dom('div', { ref: 'themeErrors' }),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section installed-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'communityThemesHeader', className: 'sub-section-heading icon icon-paintcan' },
                'Community Themes',
                _etch2['default'].dom(
                  'span',
                  { ref: 'communityCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'communityPackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'communityLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading themes…'
                )
              )
            ),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section core-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'coreThemesHeader', className: 'sub-section-heading icon icon-paintcan' },
                'Core Themes',
                _etch2['default'].dom(
                  'span',
                  { ref: 'coreCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'corePackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'coreLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading themes…'
                )
              )
            ),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section dev-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'developmentThemesHeader', className: 'sub-section-heading icon icon-paintcan' },
                'Development Themes',
                _etch2['default'].dom(
                  'span',
                  { ref: 'devCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'devPackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'devLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading themes…'
                )
              )
            ),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section git-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'gitThemesHeader', className: 'sub-section-heading icon icon-paintcan' },
                'Git Themes',
                _etch2['default'].dom(
                  'span',
                  { ref: 'gitCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'gitPackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'gitLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading themes…'
                )
              )
            )
          )
        )
      );
    }
  }, {
    key: 'filterThemes',
    value: function filterThemes(packages) {
      packages.dev = packages.dev.filter(function (_ref2) {
        var theme = _ref2.theme;
        return theme;
      });
      packages.user = packages.user.filter(function (_ref3) {
        var theme = _ref3.theme;
        return theme;
      });
      packages.core = packages.core.filter(function (_ref4) {
        var theme = _ref4.theme;
        return theme;
      });
      packages.git = (packages.git || []).filter(function (_ref5) {
        var theme = _ref5.theme;
        return theme;
      });

      for (var pack of packages.core) {
        if (pack.repository == null) {
          pack.repository = 'https://github.com/atom/' + pack.name;
        }
      }

      for (var packageType of ['dev', 'core', 'user', 'git']) {
        for (var pack of packages[packageType]) {
          pack.owner = (0, _utils.ownerFromRepository)(pack.repository);
        }
      }
      return packages;
    }
  }, {
    key: 'sortThemes',
    value: function sortThemes(packages) {
      packages.dev.sort(_utils.packageComparatorAscending);
      packages.core.sort(_utils.packageComparatorAscending);
      packages.user.sort(_utils.packageComparatorAscending);
      packages.git.sort(_utils.packageComparatorAscending);
      return packages;
    }
  }, {
    key: 'loadPackages',
    value: function loadPackages() {
      var _this2 = this;

      this.packageViews = [];
      this.packageManager.getInstalled().then(function (packages) {
        _this2.packages = _this2.sortThemes(_this2.filterThemes(packages));

        _this2.refs.devLoadingArea.remove();
        _this2.items.dev.setItems(_this2.packages.dev);

        _this2.refs.coreLoadingArea.remove();
        _this2.items.core.setItems(_this2.packages.core);

        _this2.refs.communityLoadingArea.remove();
        _this2.items.user.setItems(_this2.packages.user);

        _this2.refs.gitLoadingArea.remove();
        _this2.items.git.setItems(_this2.packages.git);

        // TODO show empty mesage per section

        _this2.updateSectionCounts();
      })['catch'](function (error) {
        _this2.refs.themeErrors.appendChild(new _errorView2['default'](_this2.packageManager, error).element);
      });
    }

    // Update the active UI and syntax themes and populate the menu
  }, {
    key: 'updateActiveThemes',
    value: function updateActiveThemes() {
      this.activeUiTheme = this.getActiveUiTheme();
      this.activeSyntaxTheme = this.getActiveSyntaxTheme();
      this.populateThemeMenus();
      this.toggleActiveThemeButtons();
    }
  }, {
    key: 'toggleActiveThemeButtons',
    value: function toggleActiveThemeButtons() {
      if (this.hasSettings(this.activeUiTheme)) {
        this.refs.activeUiThemeSettings.style.display = '';
      } else {
        this.refs.activeUiThemeSettings.style.display = 'none';
      }

      if (this.hasSettings(this.activeSyntaxTheme)) {
        this.refs.activeSyntaxThemeSettings.display = '';
      } else {
        this.refs.activeSyntaxThemeSettings.display = 'none';
      }
    }
  }, {
    key: 'hasSettings',
    value: function hasSettings(packageName) {
      return this.packageManager.packageHasSettings(packageName);
    }

    // Populate the theme menus from the theme manager's active themes
  }, {
    key: 'populateThemeMenus',
    value: function populateThemeMenus() {
      this.refs.uiMenu.innerHTML = "";
      this.refs.syntaxMenu.innerHTML = "";
      var availableThemes = _underscorePlus2['default'].sortBy(atom.themes.getLoadedThemes(), 'name');
      for (var _ref62 of availableThemes) {
        var _name = _ref62.name;
        var metadata = _ref62.metadata;

        switch (metadata.theme) {
          case 'ui':
            {
              var themeItem = this.createThemeMenuItem(_name);
              if (_name === this.activeUiTheme) {
                themeItem.selected = true;
              }
              this.refs.uiMenu.appendChild(themeItem);
              break;
            }
          case 'syntax':
            {
              var themeItem = this.createThemeMenuItem(_name);
              if (_name === this.activeSyntaxTheme) {
                themeItem.selected = true;
              }
              this.refs.syntaxMenu.appendChild(themeItem);
              break;
            }
        }
      }
    }

    // Get the name of the active ui theme.
  }, {
    key: 'getActiveUiTheme',
    value: function getActiveUiTheme() {
      for (var _ref72 of atom.themes.getActiveThemes()) {
        var _name2 = _ref72.name;
        var metadata = _ref72.metadata;

        if (metadata.theme === 'ui') {
          return _name2;
        }
      }
      return null;
    }

    // Get the name of the active syntax theme.
  }, {
    key: 'getActiveSyntaxTheme',
    value: function getActiveSyntaxTheme() {
      for (var _ref82 of atom.themes.getActiveThemes()) {
        var _name3 = _ref82.name;
        var metadata = _ref82.metadata;

        if (metadata.theme === 'syntax') {
          return _name3;
        }
      }
      return null;
    }

    // Update the config with the selected themes
  }, {
    key: 'updateThemeConfig',
    value: function updateThemeConfig() {
      var themes = [];
      if (this.activeUiTheme) {
        themes.push(this.activeUiTheme);
      }
      if (this.activeSyntaxTheme) {
        themes.push(this.activeSyntaxTheme);
      }
      if (themes.length > 0) {
        atom.config.set("core.themes", themes);
      }
    }
  }, {
    key: 'scheduleUpdateThemeConfig',
    value: function scheduleUpdateThemeConfig() {
      var _this3 = this;

      setTimeout(function () {
        _this3.updateThemeConfig();
      }, 100);
    }

    // Create a menu item for the given theme name.
  }, {
    key: 'createThemeMenuItem',
    value: function createThemeMenuItem(themeName) {
      var title = _underscorePlus2['default'].undasherize(_underscorePlus2['default'].uncamelcase(themeName.replace(/-(ui|syntax)/g, '').replace(/-theme$/g, '')));
      var option = document.createElement('option');
      option.value = themeName;
      option.textContent = title;
      return option;
    }
  }, {
    key: 'createPackageCard',
    value: function createPackageCard(pack) {
      return new _packageCard2['default'](pack, this.settingsView, this.packageManager, { back: 'Themes' });
    }
  }, {
    key: 'filterPackageListByText',
    value: function filterPackageListByText(text) {
      if (!this.packages) {
        return;
      }

      for (var packageType of ['dev', 'core', 'user', 'git']) {
        var allViews = this.itemViews[packageType].getViews();
        var activeViews = this.itemViews[packageType].filterViews(function (pack) {
          if (text === '') {
            return true;
          } else {
            var owner = pack.owner != null ? pack.owner : (0, _utils.ownerFromRepository)(pack.repository);
            var filterText = pack.name + ' ' + owner;
            return _fuzzaldrin2['default'].score(filterText, text) > 0;
          }
        });

        for (var view of allViews) {
          if (view) {
            view.element.style.display = 'none';
            view.element.classList.add('hidden');
          }
        }

        for (var view of activeViews) {
          if (view) {
            view.element.style.display = '';
            view.element.classList.remove('hidden');
          }
        }
      }

      this.updateSectionCounts();
    }
  }, {
    key: 'updateUnfilteredSectionCounts',
    value: function updateUnfilteredSectionCounts() {
      this.updateSectionCount(this.refs.communityThemesHeader, this.refs.communityCount, this.packages.user.length);
      this.updateSectionCount(this.refs.coreThemesHeader, this.refs.coreCount, this.packages.core.length);
      this.updateSectionCount(this.refs.developmentThemesHeader, this.refs.devCount, this.packages.dev.length);
      this.updateSectionCount(this.refs.gitThemesHeader, this.refs.gitCount, this.packages.git.length);

      this.refs.totalPackages.textContent = '' + (this.packages.user.length + this.packages.core.length + this.packages.dev.length + this.packages.git.length);
    }
  }, {
    key: 'updateFilteredSectionCounts',
    value: function updateFilteredSectionCounts() {
      var community = this.notHiddenCardsLength(this.refs.communityPackages);
      this.updateSectionCount(this.refs.communityThemesHeader, this.refs.communityCount, community, this.packages.user.length);

      var dev = this.notHiddenCardsLength(this.refs.devPackages);
      this.updateSectionCount(this.refs.developmentThemesHeader, this.refs.devCount, dev, this.packages.dev.length);

      var core = this.notHiddenCardsLength(this.refs.corePackages);
      this.updateSectionCount(this.refs.coreThemesHeader, this.refs.coreCount, core, this.packages.core.length);

      var git = this.notHiddenCardsLength(this.refs.gitPackages);
      this.updateSectionCount(this.refs.gitThemesHeader, this.refs.gitCount, git, this.packages.git.length);

      var shownThemes = dev + core + community + git;
      var totalThemes = this.packages.user.length + this.packages.core.length + this.packages.dev.length + this.packages.git.length;
      this.refs.totalPackages.textContent = shownThemes + '/' + totalThemes;
    }
  }, {
    key: 'resetSectionHasItems',
    value: function resetSectionHasItems() {
      this.resetCollapsibleSections([this.refs.communityThemesHeader, this.refs.coreThemesHeader, this.refs.developmentThemesHeader, this.refs.gitThemesHeader]);
    }
  }, {
    key: 'matchPackages',
    value: function matchPackages() {
      this.filterPackageListByText(this.refs.filterEditor.getText());
    }
  }, {
    key: 'didClickOpenUserStyleSheet',
    value: function didClickOpenUserStyleSheet(e) {
      e.preventDefault();
      atom.commands.dispatch(atom.views.getView(atom.workspace), 'application:open-your-stylesheet');
    }
  }, {
    key: 'didChangeUiMenu',
    value: function didChangeUiMenu() {
      this.activeUiTheme = this.refs.uiMenu.value;
      this.scheduleUpdateThemeConfig();
    }
  }, {
    key: 'didChangeSyntaxMenu',
    value: function didChangeSyntaxMenu() {
      this.activeSyntaxTheme = this.refs.syntaxMenu.value;
      this.scheduleUpdateThemeConfig();
    }
  }, {
    key: 'didClickActiveUiThemeSettings',
    value: function didClickActiveUiThemeSettings(event) {
      event.stopPropagation();
      var theme = atom.themes.getActiveThemes().find(function (theme) {
        return theme.metadata.theme === 'ui';
      });
      var activeUiTheme = theme != null ? theme.metadata : null;
      if (activeUiTheme != null) {
        this.settingsView.showPanel(this.activeUiTheme, {
          back: 'Themes',
          pack: activeUiTheme
        });
      }
    }
  }, {
    key: 'didClickActiveSyntaxThemeSettings',
    value: function didClickActiveSyntaxThemeSettings(event) {
      event.stopPropagation();
      var theme = atom.themes.getActiveThemes().find(function (theme) {
        return theme.metadata.theme === 'syntax';
      });
      var activeSyntaxTheme = theme != null ? theme.metadata : null;
      if (activeSyntaxTheme != null) {
        this.settingsView.showPanel(this.activeSyntaxTheme, {
          back: 'Themes',
          pack: activeSyntaxTheme
        });
      }
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return ThemesPanel;
})(_collapsibleSectionPanel2['default']);

exports['default'] = ThemesPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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