Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _generalPanel = require('./general-panel');

var _generalPanel2 = _interopRequireDefault(_generalPanel);

var _editorPanel = require('./editor-panel');

var _editorPanel2 = _interopRequireDefault(_editorPanel);

var _packageDetailView = require('./package-detail-view');

var _packageDetailView2 = _interopRequireDefault(_packageDetailView);

var _keybindingsPanel = require('./keybindings-panel');

var _keybindingsPanel2 = _interopRequireDefault(_keybindingsPanel);

var _installPanel = require('./install-panel');

var _installPanel2 = _interopRequireDefault(_installPanel);

var _themesPanel = require('./themes-panel');

var _themesPanel2 = _interopRequireDefault(_themesPanel);

var _installedPackagesPanel = require('./installed-packages-panel');

var _installedPackagesPanel2 = _interopRequireDefault(_installedPackagesPanel);

var _updatesPanel = require('./updates-panel');

var _updatesPanel2 = _interopRequireDefault(_updatesPanel);

var _packageManager = require('./package-manager');

var _packageManager2 = _interopRequireDefault(_packageManager);

var SettingsView = (function () {
  function SettingsView() {
    var _this = this;

    var _ref = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

    var uri = _ref.uri;
    var packageManager = _ref.packageManager;
    var snippetsProvider = _ref.snippetsProvider;
    var activePanel = _ref.activePanel;

    _classCallCheck(this, SettingsView);

    this.uri = uri;
    this.packageManager = packageManager;
    this.snippetsProvider = snippetsProvider;
    this.deferredPanel = activePanel;
    this.destroyed = false;

    _etch2['default'].initialize(this);
    this.disposables = new _atom.CompositeDisposable();
    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));
    process.nextTick(function () {
      return _this.initializePanels();
    });
  }

  _createClass(SettingsView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      this.destroyed = true;
      this.disposables.dispose();
      for (var _name in this.panelsByName) {
        var panel = this.panelsByName[_name];
        panel.destroy();
      }

      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'settings-view pane-item', tabIndex: '-1' },
        _etch2['default'].dom(
          'div',
          { className: 'config-menu', ref: 'sidebar' },
          _etch2['default'].dom(
            'ul',
            { className: 'panels-menu nav nav-pills nav-stacked', ref: 'panelMenu' },
            _etch2['default'].dom('div', { className: 'panel-menu-separator', ref: 'menuSeparator' })
          ),
          _etch2['default'].dom(
            'div',
            { className: 'button-area' },
            _etch2['default'].dom(
              'button',
              { className: 'btn btn-default icon icon-link-external', ref: 'openDotAtom' },
              'Open Config Folder'
            )
          )
        ),
        _etch2['default'].dom('div', { className: 'panels', tabIndex: '-1', ref: 'panels' })
      );
    }

    // This prevents the view being actually disposed when closed
    // If you remove it you will need to ensure the cached settingsView
    // in main.coffee is correctly released on close as well...
  }, {
    key: 'onDidChangeTitle',
    value: function onDidChangeTitle() {
      return new _atom.Disposable();
    }
  }, {
    key: 'initializePanels',
    value: function initializePanels() {
      var _this2 = this;

      if (this.refs.panels.children.length > 1) {
        return;
      }

      this.panelsByName = {};
      var clickHandler = function clickHandler(event) {
        var target = event.target.closest('.panels-menu li a, .panels-packages li a');
        if (target) {
          _this2.showPanel(target.closest('li').name);
        }
      };
      this.element.addEventListener('click', clickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        return _this2.element.removeEventListener('click', clickHandler);
      }));

      var focusHandler = function focusHandler() {
        _this2.focusActivePanel();
      };
      this.element.addEventListener('focus', focusHandler);
      this.disposables.add(new _atom.Disposable(function () {
        return _this2.element.removeEventListener('focus', focusHandler);
      }));

      var openDotAtomClickHandler = function openDotAtomClickHandler() {
        atom.open({ pathsToOpen: [atom.getConfigDirPath()] });
      };
      this.refs.openDotAtom.addEventListener('click', openDotAtomClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        return _this2.refs.openDotAtom.removeEventListener('click', openDotAtomClickHandler);
      }));

      this.addCorePanel('Core', 'settings', function () {
        return new _generalPanel2['default']();
      });
      this.addCorePanel('Editor', 'code', function () {
        return new _editorPanel2['default']();
      });
      if (process.platform === 'win32' && require('atom').WinShell != null) {
        (function () {
          var SystemPanel = require('./system-windows-panel');
          _this2.addCorePanel('System', 'device-desktop', function () {
            return new SystemPanel();
          });
        })();
      }
      this.addCorePanel('Keybindings', 'keyboard', function () {
        return new _keybindingsPanel2['default']();
      });
      this.addCorePanel('Packages', 'package', function () {
        return new _installedPackagesPanel2['default'](_this2, _this2.packageManager);
      });
      this.addCorePanel('Themes', 'paintcan', function () {
        return new _themesPanel2['default'](_this2, _this2.packageManager);
      });
      this.addCorePanel('Updates', 'cloud-download', function () {
        return new _updatesPanel2['default'](_this2, _this2.packageManager);
      });
      this.addCorePanel('Install', 'plus', function () {
        return new _installPanel2['default'](_this2, _this2.packageManager);
      });

      this.showDeferredPanel();

      if (!this.activePanel) {
        this.showPanel('Core');
      }

      if (document.body.contains(this.element)) {
        this.refs.sidebar.style.width = this.refs.sidebar.offsetWidth;
      }
    }
  }, {
    key: 'serialize',
    value: function serialize() {
      return {
        deserializer: 'SettingsView',
        version: 2,
        activePanel: this.activePanel != null ? this.activePanel : this.deferredPanel,
        uri: this.uri
      };
    }
  }, {
    key: 'getPackages',
    value: function getPackages() {
      var _this3 = this;

      var bundledPackageMetadataCache = undefined;
      var left = undefined;
      if (this.packages != null) {
        return this.packages;
      }

      this.packages = atom.packages.getLoadedPackages();

      try {
        var packageMetadata = require(_path2['default'].join(atom.getLoadSettings().resourcePath, 'package.json'));
        bundledPackageMetadataCache = packageMetadata ? packageMetadata._atomPackages : null;
      } catch (error) {}

      // Include disabled packages so they can be re-enabled from the UI
      var disabledPackages = atom.config.get('core.disabledPackages') || [];
      for (var packageName of disabledPackages) {
        var metadata;
        var packagePath = atom.packages.resolvePackagePath(packageName);
        if (!packagePath) {
          continue;
        }

        try {
          metadata = require(_path2['default'].join(packagePath, 'package.json'));
        } catch (error) {
          if (bundledPackageMetadataCache && bundledPackageMetadataCache[packageName]) {
            metadata = bundledPackageMetadataCache[packageName].metadata;
          }
        }
        if (metadata == null) {
          continue;
        }

        var _name2 = metadata.name != null ? metadata.name : packageName;
        if (!_underscorePlus2['default'].findWhere(this.packages, { name: _name2 })) {
          this.packages.push({ name: _name2, metadata: metadata, path: packagePath });
        }
      }

      this.packages.sort(function (pack1, pack2) {
        var title1 = _this3.packageManager.getPackageTitle(pack1);
        var title2 = _this3.packageManager.getPackageTitle(pack2);
        return title1.localeCompare(title2);
      });

      return this.packages;
    }
  }, {
    key: 'addCorePanel',
    value: function addCorePanel(name, iconName, panel) {
      var panelMenuItem = document.createElement('li');
      panelMenuItem.name = name;
      panelMenuItem.setAttribute('name', name);

      var a = document.createElement('a');
      a.classList.add('icon', 'icon-' + iconName);
      a.textContent = name;
      panelMenuItem.appendChild(a);

      this.refs.menuSeparator.parentElement.insertBefore(panelMenuItem, this.refs.menuSeparator);
      this.addPanel(name, panel);
    }
  }, {
    key: 'addPanel',
    value: function addPanel(name, panelCreateCallback) {
      if (this.panelCreateCallbacks == null) {
        this.panelCreateCallbacks = {};
      }
      this.panelCreateCallbacks[name] = panelCreateCallback;
      if (this.deferredPanel && this.deferredPanel.name === name) {
        this.showDeferredPanel();
      }
    }
  }, {
    key: 'getOrCreatePanel',
    value: function getOrCreatePanel(name, options) {
      var _this4 = this;

      var panel = this.panelsByName ? this.panelsByName[name] : null;
      // These nested conditionals are not great but I feel like it's the most
      // expedient thing to do - I feel like the "right way" involves refactoring
      // this whole file.
      if (!panel) {
        var callback = this.panelCreateCallbacks ? this.panelCreateCallbacks[name] : null;

        if (options && options.pack && !callback) {
          callback = function () {
            if (!options.pack.metadata) {
              var metadata = _underscorePlus2['default'].clone(options.pack);
              options.pack.metadata = metadata;
            }
            return new _packageDetailView2['default'](options.pack, _this4, _this4.packageManager, _this4.snippetsProvider);
          };
        }

        if (callback) {
          panel = callback();
          if (this.panelsByName == null) {
            this.panelsByName = {};
          }
          this.panelsByName[name] = panel;
          if (this.panelCreateCallbacks) {
            delete this.panelCreateCallbacks[name];
          }
        }
      }

      return panel;
    }
  }, {
    key: 'makePanelMenuActive',
    value: function makePanelMenuActive(name) {
      var previouslyActivePanel = this.refs.sidebar.querySelector('.active');
      if (previouslyActivePanel) {
        previouslyActivePanel.classList.remove('active');
      }

      var newActivePanel = this.refs.sidebar.querySelector('[name=\'' + name + '\']');
      if (newActivePanel) {
        newActivePanel.classList.add('active');
      }
    }
  }, {
    key: 'focusActivePanel',
    value: function focusActivePanel() {
      // Pass focus to panel that is currently visible
      for (var i = 0; i < this.refs.panels.children.length; i++) {
        var child = this.refs.panels.children[i];
        if (child.offsetWidth > 0) {
          child.focus();
        }
      }
    }
  }, {
    key: 'showDeferredPanel',
    value: function showDeferredPanel() {
      if (this.deferredPanel) {
        var _deferredPanel = this.deferredPanel;
        var _name3 = _deferredPanel.name;
        var options = _deferredPanel.options;

        this.showPanel(_name3, options);
      }
    }

    // Public: show a panel.
    //
    // * `name` {String} the name of the panel to show
    // * `options` {Object} an options hash. Will be passed to `beforeShow()` on
    //   the panel. Options may include (but are not limited to):
    //   * `uri` the URI the panel was launched from
  }, {
    key: 'showPanel',
    value: function showPanel(name, options) {
      var panel = this.getOrCreatePanel(name, options);
      if (panel) {
        this.appendPanel(panel, options);
        this.makePanelMenuActive(name);
        this.setActivePanel(name, options);
        this.deferredPanel = null;
      } else {
        this.deferredPanel = { name: name, options: options };
      }
    }
  }, {
    key: 'appendPanel',
    value: function appendPanel(panel, options) {
      for (var i = 0; i < this.refs.panels.children.length; i++) {
        this.refs.panels.children[i].style.display = 'none';
      }

      if (!this.refs.panels.contains(panel.element)) {
        this.refs.panels.appendChild(panel.element);
      }

      if (panel.beforeShow) {
        panel.beforeShow(options);
      }
      panel.show();
      panel.focus();
    }
  }, {
    key: 'setActivePanel',
    value: function setActivePanel(name) {
      var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      this.activePanel = { name: name, options: options };
    }
  }, {
    key: 'removePanel',
    value: function removePanel(name) {
      var panel = this.panelsByName ? this.panelsByName[name] : null;
      if (panel) {
        panel.destroy();
        delete this.panelsByName[name];
      }
    }
  }, {
    key: 'getTitle',
    value: function getTitle() {
      return 'Settings';
    }
  }, {
    key: 'getIconName',
    value: function getIconName() {
      return 'tools';
    }
  }, {
    key: 'getURI',
    value: function getURI() {
      return this.uri;
    }
  }, {
    key: 'isEqual',
    value: function isEqual(other) {
      return other instanceof SettingsView;
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return SettingsView;
})();

exports['default'] = SettingsView;
module.exports = exports['default'];
/* The tabindex attr below ensures that clicks in a panel item won't
cause this view to gain focus. This is important because when this view
gains focus (e.g. immediately after atom displays it), it focuses the
currently active panel item. If that focusing causes the active panel to
scroll (e.g. because the active panel itself passes focus on to a search
box at the top of a scrolled panel), then the browser will not fire the
click event on the element within the panel on which the user originally
clicked (e.g. a package card). This would prevent us from showing a
package detail view when clicking on a package card. Phew! */
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9ob21lL2FuZHJlaS9hdG9tLTEuMTkuMi9vdXQvYXBwL25vZGVfbW9kdWxlcy9zZXR0aW5ncy12aWV3L2xpYi9zZXR0aW5ncy12aWV3LmpzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7b0JBR2lCLE1BQU07Ozs7b0JBQ04sTUFBTTs7Ozs4QkFDVCxpQkFBaUI7Ozs7b0JBQ2UsTUFBTTs7NEJBRTNCLGlCQUFpQjs7OzsyQkFDbEIsZ0JBQWdCOzs7O2lDQUNWLHVCQUF1Qjs7OztnQ0FDeEIscUJBQXFCOzs7OzRCQUN6QixpQkFBaUI7Ozs7MkJBQ2xCLGdCQUFnQjs7OztzQ0FDTCw0QkFBNEI7Ozs7NEJBQ3RDLGlCQUFpQjs7Ozs4QkFDZixtQkFBbUI7Ozs7SUFFekIsWUFBWTtBQUNuQixXQURPLFlBQVksR0FDeUM7OztxRUFBSixFQUFFOztRQUF4RCxHQUFHLFFBQUgsR0FBRztRQUFFLGNBQWMsUUFBZCxjQUFjO1FBQUUsZ0JBQWdCLFFBQWhCLGdCQUFnQjtRQUFFLFdBQVcsUUFBWCxXQUFXOzswQkFEN0MsWUFBWTs7QUFFN0IsUUFBSSxDQUFDLEdBQUcsR0FBRyxHQUFHLENBQUE7QUFDZCxRQUFJLENBQUMsY0FBYyxHQUFHLGNBQWMsQ0FBQTtBQUNwQyxRQUFJLENBQUMsZ0JBQWdCLEdBQUcsZ0JBQWdCLENBQUE7QUFDeEMsUUFBSSxDQUFDLGFBQWEsR0FBRyxXQUFXLENBQUE7QUFDaEMsUUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUE7O0FBRXRCLHNCQUFLLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQTtBQUNyQixRQUFJLENBQUMsV0FBVyxHQUFHLCtCQUF5QixDQUFBO0FBQzVDLFFBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUU7QUFDbkQsb0JBQWMsRUFBRSxzQkFBTTtBQUFFLGNBQUssUUFBUSxFQUFFLENBQUE7T0FBRTtBQUN6QyxzQkFBZ0IsRUFBRSx3QkFBTTtBQUFFLGNBQUssVUFBVSxFQUFFLENBQUE7T0FBRTtBQUM3QyxvQkFBYyxFQUFFLHNCQUFNO0FBQUUsY0FBSyxNQUFNLEVBQUUsQ0FBQTtPQUFFO0FBQ3ZDLHNCQUFnQixFQUFFLHdCQUFNO0FBQUUsY0FBSyxRQUFRLEVBQUUsQ0FBQTtPQUFFO0FBQzNDLHdCQUFrQixFQUFFLHlCQUFNO0FBQUUsY0FBSyxXQUFXLEVBQUUsQ0FBQTtPQUFFO0FBQ2hELDJCQUFxQixFQUFFLDRCQUFNO0FBQUUsY0FBSyxjQUFjLEVBQUUsQ0FBQTtPQUFFO0tBQ3ZELENBQUMsQ0FBQyxDQUFBO0FBQ0gsV0FBTyxDQUFDLFFBQVEsQ0FBQzthQUFNLE1BQUssZ0JBQWdCLEVBQUU7S0FBQSxDQUFDLENBQUE7R0FDaEQ7O2VBbkJrQixZQUFZOztXQXFCeEIsa0JBQUcsRUFBRTs7O1dBRUosbUJBQUc7QUFDVCxVQUFJLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQTtBQUNyQixVQUFJLENBQUMsV0FBVyxDQUFDLE9BQU8sRUFBRSxDQUFBO0FBQzFCLFdBQUssSUFBSSxLQUFJLElBQUksSUFBSSxDQUFDLFlBQVksRUFBRTtBQUNsQyxZQUFNLEtBQUssR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLEtBQUksQ0FBQyxDQUFBO0FBQ3JDLGFBQUssQ0FBQyxPQUFPLEVBQUUsQ0FBQTtPQUNoQjs7QUFFRCxhQUFPLGtCQUFLLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQTtLQUMxQjs7O1dBRU0sa0JBQUc7QUFDUixhQUNFOztVQUFLLFNBQVMsRUFBQyx5QkFBeUIsRUFBQyxRQUFRLEVBQUMsSUFBSTtRQUNwRDs7WUFBSyxTQUFTLEVBQUMsYUFBYSxFQUFDLEdBQUcsRUFBQyxTQUFTO1VBQ3hDOztjQUFJLFNBQVMsRUFBQyx1Q0FBdUMsRUFBQyxHQUFHLEVBQUMsV0FBVztZQUNuRSwrQkFBSyxTQUFTLEVBQUMsc0JBQXNCLEVBQUMsR0FBRyxFQUFDLGVBQWUsR0FBTztXQUM3RDtVQUNMOztjQUFLLFNBQVMsRUFBQyxhQUFhO1lBQzFCOztnQkFBUSxTQUFTLEVBQUMseUNBQXlDLEVBQUMsR0FBRyxFQUFDLGFBQWE7O2FBQTRCO1dBQ3JHO1NBQ0Y7UUFVTiwrQkFBSyxTQUFTLEVBQUMsUUFBUSxFQUFDLFFBQVEsRUFBQyxJQUFJLEVBQUMsR0FBRyxFQUFDLFFBQVEsR0FBTztPQUNyRCxDQUNQO0tBQ0Y7Ozs7Ozs7V0FLZ0IsNEJBQUc7QUFBRSxhQUFPLHNCQUFnQixDQUFBO0tBQUU7OztXQUU5Qiw0QkFBRzs7O0FBQ2xCLFVBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsUUFBUSxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUU7QUFDeEMsZUFBTTtPQUNQOztBQUVELFVBQUksQ0FBQyxZQUFZLEdBQUcsRUFBRSxDQUFBO0FBQ3RCLFVBQU0sWUFBWSxHQUFHLFNBQWYsWUFBWSxDQUFJLEtBQUssRUFBSztBQUM5QixZQUFNLE1BQU0sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQywwQ0FBMEMsQ0FBQyxDQUFBO0FBQy9FLFlBQUksTUFBTSxFQUFFO0FBQ1YsaUJBQUssU0FBUyxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUE7U0FDMUM7T0FDRixDQUFBO0FBQ0QsVUFBSSxDQUFDLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLEVBQUUsWUFBWSxDQUFDLENBQUE7QUFDcEQsVUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMscUJBQWU7ZUFBTSxPQUFLLE9BQU8sQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsWUFBWSxDQUFDO09BQUEsQ0FBQyxDQUFDLENBQUE7O0FBRW5HLFVBQU0sWUFBWSxHQUFHLFNBQWYsWUFBWSxHQUFTO0FBQ3pCLGVBQUssZ0JBQWdCLEVBQUUsQ0FBQTtPQUN4QixDQUFBO0FBQ0QsVUFBSSxDQUFDLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLEVBQUUsWUFBWSxDQUFDLENBQUE7QUFDcEQsVUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMscUJBQWU7ZUFBTSxPQUFLLE9BQU8sQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsWUFBWSxDQUFDO09BQUEsQ0FBQyxDQUFDLENBQUE7O0FBR25HLFVBQU0sdUJBQXVCLEdBQUcsU0FBMUIsdUJBQXVCLEdBQVM7QUFDcEMsWUFBSSxDQUFDLElBQUksQ0FBQyxFQUFDLFdBQVcsRUFBRSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDLEVBQUMsQ0FBQyxDQUFBO09BQ3BELENBQUE7QUFDRCxVQUFJLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLEVBQUUsdUJBQXVCLENBQUMsQ0FBQTtBQUN4RSxVQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxxQkFBZTtlQUFNLE9BQUssSUFBSSxDQUFDLFdBQVcsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsdUJBQXVCLENBQUM7T0FBQSxDQUFDLENBQUMsQ0FBQTs7QUFFdkgsVUFBSSxDQUFDLFlBQVksQ0FBQyxNQUFNLEVBQUUsVUFBVSxFQUFFO2VBQU0sK0JBQWtCO09BQUEsQ0FBQyxDQUFBO0FBQy9ELFVBQUksQ0FBQyxZQUFZLENBQUMsUUFBUSxFQUFFLE1BQU0sRUFBRTtlQUFNLDhCQUFpQjtPQUFBLENBQUMsQ0FBQTtBQUM1RCxVQUFJLEFBQUMsT0FBTyxDQUFDLFFBQVEsS0FBSyxPQUFPLElBQU0sT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDLFFBQVEsSUFBSSxJQUFJLEFBQUMsRUFBRTs7QUFDeEUsY0FBTSxXQUFXLEdBQUcsT0FBTyxDQUFDLHdCQUF3QixDQUFDLENBQUE7QUFDckQsaUJBQUssWUFBWSxDQUFDLFFBQVEsRUFBRSxnQkFBZ0IsRUFBRTttQkFBTSxJQUFJLFdBQVcsRUFBRTtXQUFBLENBQUMsQ0FBQTs7T0FDdkU7QUFDRCxVQUFJLENBQUMsWUFBWSxDQUFDLGFBQWEsRUFBRSxVQUFVLEVBQUU7ZUFBTSxtQ0FBc0I7T0FBQSxDQUFDLENBQUE7QUFDMUUsVUFBSSxDQUFDLFlBQVksQ0FBQyxVQUFVLEVBQUUsU0FBUyxFQUFFO2VBQU0sZ0RBQWlDLE9BQUssY0FBYyxDQUFDO09BQUEsQ0FBQyxDQUFBO0FBQ3JHLFVBQUksQ0FBQyxZQUFZLENBQUMsUUFBUSxFQUFFLFVBQVUsRUFBRTtlQUFNLHFDQUFzQixPQUFLLGNBQWMsQ0FBQztPQUFBLENBQUMsQ0FBQTtBQUN6RixVQUFJLENBQUMsWUFBWSxDQUFDLFNBQVMsRUFBRSxnQkFBZ0IsRUFBRTtlQUFNLHNDQUF1QixPQUFLLGNBQWMsQ0FBQztPQUFBLENBQUMsQ0FBQTtBQUNqRyxVQUFJLENBQUMsWUFBWSxDQUFDLFNBQVMsRUFBRSxNQUFNLEVBQUU7ZUFBTSxzQ0FBdUIsT0FBSyxjQUFjLENBQUM7T0FBQSxDQUFDLENBQUE7O0FBRXZGLFVBQUksQ0FBQyxpQkFBaUIsRUFBRSxDQUFBOztBQUV4QixVQUFJLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRTtBQUNyQixZQUFJLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxDQUFBO09BQ3ZCOztBQUVELFVBQUksUUFBUSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxFQUFFO0FBQ3hDLFlBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFBO09BQzlEO0tBQ0Y7OztXQUVTLHFCQUFHO0FBQ1gsYUFBTztBQUNMLG9CQUFZLEVBQUUsY0FBYztBQUM1QixlQUFPLEVBQUUsQ0FBQztBQUNWLG1CQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVcsSUFBSSxJQUFJLEdBQUcsSUFBSSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsYUFBYTtBQUM3RSxXQUFHLEVBQUUsSUFBSSxDQUFDLEdBQUc7T0FDZCxDQUFBO0tBQ0Y7OztXQUVXLHVCQUFHOzs7QUFDYixVQUFJLDJCQUEyQixZQUFBLENBQUE7QUFDL0IsVUFBSSxJQUFJLFlBQUEsQ0FBQTtBQUNSLFVBQUksSUFBSSxDQUFDLFFBQVEsSUFBSSxJQUFJLEVBQUU7QUFBRSxlQUFPLElBQUksQ0FBQyxRQUFRLENBQUE7T0FBRTs7QUFFbkQsVUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLGlCQUFpQixFQUFFLENBQUE7O0FBRWpELFVBQUk7QUFDRixZQUFNLGVBQWUsR0FBRyxPQUFPLENBQUMsa0JBQUssSUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLEVBQUUsQ0FBQyxZQUFZLEVBQUUsY0FBYyxDQUFDLENBQUMsQ0FBQTtBQUMvRixtQ0FBMkIsR0FBRyxlQUFlLEdBQUcsZUFBZSxDQUFDLGFBQWEsR0FBRyxJQUFJLENBQUE7T0FDckYsQ0FBQyxPQUFPLEtBQUssRUFBRSxFQUFFOzs7QUFHbEIsVUFBTSxnQkFBZ0IsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyx1QkFBdUIsQ0FBQyxJQUFJLEVBQUUsQ0FBQTtBQUN2RSxXQUFLLElBQU0sV0FBVyxJQUFJLGdCQUFnQixFQUFFO0FBQzFDLFlBQUksUUFBUSxDQUFBO0FBQ1osWUFBTSxXQUFXLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxrQkFBa0IsQ0FBQyxXQUFXLENBQUMsQ0FBQTtBQUNqRSxZQUFJLENBQUMsV0FBVyxFQUFFO0FBQ2hCLG1CQUFRO1NBQ1Q7O0FBRUQsWUFBSTtBQUNGLGtCQUFRLEdBQUcsT0FBTyxDQUFDLGtCQUFLLElBQUksQ0FBQyxXQUFXLEVBQUUsY0FBYyxDQUFDLENBQUMsQ0FBQTtTQUMzRCxDQUFDLE9BQU8sS0FBSyxFQUFFO0FBQ2QsY0FBSSwyQkFBMkIsSUFBSSwyQkFBMkIsQ0FBQyxXQUFXLENBQUMsRUFBRTtBQUMzRSxvQkFBUSxHQUFHLDJCQUEyQixDQUFDLFdBQVcsQ0FBQyxDQUFDLFFBQVEsQ0FBQTtXQUM3RDtTQUNGO0FBQ0QsWUFBSSxRQUFRLElBQUksSUFBSSxFQUFFO0FBQ3BCLG1CQUFRO1NBQ1Q7O0FBRUQsWUFBTSxNQUFJLEdBQUcsUUFBUSxDQUFDLElBQUksSUFBSSxJQUFJLEdBQUcsUUFBUSxDQUFDLElBQUksR0FBRyxXQUFXLENBQUE7QUFDaEUsWUFBSSxDQUFDLDRCQUFFLFNBQVMsQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLEVBQUMsSUFBSSxFQUFKLE1BQUksRUFBQyxDQUFDLEVBQUU7QUFDdkMsY0FBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsRUFBQyxJQUFJLEVBQUosTUFBSSxFQUFFLFFBQVEsRUFBUixRQUFRLEVBQUUsSUFBSSxFQUFFLFdBQVcsRUFBQyxDQUFDLENBQUE7U0FDeEQ7T0FDRjs7QUFFRCxVQUFJLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxVQUFDLEtBQUssRUFBRSxLQUFLLEVBQUs7QUFDbkMsWUFBTSxNQUFNLEdBQUcsT0FBSyxjQUFjLENBQUMsZUFBZSxDQUFDLEtBQUssQ0FBQyxDQUFBO0FBQ3pELFlBQU0sTUFBTSxHQUFHLE9BQUssY0FBYyxDQUFDLGVBQWUsQ0FBQyxLQUFLLENBQUMsQ0FBQTtBQUN6RCxlQUFPLE1BQU0sQ0FBQyxhQUFhLENBQUMsTUFBTSxDQUFDLENBQUE7T0FDcEMsQ0FBQyxDQUFBOztBQUVGLGFBQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQTtLQUNyQjs7O1dBRVksc0JBQUMsSUFBSSxFQUFFLFFBQVEsRUFBRSxLQUFLLEVBQUU7QUFDbkMsVUFBTSxhQUFhLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsQ0FBQTtBQUNsRCxtQkFBYSxDQUFDLElBQUksR0FBRyxJQUFJLENBQUE7QUFDekIsbUJBQWEsQ0FBQyxZQUFZLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxDQUFBOztBQUV4QyxVQUFNLENBQUMsR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxDQUFBO0FBQ3JDLE9BQUMsQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLE1BQU0sWUFBVSxRQUFRLENBQUcsQ0FBQTtBQUMzQyxPQUFDLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQTtBQUNwQixtQkFBYSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUMsQ0FBQTs7QUFFNUIsVUFBSSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsYUFBYSxDQUFDLFlBQVksQ0FBQyxhQUFhLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQTtBQUMxRixVQUFJLENBQUMsUUFBUSxDQUFDLElBQUksRUFBRSxLQUFLLENBQUMsQ0FBQTtLQUMzQjs7O1dBRVEsa0JBQUMsSUFBSSxFQUFFLG1CQUFtQixFQUFFO0FBQ25DLFVBQUksSUFBSSxDQUFDLG9CQUFvQixJQUFJLElBQUksRUFBRTtBQUNyQyxZQUFJLENBQUMsb0JBQW9CLEdBQUcsRUFBRSxDQUFBO09BQy9CO0FBQ0QsVUFBSSxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxHQUFHLG1CQUFtQixDQUFBO0FBQ3JELFVBQUksSUFBSSxDQUFDLGFBQWEsSUFBSSxJQUFJLENBQUMsYUFBYSxDQUFDLElBQUksS0FBSyxJQUFJLEVBQUU7QUFDMUQsWUFBSSxDQUFDLGlCQUFpQixFQUFFLENBQUE7T0FDekI7S0FDRjs7O1dBRWdCLDBCQUFDLElBQUksRUFBRSxPQUFPLEVBQUU7OztBQUMvQixVQUFJLEtBQUssR0FBRyxJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLEdBQUcsSUFBSSxDQUFBOzs7O0FBSTlELFVBQUksQ0FBQyxLQUFLLEVBQUU7QUFDVixZQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsb0JBQW9CLEdBQUcsSUFBSSxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxHQUFHLElBQUksQ0FBQTs7QUFFakYsWUFBSSxPQUFPLElBQUksT0FBTyxDQUFDLElBQUksSUFBSSxDQUFDLFFBQVEsRUFBRTtBQUN4QyxrQkFBUSxHQUFHLFlBQU07QUFDZixnQkFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFO0FBQzFCLGtCQUFNLFFBQVEsR0FBRyw0QkFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFBO0FBQ3RDLHFCQUFPLENBQUMsSUFBSSxDQUFDLFFBQVEsR0FBRyxRQUFRLENBQUE7YUFDakM7QUFDRCxtQkFBTyxtQ0FBc0IsT0FBTyxDQUFDLElBQUksVUFBUSxPQUFLLGNBQWMsRUFBRSxPQUFLLGdCQUFnQixDQUFDLENBQUE7V0FDN0YsQ0FBQTtTQUNGOztBQUVELFlBQUksUUFBUSxFQUFFO0FBQ1osZUFBSyxHQUFHLFFBQVEsRUFBRSxDQUFBO0FBQ2xCLGNBQUksSUFBSSxDQUFDLFlBQVksSUFBSSxJQUFJLEVBQUU7QUFDN0IsZ0JBQUksQ0FBQyxZQUFZLEdBQUcsRUFBRSxDQUFBO1dBQ3ZCO0FBQ0QsY0FBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsR0FBRyxLQUFLLENBQUE7QUFDL0IsY0FBSSxJQUFJLENBQUMsb0JBQW9CLEVBQUU7QUFDN0IsbUJBQU8sSUFBSSxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxDQUFBO1dBQ3ZDO1NBQ0Y7T0FDRjs7QUFFRCxhQUFPLEtBQUssQ0FBQTtLQUNiOzs7V0FFbUIsNkJBQUMsSUFBSSxFQUFFO0FBQ3pCLFVBQU0scUJBQXFCLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsYUFBYSxDQUFDLFNBQVMsQ0FBQyxDQUFBO0FBQ3hFLFVBQUkscUJBQXFCLEVBQUU7QUFDekIsNkJBQXFCLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxRQUFRLENBQUMsQ0FBQTtPQUNqRDs7QUFFRCxVQUFNLGNBQWMsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxhQUFhLGNBQVcsSUFBSSxTQUFLLENBQUE7QUFDMUUsVUFBSSxjQUFjLEVBQUU7QUFDbEIsc0JBQWMsQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLFFBQVEsQ0FBQyxDQUFBO09BQ3ZDO0tBQ0Y7OztXQUVnQiw0QkFBRzs7QUFFbEIsV0FBSyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLFFBQVEsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxFQUFFLEVBQUU7QUFDekQsWUFBTSxLQUFLLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFBO0FBQzFDLFlBQUksS0FBSyxDQUFDLFdBQVcsR0FBRyxDQUFDLEVBQUU7QUFDekIsZUFBSyxDQUFDLEtBQUssRUFBRSxDQUFBO1NBQ2Q7T0FDRjtLQUNGOzs7V0FFaUIsNkJBQUc7QUFDbkIsVUFBSSxJQUFJLENBQUMsYUFBYSxFQUFFOzZCQUNFLElBQUksQ0FBQyxhQUFhO1lBQW5DLE1BQUksa0JBQUosSUFBSTtZQUFFLE9BQU8sa0JBQVAsT0FBTzs7QUFDcEIsWUFBSSxDQUFDLFNBQVMsQ0FBQyxNQUFJLEVBQUUsT0FBTyxDQUFDLENBQUE7T0FDOUI7S0FDRjs7Ozs7Ozs7OztXQVFTLG1CQUFDLElBQUksRUFBRSxPQUFPLEVBQUU7QUFDeEIsVUFBTSxLQUFLLEdBQUcsSUFBSSxDQUFDLGdCQUFnQixDQUFDLElBQUksRUFBRSxPQUFPLENBQUMsQ0FBQTtBQUNsRCxVQUFJLEtBQUssRUFBRTtBQUNULFlBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxFQUFFLE9BQU8sQ0FBQyxDQUFBO0FBQ2hDLFlBQUksQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLENBQUMsQ0FBQTtBQUM5QixZQUFJLENBQUMsY0FBYyxDQUFDLElBQUksRUFBRSxPQUFPLENBQUMsQ0FBQTtBQUNsQyxZQUFJLENBQUMsYUFBYSxHQUFHLElBQUksQ0FBQTtPQUMxQixNQUFNO0FBQ0wsWUFBSSxDQUFDLGFBQWEsR0FBRyxFQUFDLElBQUksRUFBSixJQUFJLEVBQUUsT0FBTyxFQUFQLE9BQU8sRUFBQyxDQUFBO09BQ3JDO0tBQ0Y7OztXQUVXLHFCQUFDLEtBQUssRUFBRSxPQUFPLEVBQUU7QUFDM0IsV0FBSyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLFFBQVEsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxFQUFFLEVBQUU7QUFDekQsWUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFBO09BQ3BEOztBQUVELFVBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxFQUFFO0FBQzdDLFlBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLFdBQVcsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUE7T0FDNUM7O0FBRUQsVUFBSSxLQUFLLENBQUMsVUFBVSxFQUFFO0FBQ3BCLGFBQUssQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUE7T0FDMUI7QUFDRCxXQUFLLENBQUMsSUFBSSxFQUFFLENBQUE7QUFDWixXQUFLLENBQUMsS0FBSyxFQUFFLENBQUE7S0FDZDs7O1dBRWMsd0JBQUMsSUFBSSxFQUFnQjtVQUFkLE9BQU8seURBQUcsRUFBRTs7QUFDaEMsVUFBSSxDQUFDLFdBQVcsR0FBRyxFQUFDLElBQUksRUFBSixJQUFJLEVBQUUsT0FBTyxFQUFQLE9BQU8sRUFBQyxDQUFBO0tBQ25DOzs7V0FFVyxxQkFBQyxJQUFJLEVBQUU7QUFDakIsVUFBTSxLQUFLLEdBQUcsSUFBSSxDQUFDLFlBQVksR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxHQUFHLElBQUksQ0FBQTtBQUNoRSxVQUFJLEtBQUssRUFBRTtBQUNULGFBQUssQ0FBQyxPQUFPLEVBQUUsQ0FBQTtBQUNmLGVBQU8sSUFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsQ0FBQTtPQUMvQjtLQUNGOzs7V0FFUSxvQkFBRztBQUNWLGFBQU8sVUFBVSxDQUFBO0tBQ2xCOzs7V0FFVyx1QkFBRztBQUNiLGFBQU8sT0FBTyxDQUFBO0tBQ2Y7OztXQUVNLGtCQUFHO0FBQ1IsYUFBTyxJQUFJLENBQUMsR0FBRyxDQUFBO0tBQ2hCOzs7V0FFTyxpQkFBQyxLQUFLLEVBQUU7QUFDZCxhQUFPLEtBQUssWUFBWSxZQUFZLENBQUE7S0FDckM7OztXQUVRLG9CQUFHO0FBQ1YsVUFBSSxDQUFDLE9BQU8sQ0FBQyxTQUFTLElBQUksUUFBUSxDQUFDLElBQUksQ0FBQyxZQUFZLEdBQUcsRUFBRSxDQUFBO0tBQzFEOzs7V0FFVSxzQkFBRztBQUNaLFVBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxJQUFJLFFBQVEsQ0FBQyxJQUFJLENBQUMsWUFBWSxHQUFHLEVBQUUsQ0FBQTtLQUMxRDs7O1dBRU0sa0JBQUc7QUFDUixVQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQTtLQUNwRDs7O1dBRVEsb0JBQUc7QUFDVixVQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQTtLQUNwRDs7O1dBRVcsdUJBQUc7QUFDYixVQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsR0FBRyxDQUFDLENBQUE7S0FDM0I7OztXQUVjLDBCQUFHO0FBQ2hCLFVBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsWUFBWSxDQUFBO0tBQ25EOzs7U0FyVmtCLFlBQVk7OztxQkFBWixZQUFZIiwiZmlsZSI6Ii9ob21lL2FuZHJlaS9hdG9tLTEuMTkuMi9vdXQvYXBwL25vZGVfbW9kdWxlcy9zZXR0aW5ncy12aWV3L2xpYi9zZXR0aW5ncy12aWV3LmpzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqIEBiYWJlbCAqL1xuLyoqIEBqc3ggZXRjaC5kb20gKi9cblxuaW1wb3J0IHBhdGggZnJvbSAncGF0aCdcbmltcG9ydCBldGNoIGZyb20gJ2V0Y2gnXG5pbXBvcnQgXyBmcm9tICd1bmRlcnNjb3JlLXBsdXMnXG5pbXBvcnQge0NvbXBvc2l0ZURpc3Bvc2FibGUsIERpc3Bvc2FibGV9IGZyb20gJ2F0b20nXG5cbmltcG9ydCBHZW5lcmFsUGFuZWwgZnJvbSAnLi9nZW5lcmFsLXBhbmVsJ1xuaW1wb3J0IEVkaXRvclBhbmVsIGZyb20gJy4vZWRpdG9yLXBhbmVsJ1xuaW1wb3J0IFBhY2thZ2VEZXRhaWxWaWV3IGZyb20gJy4vcGFja2FnZS1kZXRhaWwtdmlldydcbmltcG9ydCBLZXliaW5kaW5nc1BhbmVsIGZyb20gJy4va2V5YmluZGluZ3MtcGFuZWwnXG5pbXBvcnQgSW5zdGFsbFBhbmVsIGZyb20gJy4vaW5zdGFsbC1wYW5lbCdcbmltcG9ydCBUaGVtZXNQYW5lbCBmcm9tICcuL3RoZW1lcy1wYW5lbCdcbmltcG9ydCBJbnN0YWxsZWRQYWNrYWdlc1BhbmVsIGZyb20gJy4vaW5zdGFsbGVkLXBhY2thZ2VzLXBhbmVsJ1xuaW1wb3J0IFVwZGF0ZXNQYW5lbCBmcm9tICcuL3VwZGF0ZXMtcGFuZWwnXG5pbXBvcnQgUGFja2FnZU1hbmFnZXIgZnJvbSAnLi9wYWNrYWdlLW1hbmFnZXInXG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFNldHRpbmdzVmlldyB7XG4gIGNvbnN0cnVjdG9yICh7dXJpLCBwYWNrYWdlTWFuYWdlciwgc25pcHBldHNQcm92aWRlciwgYWN0aXZlUGFuZWx9ID0ge30pIHtcbiAgICB0aGlzLnVyaSA9IHVyaVxuICAgIHRoaXMucGFja2FnZU1hbmFnZXIgPSBwYWNrYWdlTWFuYWdlclxuICAgIHRoaXMuc25pcHBldHNQcm92aWRlciA9IHNuaXBwZXRzUHJvdmlkZXJcbiAgICB0aGlzLmRlZmVycmVkUGFuZWwgPSBhY3RpdmVQYW5lbFxuICAgIHRoaXMuZGVzdHJveWVkID0gZmFsc2VcblxuICAgIGV0Y2guaW5pdGlhbGl6ZSh0aGlzKVxuICAgIHRoaXMuZGlzcG9zYWJsZXMgPSBuZXcgQ29tcG9zaXRlRGlzcG9zYWJsZSgpXG4gICAgdGhpcy5kaXNwb3NhYmxlcy5hZGQoYXRvbS5jb21tYW5kcy5hZGQodGhpcy5lbGVtZW50LCB7XG4gICAgICAnY29yZTptb3ZlLXVwJzogKCkgPT4geyB0aGlzLnNjcm9sbFVwKCkgfSxcbiAgICAgICdjb3JlOm1vdmUtZG93bic6ICgpID0+IHsgdGhpcy5zY3JvbGxEb3duKCkgfSxcbiAgICAgICdjb3JlOnBhZ2UtdXAnOiAoKSA9PiB7IHRoaXMucGFnZVVwKCkgfSxcbiAgICAgICdjb3JlOnBhZ2UtZG93bic6ICgpID0+IHsgdGhpcy5wYWdlRG93bigpIH0sXG4gICAgICAnY29yZTptb3ZlLXRvLXRvcCc6ICgpID0+IHsgdGhpcy5zY3JvbGxUb1RvcCgpIH0sXG4gICAgICAnY29yZTptb3ZlLXRvLWJvdHRvbSc6ICgpID0+IHsgdGhpcy5zY3JvbGxUb0JvdHRvbSgpIH1cbiAgICB9KSlcbiAgICBwcm9jZXNzLm5leHRUaWNrKCgpID0+IHRoaXMuaW5pdGlhbGl6ZVBhbmVscygpKVxuICB9XG5cbiAgdXBkYXRlICgpIHt9XG5cbiAgZGVzdHJveSAoKSB7XG4gICAgdGhpcy5kZXN0cm95ZWQgPSB0cnVlXG4gICAgdGhpcy5kaXNwb3NhYmxlcy5kaXNwb3NlKClcbiAgICBmb3IgKGxldCBuYW1lIGluIHRoaXMucGFuZWxzQnlOYW1lKSB7XG4gICAgICBjb25zdCBwYW5lbCA9IHRoaXMucGFuZWxzQnlOYW1lW25hbWVdXG4gICAgICBwYW5lbC5kZXN0cm95KClcbiAgICB9XG5cbiAgICByZXR1cm4gZXRjaC5kZXN0cm95KHRoaXMpXG4gIH1cblxuICByZW5kZXIgKCkge1xuICAgIHJldHVybiAoXG4gICAgICA8ZGl2IGNsYXNzTmFtZT0nc2V0dGluZ3MtdmlldyBwYW5lLWl0ZW0nIHRhYkluZGV4PSctMSc+XG4gICAgICAgIDxkaXYgY2xhc3NOYW1lPSdjb25maWctbWVudScgcmVmPSdzaWRlYmFyJz5cbiAgICAgICAgICA8dWwgY2xhc3NOYW1lPSdwYW5lbHMtbWVudSBuYXYgbmF2LXBpbGxzIG5hdi1zdGFja2VkJyByZWY9J3BhbmVsTWVudSc+XG4gICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0ncGFuZWwtbWVudS1zZXBhcmF0b3InIHJlZj0nbWVudVNlcGFyYXRvcic+PC9kaXY+XG4gICAgICAgICAgPC91bD5cbiAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nYnV0dG9uLWFyZWEnPlxuICAgICAgICAgICAgPGJ1dHRvbiBjbGFzc05hbWU9J2J0biBidG4tZGVmYXVsdCBpY29uIGljb24tbGluay1leHRlcm5hbCcgcmVmPSdvcGVuRG90QXRvbSc+T3BlbiBDb25maWcgRm9sZGVyPC9idXR0b24+XG4gICAgICAgICAgPC9kaXY+XG4gICAgICAgIDwvZGl2PlxuICAgICAgICB7LyogVGhlIHRhYmluZGV4IGF0dHIgYmVsb3cgZW5zdXJlcyB0aGF0IGNsaWNrcyBpbiBhIHBhbmVsIGl0ZW0gd29uJ3RcbiAgICAgICAgY2F1c2UgdGhpcyB2aWV3IHRvIGdhaW4gZm9jdXMuIFRoaXMgaXMgaW1wb3J0YW50IGJlY2F1c2Ugd2hlbiB0aGlzIHZpZXdcbiAgICAgICAgZ2FpbnMgZm9jdXMgKGUuZy4gaW1tZWRpYXRlbHkgYWZ0ZXIgYXRvbSBkaXNwbGF5cyBpdCksIGl0IGZvY3VzZXMgdGhlXG4gICAgICAgIGN1cnJlbnRseSBhY3RpdmUgcGFuZWwgaXRlbS4gSWYgdGhhdCBmb2N1c2luZyBjYXVzZXMgdGhlIGFjdGl2ZSBwYW5lbCB0b1xuICAgICAgICBzY3JvbGwgKGUuZy4gYmVjYXVzZSB0aGUgYWN0aXZlIHBhbmVsIGl0c2VsZiBwYXNzZXMgZm9jdXMgb24gdG8gYSBzZWFyY2hcbiAgICAgICAgYm94IGF0IHRoZSB0b3Agb2YgYSBzY3JvbGxlZCBwYW5lbCksIHRoZW4gdGhlIGJyb3dzZXIgd2lsbCBub3QgZmlyZSB0aGVcbiAgICAgICAgY2xpY2sgZXZlbnQgb24gdGhlIGVsZW1lbnQgd2l0aGluIHRoZSBwYW5lbCBvbiB3aGljaCB0aGUgdXNlciBvcmlnaW5hbGx5XG4gICAgICAgIGNsaWNrZWQgKGUuZy4gYSBwYWNrYWdlIGNhcmQpLiBUaGlzIHdvdWxkIHByZXZlbnQgdXMgZnJvbSBzaG93aW5nIGFcbiAgICAgICAgcGFja2FnZSBkZXRhaWwgdmlldyB3aGVuIGNsaWNraW5nIG9uIGEgcGFja2FnZSBjYXJkLiBQaGV3ISAqL31cbiAgICAgICAgPGRpdiBjbGFzc05hbWU9J3BhbmVscycgdGFiSW5kZXg9Jy0xJyByZWY9J3BhbmVscyc+PC9kaXY+XG4gICAgICA8L2Rpdj5cbiAgICApXG4gIH1cblxuICAvLyBUaGlzIHByZXZlbnRzIHRoZSB2aWV3IGJlaW5nIGFjdHVhbGx5IGRpc3Bvc2VkIHdoZW4gY2xvc2VkXG4gIC8vIElmIHlvdSByZW1vdmUgaXQgeW91IHdpbGwgbmVlZCB0byBlbnN1cmUgdGhlIGNhY2hlZCBzZXR0aW5nc1ZpZXdcbiAgLy8gaW4gbWFpbi5jb2ZmZWUgaXMgY29ycmVjdGx5IHJlbGVhc2VkIG9uIGNsb3NlIGFzIHdlbGwuLi5cbiAgb25EaWRDaGFuZ2VUaXRsZSAoKSB7IHJldHVybiBuZXcgRGlzcG9zYWJsZSgpIH1cblxuICBpbml0aWFsaXplUGFuZWxzICgpIHtcbiAgICBpZiAodGhpcy5yZWZzLnBhbmVscy5jaGlsZHJlbi5sZW5ndGggPiAxKSB7XG4gICAgICByZXR1cm5cbiAgICB9XG5cbiAgICB0aGlzLnBhbmVsc0J5TmFtZSA9IHt9XG4gICAgY29uc3QgY2xpY2tIYW5kbGVyID0gKGV2ZW50KSA9PiB7XG4gICAgICBjb25zdCB0YXJnZXQgPSBldmVudC50YXJnZXQuY2xvc2VzdCgnLnBhbmVscy1tZW51IGxpIGEsIC5wYW5lbHMtcGFja2FnZXMgbGkgYScpXG4gICAgICBpZiAodGFyZ2V0KSB7XG4gICAgICAgIHRoaXMuc2hvd1BhbmVsKHRhcmdldC5jbG9zZXN0KCdsaScpLm5hbWUpXG4gICAgICB9XG4gICAgfVxuICAgIHRoaXMuZWxlbWVudC5hZGRFdmVudExpc3RlbmVyKCdjbGljaycsIGNsaWNrSGFuZGxlcilcbiAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZChuZXcgRGlzcG9zYWJsZSgoKSA9PiB0aGlzLmVsZW1lbnQucmVtb3ZlRXZlbnRMaXN0ZW5lcignY2xpY2snLCBjbGlja0hhbmRsZXIpKSlcblxuICAgIGNvbnN0IGZvY3VzSGFuZGxlciA9ICgpID0+IHtcbiAgICAgIHRoaXMuZm9jdXNBY3RpdmVQYW5lbCgpXG4gICAgfVxuICAgIHRoaXMuZWxlbWVudC5hZGRFdmVudExpc3RlbmVyKCdmb2N1cycsIGZvY3VzSGFuZGxlcilcbiAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZChuZXcgRGlzcG9zYWJsZSgoKSA9PiB0aGlzLmVsZW1lbnQucmVtb3ZlRXZlbnRMaXN0ZW5lcignZm9jdXMnLCBmb2N1c0hhbmRsZXIpKSlcblxuXG4gICAgY29uc3Qgb3BlbkRvdEF0b21DbGlja0hhbmRsZXIgPSAoKSA9PiB7XG4gICAgICBhdG9tLm9wZW4oe3BhdGhzVG9PcGVuOiBbYXRvbS5nZXRDb25maWdEaXJQYXRoKCldfSlcbiAgICB9XG4gICAgdGhpcy5yZWZzLm9wZW5Eb3RBdG9tLmFkZEV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgb3BlbkRvdEF0b21DbGlja0hhbmRsZXIpXG4gICAgdGhpcy5kaXNwb3NhYmxlcy5hZGQobmV3IERpc3Bvc2FibGUoKCkgPT4gdGhpcy5yZWZzLm9wZW5Eb3RBdG9tLnJlbW92ZUV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgb3BlbkRvdEF0b21DbGlja0hhbmRsZXIpKSlcblxuICAgIHRoaXMuYWRkQ29yZVBhbmVsKCdDb3JlJywgJ3NldHRpbmdzJywgKCkgPT4gbmV3IEdlbmVyYWxQYW5lbCgpKVxuICAgIHRoaXMuYWRkQ29yZVBhbmVsKCdFZGl0b3InLCAnY29kZScsICgpID0+IG5ldyBFZGl0b3JQYW5lbCgpKVxuICAgIGlmICgocHJvY2Vzcy5wbGF0Zm9ybSA9PT0gJ3dpbjMyJykgJiYgKHJlcXVpcmUoJ2F0b20nKS5XaW5TaGVsbCAhPSBudWxsKSkge1xuICAgICAgY29uc3QgU3lzdGVtUGFuZWwgPSByZXF1aXJlKCcuL3N5c3RlbS13aW5kb3dzLXBhbmVsJylcbiAgICAgIHRoaXMuYWRkQ29yZVBhbmVsKCdTeXN0ZW0nLCAnZGV2aWNlLWRlc2t0b3AnLCAoKSA9PiBuZXcgU3lzdGVtUGFuZWwoKSlcbiAgICB9XG4gICAgdGhpcy5hZGRDb3JlUGFuZWwoJ0tleWJpbmRpbmdzJywgJ2tleWJvYXJkJywgKCkgPT4gbmV3IEtleWJpbmRpbmdzUGFuZWwoKSlcbiAgICB0aGlzLmFkZENvcmVQYW5lbCgnUGFja2FnZXMnLCAncGFja2FnZScsICgpID0+IG5ldyBJbnN0YWxsZWRQYWNrYWdlc1BhbmVsKHRoaXMsIHRoaXMucGFja2FnZU1hbmFnZXIpKVxuICAgIHRoaXMuYWRkQ29yZVBhbmVsKCdUaGVtZXMnLCAncGFpbnRjYW4nLCAoKSA9PiBuZXcgVGhlbWVzUGFuZWwodGhpcywgdGhpcy5wYWNrYWdlTWFuYWdlcikpXG4gICAgdGhpcy5hZGRDb3JlUGFuZWwoJ1VwZGF0ZXMnLCAnY2xvdWQtZG93bmxvYWQnLCAoKSA9PiBuZXcgVXBkYXRlc1BhbmVsKHRoaXMsIHRoaXMucGFja2FnZU1hbmFnZXIpKVxuICAgIHRoaXMuYWRkQ29yZVBhbmVsKCdJbnN0YWxsJywgJ3BsdXMnLCAoKSA9PiBuZXcgSW5zdGFsbFBhbmVsKHRoaXMsIHRoaXMucGFja2FnZU1hbmFnZXIpKVxuXG4gICAgdGhpcy5zaG93RGVmZXJyZWRQYW5lbCgpXG5cbiAgICBpZiAoIXRoaXMuYWN0aXZlUGFuZWwpIHtcbiAgICAgIHRoaXMuc2hvd1BhbmVsKCdDb3JlJylcbiAgICB9XG5cbiAgICBpZiAoZG9jdW1lbnQuYm9keS5jb250YWlucyh0aGlzLmVsZW1lbnQpKSB7XG4gICAgICB0aGlzLnJlZnMuc2lkZWJhci5zdHlsZS53aWR0aCA9IHRoaXMucmVmcy5zaWRlYmFyLm9mZnNldFdpZHRoXG4gICAgfVxuICB9XG5cbiAgc2VyaWFsaXplICgpIHtcbiAgICByZXR1cm4ge1xuICAgICAgZGVzZXJpYWxpemVyOiAnU2V0dGluZ3NWaWV3JyxcbiAgICAgIHZlcnNpb246IDIsXG4gICAgICBhY3RpdmVQYW5lbDogdGhpcy5hY3RpdmVQYW5lbCAhPSBudWxsID8gdGhpcy5hY3RpdmVQYW5lbCA6IHRoaXMuZGVmZXJyZWRQYW5lbCxcbiAgICAgIHVyaTogdGhpcy51cmlcbiAgICB9XG4gIH1cblxuICBnZXRQYWNrYWdlcyAoKSB7XG4gICAgbGV0IGJ1bmRsZWRQYWNrYWdlTWV0YWRhdGFDYWNoZVxuICAgIGxldCBsZWZ0XG4gICAgaWYgKHRoaXMucGFja2FnZXMgIT0gbnVsbCkgeyByZXR1cm4gdGhpcy5wYWNrYWdlcyB9XG5cbiAgICB0aGlzLnBhY2thZ2VzID0gYXRvbS5wYWNrYWdlcy5nZXRMb2FkZWRQYWNrYWdlcygpXG5cbiAgICB0cnkge1xuICAgICAgY29uc3QgcGFja2FnZU1ldGFkYXRhID0gcmVxdWlyZShwYXRoLmpvaW4oYXRvbS5nZXRMb2FkU2V0dGluZ3MoKS5yZXNvdXJjZVBhdGgsICdwYWNrYWdlLmpzb24nKSlcbiAgICAgIGJ1bmRsZWRQYWNrYWdlTWV0YWRhdGFDYWNoZSA9IHBhY2thZ2VNZXRhZGF0YSA/IHBhY2thZ2VNZXRhZGF0YS5fYXRvbVBhY2thZ2VzIDogbnVsbFxuICAgIH0gY2F0Y2ggKGVycm9yKSB7fVxuXG4gICAgLy8gSW5jbHVkZSBkaXNhYmxlZCBwYWNrYWdlcyBzbyB0aGV5IGNhbiBiZSByZS1lbmFibGVkIGZyb20gdGhlIFVJXG4gICAgY29uc3QgZGlzYWJsZWRQYWNrYWdlcyA9IGF0b20uY29uZmlnLmdldCgnY29yZS5kaXNhYmxlZFBhY2thZ2VzJykgfHwgW11cbiAgICBmb3IgKGNvbnN0IHBhY2thZ2VOYW1lIG9mIGRpc2FibGVkUGFja2FnZXMpIHtcbiAgICAgIHZhciBtZXRhZGF0YVxuICAgICAgY29uc3QgcGFja2FnZVBhdGggPSBhdG9tLnBhY2thZ2VzLnJlc29sdmVQYWNrYWdlUGF0aChwYWNrYWdlTmFtZSlcbiAgICAgIGlmICghcGFja2FnZVBhdGgpIHtcbiAgICAgICAgY29udGludWVcbiAgICAgIH1cblxuICAgICAgdHJ5IHtcbiAgICAgICAgbWV0YWRhdGEgPSByZXF1aXJlKHBhdGguam9pbihwYWNrYWdlUGF0aCwgJ3BhY2thZ2UuanNvbicpKVxuICAgICAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICAgICAgaWYgKGJ1bmRsZWRQYWNrYWdlTWV0YWRhdGFDYWNoZSAmJiBidW5kbGVkUGFja2FnZU1ldGFkYXRhQ2FjaGVbcGFja2FnZU5hbWVdKSB7XG4gICAgICAgICAgbWV0YWRhdGEgPSBidW5kbGVkUGFja2FnZU1ldGFkYXRhQ2FjaGVbcGFja2FnZU5hbWVdLm1ldGFkYXRhXG4gICAgICAgIH1cbiAgICAgIH1cbiAgICAgIGlmIChtZXRhZGF0YSA9PSBudWxsKSB7XG4gICAgICAgIGNvbnRpbnVlXG4gICAgICB9XG5cbiAgICAgIGNvbnN0IG5hbWUgPSBtZXRhZGF0YS5uYW1lICE9IG51bGwgPyBtZXRhZGF0YS5uYW1lIDogcGFja2FnZU5hbWVcbiAgICAgIGlmICghXy5maW5kV2hlcmUodGhpcy5wYWNrYWdlcywge25hbWV9KSkge1xuICAgICAgICB0aGlzLnBhY2thZ2VzLnB1c2goe25hbWUsIG1ldGFkYXRhLCBwYXRoOiBwYWNrYWdlUGF0aH0pXG4gICAgICB9XG4gICAgfVxuXG4gICAgdGhpcy5wYWNrYWdlcy5zb3J0KChwYWNrMSwgcGFjazIpID0+IHtcbiAgICAgIGNvbnN0IHRpdGxlMSA9IHRoaXMucGFja2FnZU1hbmFnZXIuZ2V0UGFja2FnZVRpdGxlKHBhY2sxKVxuICAgICAgY29uc3QgdGl0bGUyID0gdGhpcy5wYWNrYWdlTWFuYWdlci5nZXRQYWNrYWdlVGl0bGUocGFjazIpXG4gICAgICByZXR1cm4gdGl0bGUxLmxvY2FsZUNvbXBhcmUodGl0bGUyKVxuICAgIH0pXG5cbiAgICByZXR1cm4gdGhpcy5wYWNrYWdlc1xuICB9XG5cbiAgYWRkQ29yZVBhbmVsIChuYW1lLCBpY29uTmFtZSwgcGFuZWwpIHtcbiAgICBjb25zdCBwYW5lbE1lbnVJdGVtID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnbGknKVxuICAgIHBhbmVsTWVudUl0ZW0ubmFtZSA9IG5hbWVcbiAgICBwYW5lbE1lbnVJdGVtLnNldEF0dHJpYnV0ZSgnbmFtZScsIG5hbWUpXG5cbiAgICBjb25zdCBhID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnYScpXG4gICAgYS5jbGFzc0xpc3QuYWRkKCdpY29uJywgYGljb24tJHtpY29uTmFtZX1gKVxuICAgIGEudGV4dENvbnRlbnQgPSBuYW1lXG4gICAgcGFuZWxNZW51SXRlbS5hcHBlbmRDaGlsZChhKVxuXG4gICAgdGhpcy5yZWZzLm1lbnVTZXBhcmF0b3IucGFyZW50RWxlbWVudC5pbnNlcnRCZWZvcmUocGFuZWxNZW51SXRlbSwgdGhpcy5yZWZzLm1lbnVTZXBhcmF0b3IpXG4gICAgdGhpcy5hZGRQYW5lbChuYW1lLCBwYW5lbClcbiAgfVxuXG4gIGFkZFBhbmVsIChuYW1lLCBwYW5lbENyZWF0ZUNhbGxiYWNrKSB7XG4gICAgaWYgKHRoaXMucGFuZWxDcmVhdGVDYWxsYmFja3MgPT0gbnVsbCkge1xuICAgICAgdGhpcy5wYW5lbENyZWF0ZUNhbGxiYWNrcyA9IHt9XG4gICAgfVxuICAgIHRoaXMucGFuZWxDcmVhdGVDYWxsYmFja3NbbmFtZV0gPSBwYW5lbENyZWF0ZUNhbGxiYWNrXG4gICAgaWYgKHRoaXMuZGVmZXJyZWRQYW5lbCAmJiB0aGlzLmRlZmVycmVkUGFuZWwubmFtZSA9PT0gbmFtZSkge1xuICAgICAgdGhpcy5zaG93RGVmZXJyZWRQYW5lbCgpXG4gICAgfVxuICB9XG5cbiAgZ2V0T3JDcmVhdGVQYW5lbCAobmFtZSwgb3B0aW9ucykge1xuICAgIGxldCBwYW5lbCA9IHRoaXMucGFuZWxzQnlOYW1lID8gdGhpcy5wYW5lbHNCeU5hbWVbbmFtZV0gOiBudWxsXG4gICAgLy8gVGhlc2UgbmVzdGVkIGNvbmRpdGlvbmFscyBhcmUgbm90IGdyZWF0IGJ1dCBJIGZlZWwgbGlrZSBpdCdzIHRoZSBtb3N0XG4gICAgLy8gZXhwZWRpZW50IHRoaW5nIHRvIGRvIC0gSSBmZWVsIGxpa2UgdGhlIFwicmlnaHQgd2F5XCIgaW52b2x2ZXMgcmVmYWN0b3JpbmdcbiAgICAvLyB0aGlzIHdob2xlIGZpbGUuXG4gICAgaWYgKCFwYW5lbCkge1xuICAgICAgbGV0IGNhbGxiYWNrID0gdGhpcy5wYW5lbENyZWF0ZUNhbGxiYWNrcyA/IHRoaXMucGFuZWxDcmVhdGVDYWxsYmFja3NbbmFtZV0gOiBudWxsXG5cbiAgICAgIGlmIChvcHRpb25zICYmIG9wdGlvbnMucGFjayAmJiAhY2FsbGJhY2spIHtcbiAgICAgICAgY2FsbGJhY2sgPSAoKSA9PiB7XG4gICAgICAgICAgaWYgKCFvcHRpb25zLnBhY2subWV0YWRhdGEpIHtcbiAgICAgICAgICAgIGNvbnN0IG1ldGFkYXRhID0gXy5jbG9uZShvcHRpb25zLnBhY2spXG4gICAgICAgICAgICBvcHRpb25zLnBhY2subWV0YWRhdGEgPSBtZXRhZGF0YVxuICAgICAgICAgIH1cbiAgICAgICAgICByZXR1cm4gbmV3IFBhY2thZ2VEZXRhaWxWaWV3KG9wdGlvbnMucGFjaywgdGhpcywgdGhpcy5wYWNrYWdlTWFuYWdlciwgdGhpcy5zbmlwcGV0c1Byb3ZpZGVyKVxuICAgICAgICB9XG4gICAgICB9XG5cbiAgICAgIGlmIChjYWxsYmFjaykge1xuICAgICAgICBwYW5lbCA9IGNhbGxiYWNrKClcbiAgICAgICAgaWYgKHRoaXMucGFuZWxzQnlOYW1lID09IG51bGwpIHtcbiAgICAgICAgICB0aGlzLnBhbmVsc0J5TmFtZSA9IHt9XG4gICAgICAgIH1cbiAgICAgICAgdGhpcy5wYW5lbHNCeU5hbWVbbmFtZV0gPSBwYW5lbFxuICAgICAgICBpZiAodGhpcy5wYW5lbENyZWF0ZUNhbGxiYWNrcykge1xuICAgICAgICAgIGRlbGV0ZSB0aGlzLnBhbmVsQ3JlYXRlQ2FsbGJhY2tzW25hbWVdXG4gICAgICAgIH1cbiAgICAgIH1cbiAgICB9XG5cbiAgICByZXR1cm4gcGFuZWxcbiAgfVxuXG4gIG1ha2VQYW5lbE1lbnVBY3RpdmUgKG5hbWUpIHtcbiAgICBjb25zdCBwcmV2aW91c2x5QWN0aXZlUGFuZWwgPSB0aGlzLnJlZnMuc2lkZWJhci5xdWVyeVNlbGVjdG9yKCcuYWN0aXZlJylcbiAgICBpZiAocHJldmlvdXNseUFjdGl2ZVBhbmVsKSB7XG4gICAgICBwcmV2aW91c2x5QWN0aXZlUGFuZWwuY2xhc3NMaXN0LnJlbW92ZSgnYWN0aXZlJylcbiAgICB9XG5cbiAgICBjb25zdCBuZXdBY3RpdmVQYW5lbCA9IHRoaXMucmVmcy5zaWRlYmFyLnF1ZXJ5U2VsZWN0b3IoYFtuYW1lPScke25hbWV9J11gKVxuICAgIGlmIChuZXdBY3RpdmVQYW5lbCkge1xuICAgICAgbmV3QWN0aXZlUGFuZWwuY2xhc3NMaXN0LmFkZCgnYWN0aXZlJylcbiAgICB9XG4gIH1cblxuICBmb2N1c0FjdGl2ZVBhbmVsICgpIHtcbiAgICAvLyBQYXNzIGZvY3VzIHRvIHBhbmVsIHRoYXQgaXMgY3VycmVudGx5IHZpc2libGVcbiAgICBmb3IgKGxldCBpID0gMDsgaSA8IHRoaXMucmVmcy5wYW5lbHMuY2hpbGRyZW4ubGVuZ3RoOyBpKyspIHtcbiAgICAgIGNvbnN0IGNoaWxkID0gdGhpcy5yZWZzLnBhbmVscy5jaGlsZHJlbltpXVxuICAgICAgaWYgKGNoaWxkLm9mZnNldFdpZHRoID4gMCkge1xuICAgICAgICBjaGlsZC5mb2N1cygpXG4gICAgICB9XG4gICAgfVxuICB9XG5cbiAgc2hvd0RlZmVycmVkUGFuZWwgKCkge1xuICAgIGlmICh0aGlzLmRlZmVycmVkUGFuZWwpIHtcbiAgICAgIGNvbnN0IHtuYW1lLCBvcHRpb25zfSA9IHRoaXMuZGVmZXJyZWRQYW5lbFxuICAgICAgdGhpcy5zaG93UGFuZWwobmFtZSwgb3B0aW9ucylcbiAgICB9XG4gIH1cblxuICAvLyBQdWJsaWM6IHNob3cgYSBwYW5lbC5cbiAgLy9cbiAgLy8gKiBgbmFtZWAge1N0cmluZ30gdGhlIG5hbWUgb2YgdGhlIHBhbmVsIHRvIHNob3dcbiAgLy8gKiBgb3B0aW9uc2Age09iamVjdH0gYW4gb3B0aW9ucyBoYXNoLiBXaWxsIGJlIHBhc3NlZCB0byBgYmVmb3JlU2hvdygpYCBvblxuICAvLyAgIHRoZSBwYW5lbC4gT3B0aW9ucyBtYXkgaW5jbHVkZSAoYnV0IGFyZSBub3QgbGltaXRlZCB0byk6XG4gIC8vICAgKiBgdXJpYCB0aGUgVVJJIHRoZSBwYW5lbCB3YXMgbGF1bmNoZWQgZnJvbVxuICBzaG93UGFuZWwgKG5hbWUsIG9wdGlvbnMpIHtcbiAgICBjb25zdCBwYW5lbCA9IHRoaXMuZ2V0T3JDcmVhdGVQYW5lbChuYW1lLCBvcHRpb25zKVxuICAgIGlmIChwYW5lbCkge1xuICAgICAgdGhpcy5hcHBlbmRQYW5lbChwYW5lbCwgb3B0aW9ucylcbiAgICAgIHRoaXMubWFrZVBhbmVsTWVudUFjdGl2ZShuYW1lKVxuICAgICAgdGhpcy5zZXRBY3RpdmVQYW5lbChuYW1lLCBvcHRpb25zKVxuICAgICAgdGhpcy5kZWZlcnJlZFBhbmVsID0gbnVsbFxuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLmRlZmVycmVkUGFuZWwgPSB7bmFtZSwgb3B0aW9uc31cbiAgICB9XG4gIH1cblxuICBhcHBlbmRQYW5lbCAocGFuZWwsIG9wdGlvbnMpIHtcbiAgICBmb3IgKGxldCBpID0gMDsgaSA8IHRoaXMucmVmcy5wYW5lbHMuY2hpbGRyZW4ubGVuZ3RoOyBpKyspIHtcbiAgICAgIHRoaXMucmVmcy5wYW5lbHMuY2hpbGRyZW5baV0uc3R5bGUuZGlzcGxheSA9ICdub25lJ1xuICAgIH1cblxuICAgIGlmICghdGhpcy5yZWZzLnBhbmVscy5jb250YWlucyhwYW5lbC5lbGVtZW50KSkge1xuICAgICAgdGhpcy5yZWZzLnBhbmVscy5hcHBlbmRDaGlsZChwYW5lbC5lbGVtZW50KVxuICAgIH1cblxuICAgIGlmIChwYW5lbC5iZWZvcmVTaG93KSB7XG4gICAgICBwYW5lbC5iZWZvcmVTaG93KG9wdGlvbnMpXG4gICAgfVxuICAgIHBhbmVsLnNob3coKVxuICAgIHBhbmVsLmZvY3VzKClcbiAgfVxuXG4gIHNldEFjdGl2ZVBhbmVsIChuYW1lLCBvcHRpb25zID0ge30pIHtcbiAgICB0aGlzLmFjdGl2ZVBhbmVsID0ge25hbWUsIG9wdGlvbnN9XG4gIH1cblxuICByZW1vdmVQYW5lbCAobmFtZSkge1xuICAgIGNvbnN0IHBhbmVsID0gdGhpcy5wYW5lbHNCeU5hbWUgPyB0aGlzLnBhbmVsc0J5TmFtZVtuYW1lXSA6IG51bGxcbiAgICBpZiAocGFuZWwpIHtcbiAgICAgIHBhbmVsLmRlc3Ryb3koKVxuICAgICAgZGVsZXRlIHRoaXMucGFuZWxzQnlOYW1lW25hbWVdXG4gICAgfVxuICB9XG5cbiAgZ2V0VGl0bGUgKCkge1xuICAgIHJldHVybiAnU2V0dGluZ3MnXG4gIH1cblxuICBnZXRJY29uTmFtZSAoKSB7XG4gICAgcmV0dXJuICd0b29scydcbiAgfVxuXG4gIGdldFVSSSAoKSB7XG4gICAgcmV0dXJuIHRoaXMudXJpXG4gIH1cblxuICBpc0VxdWFsIChvdGhlcikge1xuICAgIHJldHVybiBvdGhlciBpbnN0YW5jZW9mIFNldHRpbmdzVmlld1xuICB9XG5cbiAgc2Nyb2xsVXAgKCkge1xuICAgIHRoaXMuZWxlbWVudC5zY3JvbGxUb3AgLT0gZG9jdW1lbnQuYm9keS5vZmZzZXRIZWlnaHQgLyAyMFxuICB9XG5cbiAgc2Nyb2xsRG93biAoKSB7XG4gICAgdGhpcy5lbGVtZW50LnNjcm9sbFRvcCArPSBkb2N1bWVudC5ib2R5Lm9mZnNldEhlaWdodCAvIDIwXG4gIH1cblxuICBwYWdlVXAgKCkge1xuICAgIHRoaXMuZWxlbWVudC5zY3JvbGxUb3AgLT0gdGhpcy5lbGVtZW50Lm9mZnNldEhlaWdodFxuICB9XG5cbiAgcGFnZURvd24gKCkge1xuICAgIHRoaXMuZWxlbWVudC5zY3JvbGxUb3AgKz0gdGhpcy5lbGVtZW50Lm9mZnNldEhlaWdodFxuICB9XG5cbiAgc2Nyb2xsVG9Ub3AgKCkge1xuICAgIHRoaXMuZWxlbWVudC5zY3JvbGxUb3AgPSAwXG4gIH1cblxuICBzY3JvbGxUb0JvdHRvbSAoKSB7XG4gICAgdGhpcy5lbGVtZW50LnNjcm9sbFRvcCA9IHRoaXMuZWxlbWVudC5zY3JvbGxIZWlnaHRcbiAgfVxufVxuIl19