Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _roaster = require('roaster');

var _roaster2 = _interopRequireDefault(_roaster);

var ATTRIBUTES_TO_REMOVE = ['onabort', 'onblur', 'onchange', 'onclick', 'ondbclick', 'onerror', 'onfocus', 'onkeydown', 'onkeypress', 'onkeyup', 'onload', 'onmousedown', 'onmousemove', 'onmouseover', 'onmouseout', 'onmouseup', 'onreset', 'onresize', 'onscroll', 'onselect', 'onsubmit', 'onunload'];

function sanitize(html) {
  var temporaryContainer = document.createElement('div');
  temporaryContainer.innerHTML = html;

  for (var script of temporaryContainer.querySelectorAll('script')) {
    script.remove();
  }

  for (var element of temporaryContainer.querySelectorAll('*')) {
    for (var attribute of ATTRIBUTES_TO_REMOVE) {
      element.removeAttribute(attribute);
    }
  }

  for (var checkbox of temporaryContainer.querySelectorAll('input[type="checkbox"]')) {
    checkbox.setAttribute('disabled', true);
  }

  return temporaryContainer.innerHTML;
}

// Displays the readme for a package, if it has one
// TODO Decide to keep this or current button-to-new-tab view

var PackageReadmeView = (function () {
  function PackageReadmeView(readme) {
    var _this = this;

    _classCallCheck(this, PackageReadmeView);

    this.element = document.createElement('section');
    this.element.classList.add('section');

    var container = document.createElement('div');
    container.classList.add('section-container');

    var heading = document.createElement('div');
    heading.classList.add('section-heading', 'icon', 'icon-book');
    heading.textContent = 'README';
    container.appendChild(heading);

    this.packageReadme = document.createElement('div');
    this.packageReadme.classList.add('package-readme', 'native-key-bindings');
    this.packageReadme.tabIndex = -1;
    container.appendChild(this.packageReadme);
    this.element.appendChild(container);

    (0, _roaster2['default'])(readme || '### No README.', function (err, content) {
      if (err) {
        _this.packageReadme.innerHTML = '<h3>Error parsing README</h3>';
      } else {
        _this.packageReadme.innerHTML = sanitize(content);
      }
    });
  }

  _createClass(PackageReadmeView, [{
    key: 'destroy',
    value: function destroy() {
      this.element.remove();
    }
  }]);

  return PackageReadmeView;
})();

exports['default'] = PackageReadmeView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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