(function() {
  var GitHubFile, getActivePath, getSelectedRange;

  GitHubFile = require('./github-file');

  module.exports = {
    activate: function() {
      return atom.commands.add('atom-pane', {
        'open-on-github:file': function() {
          var itemPath;
          if (itemPath = getActivePath()) {
            return GitHubFile.fromPath(itemPath).open(getSelectedRange());
          }
        },
        'open-on-github:file-on-master': function() {
          var itemPath;
          if (itemPath = getActivePath()) {
            return GitHubFile.fromPath(itemPath).openOnMaster(getSelectedRange());
          }
        },
        'open-on-github:blame': function() {
          var itemPath;
          if (itemPath = getActivePath()) {
            return GitHubFile.fromPath(itemPath).blame(getSelectedRange());
          }
        },
        'open-on-github:history': function() {
          var itemPath;
          if (itemPath = getActivePath()) {
            return GitHubFile.fromPath(itemPath).history();
          }
        },
        'open-on-github:issues': function() {
          var itemPath;
          if (itemPath = getActivePath()) {
            return GitHubFile.fromPath(itemPath).openIssues();
          }
        },
        'open-on-github:copy-url': function() {
          var itemPath;
          if (itemPath = getActivePath()) {
            return GitHubFile.fromPath(itemPath).copyUrl(getSelectedRange());
          }
        },
        'open-on-github:branch-compare': function() {
          var itemPath;
          if (itemPath = getActivePath()) {
            return GitHubFile.fromPath(itemPath).openBranchCompare();
          }
        },
        'open-on-github:repository': function() {
          var itemPath;
          if (itemPath = getActivePath()) {
            return GitHubFile.fromPath(itemPath).openRepository();
          }
        }
      });
    }
  };

  getActivePath = function() {
    var ref;
    return (ref = atom.workspace.getActivePaneItem()) != null ? typeof ref.getPath === "function" ? ref.getPath() : void 0 : void 0;
  };

  getSelectedRange = function() {
    var ref;
    return (ref = atom.workspace.getActivePaneItem()) != null ? typeof ref.getSelectedBufferRange === "function" ? ref.getSelectedBufferRange() : void 0 : void 0;
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2hvbWUvYW5kcmVpL2F0b20tMS4xOS4yL291dC9hcHAvbm9kZV9tb2R1bGVzL29wZW4tb24tZ2l0aHViL2xpYi9tYWluLmNvZmZlZSJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtBQUFBLE1BQUE7O0VBQUEsVUFBQSxHQUFjLE9BQUEsQ0FBUSxlQUFSOztFQUVkLE1BQU0sQ0FBQyxPQUFQLEdBQ0U7SUFBQSxRQUFBLEVBQVUsU0FBQTthQUNSLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBZCxDQUFrQixXQUFsQixFQUNFO1FBQUEscUJBQUEsRUFBdUIsU0FBQTtBQUNyQixjQUFBO1VBQUEsSUFBRyxRQUFBLEdBQVcsYUFBQSxDQUFBLENBQWQ7bUJBQ0UsVUFBVSxDQUFDLFFBQVgsQ0FBb0IsUUFBcEIsQ0FBNkIsQ0FBQyxJQUE5QixDQUFtQyxnQkFBQSxDQUFBLENBQW5DLEVBREY7O1FBRHFCLENBQXZCO1FBSUEsK0JBQUEsRUFBaUMsU0FBQTtBQUMvQixjQUFBO1VBQUEsSUFBRyxRQUFBLEdBQVcsYUFBQSxDQUFBLENBQWQ7bUJBQ0UsVUFBVSxDQUFDLFFBQVgsQ0FBb0IsUUFBcEIsQ0FBNkIsQ0FBQyxZQUE5QixDQUEyQyxnQkFBQSxDQUFBLENBQTNDLEVBREY7O1FBRCtCLENBSmpDO1FBUUEsc0JBQUEsRUFBd0IsU0FBQTtBQUN0QixjQUFBO1VBQUEsSUFBRyxRQUFBLEdBQVcsYUFBQSxDQUFBLENBQWQ7bUJBQ0UsVUFBVSxDQUFDLFFBQVgsQ0FBb0IsUUFBcEIsQ0FBNkIsQ0FBQyxLQUE5QixDQUFvQyxnQkFBQSxDQUFBLENBQXBDLEVBREY7O1FBRHNCLENBUnhCO1FBWUEsd0JBQUEsRUFBMEIsU0FBQTtBQUN4QixjQUFBO1VBQUEsSUFBRyxRQUFBLEdBQVcsYUFBQSxDQUFBLENBQWQ7bUJBQ0UsVUFBVSxDQUFDLFFBQVgsQ0FBb0IsUUFBcEIsQ0FBNkIsQ0FBQyxPQUE5QixDQUFBLEVBREY7O1FBRHdCLENBWjFCO1FBZ0JBLHVCQUFBLEVBQXlCLFNBQUE7QUFDdkIsY0FBQTtVQUFBLElBQUcsUUFBQSxHQUFXLGFBQUEsQ0FBQSxDQUFkO21CQUNFLFVBQVUsQ0FBQyxRQUFYLENBQW9CLFFBQXBCLENBQTZCLENBQUMsVUFBOUIsQ0FBQSxFQURGOztRQUR1QixDQWhCekI7UUFvQkEseUJBQUEsRUFBMkIsU0FBQTtBQUN6QixjQUFBO1VBQUEsSUFBRyxRQUFBLEdBQVcsYUFBQSxDQUFBLENBQWQ7bUJBQ0UsVUFBVSxDQUFDLFFBQVgsQ0FBb0IsUUFBcEIsQ0FBNkIsQ0FBQyxPQUE5QixDQUFzQyxnQkFBQSxDQUFBLENBQXRDLEVBREY7O1FBRHlCLENBcEIzQjtRQXdCQSwrQkFBQSxFQUFpQyxTQUFBO0FBQy9CLGNBQUE7VUFBQSxJQUFHLFFBQUEsR0FBVyxhQUFBLENBQUEsQ0FBZDttQkFDRSxVQUFVLENBQUMsUUFBWCxDQUFvQixRQUFwQixDQUE2QixDQUFDLGlCQUE5QixDQUFBLEVBREY7O1FBRCtCLENBeEJqQztRQTRCQSwyQkFBQSxFQUE2QixTQUFBO0FBQzNCLGNBQUE7VUFBQSxJQUFHLFFBQUEsR0FBVyxhQUFBLENBQUEsQ0FBZDttQkFDRSxVQUFVLENBQUMsUUFBWCxDQUFvQixRQUFwQixDQUE2QixDQUFDLGNBQTlCLENBQUEsRUFERjs7UUFEMkIsQ0E1QjdCO09BREY7SUFEUSxDQUFWOzs7RUFrQ0YsYUFBQSxHQUFnQixTQUFBO0FBQ2QsUUFBQTt1R0FBa0MsQ0FBRTtFQUR0Qjs7RUFHaEIsZ0JBQUEsR0FBbUIsU0FBQTtBQUNqQixRQUFBO3NIQUFrQyxDQUFFO0VBRG5CO0FBeENuQiIsInNvdXJjZXNDb250ZW50IjpbIkdpdEh1YkZpbGUgID0gcmVxdWlyZSAnLi9naXRodWItZmlsZSdcblxubW9kdWxlLmV4cG9ydHMgPVxuICBhY3RpdmF0ZTogLT5cbiAgICBhdG9tLmNvbW1hbmRzLmFkZCAnYXRvbS1wYW5lJyxcbiAgICAgICdvcGVuLW9uLWdpdGh1YjpmaWxlJzogLT5cbiAgICAgICAgaWYgaXRlbVBhdGggPSBnZXRBY3RpdmVQYXRoKClcbiAgICAgICAgICBHaXRIdWJGaWxlLmZyb21QYXRoKGl0ZW1QYXRoKS5vcGVuKGdldFNlbGVjdGVkUmFuZ2UoKSlcblxuICAgICAgJ29wZW4tb24tZ2l0aHViOmZpbGUtb24tbWFzdGVyJzogLT5cbiAgICAgICAgaWYgaXRlbVBhdGggPSBnZXRBY3RpdmVQYXRoKClcbiAgICAgICAgICBHaXRIdWJGaWxlLmZyb21QYXRoKGl0ZW1QYXRoKS5vcGVuT25NYXN0ZXIoZ2V0U2VsZWN0ZWRSYW5nZSgpKVxuXG4gICAgICAnb3Blbi1vbi1naXRodWI6YmxhbWUnOiAtPlxuICAgICAgICBpZiBpdGVtUGF0aCA9IGdldEFjdGl2ZVBhdGgoKVxuICAgICAgICAgIEdpdEh1YkZpbGUuZnJvbVBhdGgoaXRlbVBhdGgpLmJsYW1lKGdldFNlbGVjdGVkUmFuZ2UoKSlcblxuICAgICAgJ29wZW4tb24tZ2l0aHViOmhpc3RvcnknOiAtPlxuICAgICAgICBpZiBpdGVtUGF0aCA9IGdldEFjdGl2ZVBhdGgoKVxuICAgICAgICAgIEdpdEh1YkZpbGUuZnJvbVBhdGgoaXRlbVBhdGgpLmhpc3RvcnkoKVxuXG4gICAgICAnb3Blbi1vbi1naXRodWI6aXNzdWVzJzogLT5cbiAgICAgICAgaWYgaXRlbVBhdGggPSBnZXRBY3RpdmVQYXRoKClcbiAgICAgICAgICBHaXRIdWJGaWxlLmZyb21QYXRoKGl0ZW1QYXRoKS5vcGVuSXNzdWVzKClcblxuICAgICAgJ29wZW4tb24tZ2l0aHViOmNvcHktdXJsJzogLT5cbiAgICAgICAgaWYgaXRlbVBhdGggPSBnZXRBY3RpdmVQYXRoKClcbiAgICAgICAgICBHaXRIdWJGaWxlLmZyb21QYXRoKGl0ZW1QYXRoKS5jb3B5VXJsKGdldFNlbGVjdGVkUmFuZ2UoKSlcblxuICAgICAgJ29wZW4tb24tZ2l0aHViOmJyYW5jaC1jb21wYXJlJzogLT5cbiAgICAgICAgaWYgaXRlbVBhdGggPSBnZXRBY3RpdmVQYXRoKClcbiAgICAgICAgICBHaXRIdWJGaWxlLmZyb21QYXRoKGl0ZW1QYXRoKS5vcGVuQnJhbmNoQ29tcGFyZSgpXG5cbiAgICAgICdvcGVuLW9uLWdpdGh1YjpyZXBvc2l0b3J5JzogLT5cbiAgICAgICAgaWYgaXRlbVBhdGggPSBnZXRBY3RpdmVQYXRoKClcbiAgICAgICAgICBHaXRIdWJGaWxlLmZyb21QYXRoKGl0ZW1QYXRoKS5vcGVuUmVwb3NpdG9yeSgpXG5cbmdldEFjdGl2ZVBhdGggPSAtPlxuICBhdG9tLndvcmtzcGFjZS5nZXRBY3RpdmVQYW5lSXRlbSgpPy5nZXRQYXRoPygpXG5cbmdldFNlbGVjdGVkUmFuZ2UgPSAtPlxuICBhdG9tLndvcmtzcGFjZS5nZXRBY3RpdmVQYW5lSXRlbSgpPy5nZXRTZWxlY3RlZEJ1ZmZlclJhbmdlPygpXG4iXX0=
