(function() {
  var Reporter, extend, getOsArch, getReleaseChannel, path, post, querystring,
    slice = [].slice;

  path = require('path');

  querystring = require('querystring');

  extend = function() {
    var i, key, len, propertyMap, propertyMaps, target, value;
    target = arguments[0], propertyMaps = 2 <= arguments.length ? slice.call(arguments, 1) : [];
    for (i = 0, len = propertyMaps.length; i < len; i++) {
      propertyMap = propertyMaps[i];
      for (key in propertyMap) {
        value = propertyMap[key];
        target[key] = value;
      }
    }
    return target;
  };

  post = function(url) {
    var xhr;
    xhr = new XMLHttpRequest();
    xhr.open('POST', url);
    return xhr.send(null);
  };

  getReleaseChannel = function() {
    var version;
    version = atom.getVersion();
    if (version.indexOf('beta') > -1) {
      return 'beta';
    } else if (version.indexOf('dev') > -1) {
      return 'dev';
    } else {
      return 'stable';
    }
  };

  getOsArch = function() {
    if (process.platform === 'win32' && process.env.PROCESSOR_ARCHITEW6432 === 'AMD64') {
      return 'x64';
    }
    return process.arch;
  };

  module.exports = Reporter = (function() {
    function Reporter() {}

    Reporter.consented = function() {
      return atom.config.get('core.telemetryConsent') === 'limited';
    };

    Reporter.sendEvent = function(category, action, label, value) {
      var params;
      params = {
        t: 'event',
        ec: category,
        ea: action
      };
      if (label != null) {
        params.el = label;
      }
      if (value != null) {
        params.ev = value;
      }
      return this.send(params);
    };

    Reporter.sendTiming = function(category, name, value) {
      var params;
      params = {
        t: 'timing',
        utc: category,
        utv: name,
        utt: value
      };
      return this.send(params);
    };

    Reporter.sendException = function(description) {
      var params;
      params = {
        t: 'exception',
        exd: description,
        exf: atom.inDevMode() ? '0' : '1'
      };
      return this.send(params);
    };

    Reporter.viewNameForPaneItem = function(item) {
      var extension, itemPath, name, ref;
      name = (ref = typeof item.getViewClass === "function" ? item.getViewClass().name : void 0) != null ? ref : item.constructor.name;
      itemPath = typeof item.getPath === "function" ? item.getPath() : void 0;
      if (!((itemPath != null) && path.dirname(itemPath) === atom.getConfigDirPath())) {
        return name;
      }
      extension = path.extname(itemPath);
      switch (path.basename(itemPath, extension)) {
        case 'config':
          if (extension === '.json' || extension === '.cson') {
            name = 'UserConfig';
          }
          break;
        case 'init':
          if (extension === '.js' || extension === '.coffee') {
            name = 'UserInitScript';
          }
          break;
        case 'keymap':
          if (extension === '.json' || extension === '.cson') {
            name = 'UserKeymap';
          }
          break;
        case 'snippets':
          if (extension === '.json' || extension === '.cson') {
            name = 'UserSnippets';
          }
          break;
        case 'styles':
          if (extension === '.css' || extension === '.less') {
            name = 'UserStylesheet';
          }
      }
      return name;
    };

    Reporter.sendPaneItem = function(item) {
      var grammarName, params, ref;
      params = {
        t: 'appview',
        cd: this.viewNameForPaneItem(item)
      };
      grammarName = typeof item.getGrammar === "function" ? (ref = item.getGrammar()) != null ? ref.name : void 0 : void 0;
      if (grammarName != null) {
        params.dt = grammarName;
      }
      return this.send(params);
    };

    Reporter.sendCommand = function(commandName) {
      var base, params;
      if (this.commandCount == null) {
        this.commandCount = {};
      }
      if ((base = this.commandCount)[commandName] == null) {
        base[commandName] = 0;
      }
      this.commandCount[commandName]++;
      params = {
        t: 'event',
        ec: 'command',
        ea: commandName.split(':')[0],
        el: commandName,
        ev: this.commandCount[commandName]
      };
      return this.send(params);
    };

    Reporter.send = function(params) {
      if (navigator.onLine) {
        extend(params, {
          v: 1,
          aip: 1,
          tid: 'UA-3769691-33',
          cid: localStorage.getItem('metrics.userId'),
          an: 'atom',
          av: atom.getVersion()
        });
        if (Reporter.consented()) {
          extend(params, Reporter.consentedParams());
        }
        if (Reporter.consented() || Reporter.isTelemetryConsentChoice(params)) {
          return Reporter.request("https://ssl.google-analytics.com/collect?" + (querystring.stringify(params)));
        }
      }
    };

    Reporter.isTelemetryConsentChoice = function(params) {
      return params.t === 'event' && params.ec === 'setting' && params.ea === 'core.telemetryConsent';
    };

    Reporter.request = function(url) {
      return post(url);
    };

    Reporter.consentedParams = function() {
      var memUse;
      memUse = process.memoryUsage();
      return {
        cd2: getOsArch(),
        cd3: process.arch,
        cm1: memUse.heapUsed >> 20,
        cm2: Math.round((memUse.heapUsed / memUse.heapTotal) * 100),
        sr: screen.width + "x" + screen.height,
        vp: innerWidth + "x" + innerHeight,
        aiid: getReleaseChannel()
      };
    };

    return Reporter;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
