(function() {
  var _, linkAtPosition, linkForName, linkUnderCursor, openLink, selector, shell, url;

  url = require('url');

  shell = require('electron').shell;

  _ = require('underscore-plus');

  selector = null;

  module.exports = {
    activate: function() {
      return atom.commands.add('atom-workspace', 'link:open', openLink);
    }
  };

  openLink = function() {
    var editor, link, protocol;
    editor = atom.workspace.getActiveTextEditor();
    if (editor == null) {
      return;
    }
    link = linkUnderCursor(editor);
    if (link == null) {
      return;
    }
    if (editor.getGrammar().scopeName === 'source.gfm') {
      link = linkForName(editor.getBuffer(), link);
    }
    protocol = url.parse(link).protocol;
    if (protocol === 'http:' || protocol === 'https:') {
      return shell.openExternal(link);
    }
  };

  linkUnderCursor = function(editor) {
    var cursorPosition, link;
    cursorPosition = editor.getCursorBufferPosition();
    link = linkAtPosition(editor, cursorPosition);
    if (link != null) {
      return link;
    }
    if (cursorPosition.column > 0) {
      return linkAtPosition(editor, cursorPosition.translate([0, -1]));
    }
  };

  linkAtPosition = function(editor, bufferPosition) {
    var ScopeSelector, token;
    if (selector == null) {
      ScopeSelector = require('first-mate').ScopeSelector;
      selector = new ScopeSelector('markup.underline.link');
    }
    if (token = editor.tokenForBufferPosition(bufferPosition)) {
      if (token.value && selector.matches(token.scopes)) {
        return token.value;
      }
    }
  };

  linkForName = function(buffer, linkName) {
    var link, regex;
    link = linkName;
    regex = new RegExp("^\\s*\\[" + (_.escapeRegExp(linkName)) + "\\]\\s*:\\s*(.+)$", 'g');
    buffer.backwardsScanInRange(regex, buffer.getRange(), function(arg) {
      var match, stop;
      match = arg.match, stop = arg.stop;
      link = match[1];
      return stop();
    });
    return link;
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
