Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _atom = require('atom');

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var KeyBindingResolverView = (function () {
  function KeyBindingResolverView() {
    _classCallCheck(this, KeyBindingResolverView);

    this.keystrokes = null;
    this.usedKeyBinding = null;
    this.unusedKeyBindings = [];
    this.unmatchedKeyBindings = [];
    this.partiallyMatchedBindings = [];
    _etch2['default'].initialize(this);
  }

  _createClass(KeyBindingResolverView, [{
    key: 'serialize',
    value: function serialize() {
      return this.panel ? { attached: this.panel.isVisible() } : { attached: false };
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.detach();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'toggle',
    value: function toggle() {
      if (this.panel && this.panel.isVisible()) {
        this.detach();
      } else {
        this.attach();
      }
    }
  }, {
    key: 'attach',
    value: function attach() {
      var _this = this;

      this.disposables = new _atom.CompositeDisposable();
      this.panel = atom.workspace.addBottomPanel({ item: this });
      this.disposables.add(new _atom.Disposable(function () {
        _this.panel.destroy();
        _this.panel = null;
      }));

      this.disposables.add(atom.keymaps.onDidMatchBinding(function (_ref) {
        var keystrokes = _ref.keystrokes;
        var binding = _ref.binding;
        var keyboardEventTarget = _ref.keyboardEventTarget;
        var eventType = _ref.eventType;

        if (eventType === 'keyup' && binding == null) {
          return;
        }

        var unusedKeyBindings = atom.keymaps.findKeyBindings({ keystrokes: keystrokes, target: keyboardEventTarget }).filter(function (b) {
          return b !== binding;
        });

        var unmatchedKeyBindings = atom.keymaps.findKeyBindings({ keystrokes: keystrokes }).filter(function (b) {
          return b !== binding && !unusedKeyBindings.includes(b);
        });

        _this.update({ usedKeyBinding: binding, unusedKeyBindings: unusedKeyBindings, unmatchedKeyBindings: unmatchedKeyBindings, keystrokes: keystrokes });
      }));

      this.disposables.add(atom.keymaps.onDidPartiallyMatchBindings(function (_ref2) {
        var keystrokes = _ref2.keystrokes;
        var partiallyMatchedBindings = _ref2.partiallyMatchedBindings;

        _this.update({ keystrokes: keystrokes, partiallyMatchedBindings: partiallyMatchedBindings });
      }));

      this.disposables.add(atom.keymaps.onDidFailToMatchBinding(function (_ref3) {
        var keystrokes = _ref3.keystrokes;
        var keyboardEventTarget = _ref3.keyboardEventTarget;
        var eventType = _ref3.eventType;

        if (eventType === 'keyup') {
          return;
        }

        var unusedKeyBindings = atom.keymaps.findKeyBindings({ keystrokes: keystrokes, target: keyboardEventTarget });
        var unmatchedKeyBindings = atom.keymaps.findKeyBindings({ keystrokes: keystrokes }).filter(function (b) {
          return !unusedKeyBindings.includes(b);
        });

        _this.update({ unusedKeyBindings: unusedKeyBindings, unmatchedKeyBindings: unmatchedKeyBindings, keystrokes: keystrokes });
      }));
    }
  }, {
    key: 'detach',
    value: function detach() {
      if (this.disposables) {
        this.disposables.dispose();
      }
    }
  }, {
    key: 'update',
    value: function update(props) {
      this.keystrokes = props.keystrokes;
      this.usedKeyBinding = props.usedKeyBinding;
      this.unusedKeyBindings = props.unusedKeyBindings || [];
      this.unmatchedKeyBindings = props.unmatchedKeyBindings || [];
      this.partiallyMatchedBindings = props.partiallyMatchedBindings || [];
      return _etch2['default'].update(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'key-binding-resolver' },
        _etch2['default'].dom(
          'div',
          { className: 'panel-heading padded' },
          _etch2['default'].dom(
            'span',
            null,
            'Key Binding Resolver: '
          ),
          this.renderKeystrokes()
        ),
        _etch2['default'].dom(
          'div',
          { className: 'panel-body padded' },
          this.renderKeyBindings()
        )
      );
    }
  }, {
    key: 'renderKeystrokes',
    value: function renderKeystrokes() {
      if (this.keystrokes) {
        if (this.partiallyMatchedBindings.length > 0) {
          return _etch2['default'].dom(
            'span',
            { className: 'keystroke' },
            this.keystrokes,
            ' (partial)'
          );
        } else {
          return _etch2['default'].dom(
            'span',
            { className: 'keystroke' },
            this.keystrokes
          );
        }
      } else {
        return _etch2['default'].dom(
          'span',
          null,
          'Press any key: '
        );
      }
    }
  }, {
    key: 'renderKeyBindings',
    value: function renderKeyBindings() {
      var _this2 = this;

      if (this.partiallyMatchedBindings.length > 0) {
        return _etch2['default'].dom(
          'table',
          { className: 'table-condensed' },
          _etch2['default'].dom(
            'tbody',
            null,
            this.partiallyMatchedBindings.map(function (binding) {
              return _etch2['default'].dom(
                'tr',
                { className: 'unused' },
                _etch2['default'].dom(
                  'td',
                  { className: 'command' },
                  binding.command
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'keystrokes' },
                  binding.keystrokes
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'selector' },
                  binding.selector
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'source', onclick: function () {
                      return _this2.openKeybindingFile(binding.source);
                    } },
                  binding.source
                )
              );
            })
          )
        );
      } else {
        var usedKeyBinding = '';
        if (this.usedKeyBinding) {
          usedKeyBinding = _etch2['default'].dom(
            'tr',
            { className: 'used' },
            _etch2['default'].dom(
              'td',
              { className: 'command' },
              this.usedKeyBinding.command
            ),
            _etch2['default'].dom(
              'td',
              { className: 'selector' },
              this.usedKeyBinding.selector
            ),
            _etch2['default'].dom(
              'td',
              { className: 'source', onclick: function () {
                  return _this2.openKeybindingFile(_this2.usedKeyBinding.source);
                } },
              this.usedKeyBinding.source
            )
          );
        }
        return _etch2['default'].dom(
          'table',
          { className: 'table-condensed' },
          _etch2['default'].dom(
            'tbody',
            null,
            usedKeyBinding,
            this.unusedKeyBindings.map(function (binding) {
              return _etch2['default'].dom(
                'tr',
                { className: 'unused' },
                _etch2['default'].dom(
                  'td',
                  { className: 'command' },
                  binding.command
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'selector' },
                  binding.selector
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'source', onclick: function () {
                      return _this2.openKeybindingFile(binding.source);
                    } },
                  binding.source
                )
              );
            }),
            this.unmatchedKeyBindings.map(function (binding) {
              return _etch2['default'].dom(
                'tr',
                { className: 'unmatched' },
                _etch2['default'].dom(
                  'td',
                  { className: 'command' },
                  binding.command
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'selector' },
                  binding.selector
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'source', onclick: function () {
                      return _this2.openKeybindingFile(binding.source);
                    } },
                  binding.source
                )
              );
            })
          )
        );
      }
    }
  }, {
    key: 'isInAsarArchive',
    value: function isInAsarArchive(pathToCheck) {
      var _atom$getLoadSettings = atom.getLoadSettings();

      var resourcePath = _atom$getLoadSettings.resourcePath;

      return pathToCheck.startsWith('' + resourcePath + _path2['default'].sep) && _path2['default'].extname(resourcePath) === '.asar';
    }
  }, {
    key: 'extractBundledKeymap',
    value: function extractBundledKeymap(bundledKeymapPath) {
      var metadata = require(_path2['default'].join(atom.getLoadSettings().resourcePath, 'package.json'));
      var bundledKeymaps = metadata ? metadata._atomKeymaps : {};
      var keymapName = _path2['default'].basename(bundledKeymapPath);
      var extractedKeymapPath = _path2['default'].join(require('temp').mkdirSync('atom-bundled-keymap-'), keymapName);
      _fsPlus2['default'].writeFileSync(extractedKeymapPath, JSON.stringify(bundledKeymaps[keymapName] || {}, null, 2));
      return extractedKeymapPath;
    }
  }, {
    key: 'extractBundledPackageKeymap',
    value: function extractBundledPackageKeymap(keymapRelativePath) {
      var packageName = keymapRelativePath.split(_path2['default'].sep)[1];
      var keymapName = _path2['default'].basename(keymapRelativePath);
      var metadata = atom.packages.packagesCache[packageName] || {};
      var keymaps = metadata.keymaps || {};
      var extractedKeymapPath = _path2['default'].join(require('temp').mkdirSync('atom-bundled-keymap-'), keymapName);
      _fsPlus2['default'].writeFileSync(extractedKeymapPath, JSON.stringify(keymaps[keymapRelativePath] || {}, null, 2));
      return extractedKeymapPath;
    }
  }, {
    key: 'openKeybindingFile',
    value: function openKeybindingFile(keymapPath) {
      if (this.isInAsarArchive(keymapPath)) {
        keymapPath = this.extractBundledKeymap(keymapPath);
      } else if (keymapPath.startsWith('core:node_modules')) {
        keymapPath = this.extractBundledPackageKeymap(keymapPath.replace('core:', ''));
      } else if (keymapPath.startsWith('core:')) {
        keymapPath = this.extractBundledKeymap(keymapPath.replace('core:', ''));
      }

      atom.workspace.open(keymapPath);
    }
  }]);

  return KeyBindingResolverView;
})();

exports['default'] = KeyBindingResolverView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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