(function() {
  var CompositeDisposable, ImageEditor, _, imageExtensions, openURI, path;

  path = require('path');

  _ = require('underscore-plus');

  ImageEditor = require('./image-editor');

  CompositeDisposable = require('atom').CompositeDisposable;

  module.exports = {
    activate: function() {
      this.statusViewAttached = null;
      this.disposables = new CompositeDisposable;
      this.disposables.add(atom.workspace.addOpener(openURI));
      return this.disposables.add(atom.workspace.onDidChangeActivePaneItem((function(_this) {
        return function() {
          return _this.attachImageEditorStatusView();
        };
      })(this)));
    },
    deactivate: function() {
      var ref;
      if ((ref = this.statusViewAttached) != null) {
        ref.destroy();
      }
      return this.disposables.dispose();
    },
    consumeStatusBar: function(statusBar) {
      this.statusBar = statusBar;
      return this.attachImageEditorStatusView();
    },
    attachImageEditorStatusView: function() {
      var ImageEditorStatusView;
      if (this.statusViewAttached) {
        return;
      }
      if (this.statusBar == null) {
        return;
      }
      if (!(atom.workspace.getActivePaneItem() instanceof ImageEditor)) {
        return;
      }
      ImageEditorStatusView = require('./image-editor-status-view');
      this.statusViewAttached = new ImageEditorStatusView(this.statusBar);
      return this.statusViewAttached.attach();
    },
    deserialize: function(state) {
      return ImageEditor.deserialize(state);
    }
  };

  imageExtensions = ['.bmp', '.gif', '.ico', '.jpeg', '.jpg', '.png', '.webp'];

  openURI = function(uriToOpen) {
    var uriExtension;
    uriExtension = path.extname(uriToOpen).toLowerCase();
    if (_.include(imageExtensions, uriExtension)) {
      return new ImageEditor(uriToOpen);
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
