'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Operation = exports.RendererProcess = exports.Worker = exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class, _class2, _temp, _desc2, _value2, _class3, _class4, _temp2, _desc3, _value3, _class5, _class6, _temp3;

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _querystring = require('querystring');

var _querystring2 = _interopRequireDefault(_querystring);

var _electron = require('electron');

var _eventKit = require('event-kit');

var _coreDecorators = require('core-decorators');

var _helpers = require('./helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

const BrowserWindow = _electron.remote.BrowserWindow;
let WorkerManager = (_class = (_temp = _class2 = class WorkerManager {

  static getInstance() {
    if (!this.instance) {
      this.instance = new WorkerManager();
    }
    return this.instance;
  }

  static reset(force) {
    if (this.instance) {
      this.instance.destroy(force);
    }
    this.instance = null;
  }

  constructor() {
    this.workers = new Set();
    this.activeWorker = null;
    this.createNewWorker();
  }

  isReady() {
    return this.activeWorker.isReady();
  }

  request(data) {
    if (this.destroyed) {
      throw new Error('Worker is destroyed');
    }
    let operation;
    const requestPromise = new Promise((resolve, reject) => {
      operation = new Operation(data, resolve, reject);
      return this.activeWorker.executeOperation(operation);
    });
    operation.setPromise(requestPromise);
    return {
      cancel: () => this.activeWorker.cancelOperation(operation),
      promise: requestPromise
    };
  }

  createNewWorker() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : { operationCountLimit: 10 };

    let operationCountLimit = _ref.operationCountLimit;

    if (this.destroyed) {
      return;
    }
    this.activeWorker = new Worker({
      operationCountLimit,
      onDestroyed: this.onDestroyed,
      onCrashed: this.onCrashed,
      onSick: this.onSick
    });
    this.workers.add(this.activeWorker);
  }

  onDestroyed(destroyedWorker) {
    this.workers.delete(destroyedWorker);
  }

  onCrashed(crashedWorker) {
    if (crashedWorker === this.getActiveWorker()) {
      this.createNewWorker({ operationCountLimit: crashedWorker.getOperationCountLimit() });
    }
    crashedWorker.getRemainingOperations().forEach(operation => this.activeWorker.executeOperation(operation));
  }

  onSick(sickWorker) {
    if (!atom.inSpecMode()) {
      // eslint-disable-next-line no-console
      console.warn(`Sick worker detected.
        operationCountLimit: ${sickWorker.getOperationCountLimit()},
        completed operation count: ${sickWorker.getCompletedOperationCount()}`);
    }
    const operationCountLimit = this.calculateNewOperationCountLimit(sickWorker);
    return this.createNewWorker({ operationCountLimit });
  }

  calculateNewOperationCountLimit(lastWorker) {
    let operationCountLimit = 10;
    if (lastWorker.getOperationCountLimit() >= lastWorker.getCompletedOperationCount()) {
      operationCountLimit = Math.min(lastWorker.getOperationCountLimit() * 2, 100);
    }
    return operationCountLimit;
  }

  getActiveWorker() {
    return this.activeWorker;
  }

  getReadyPromise() {
    return this.activeWorker.getReadyPromise();
  }

  destroy(force) {
    this.destroyed = true;
    this.workers.forEach(worker => worker.destroy(force));
  }
}, _class2.instance = null, _temp), (_applyDecoratedDescriptor(_class.prototype, 'onDestroyed', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'onDestroyed'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'onCrashed', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'onCrashed'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'onSick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'onSick'), _class.prototype)), _class);
exports.default = WorkerManager;
let Worker = exports.Worker = (_class3 = (_temp2 = _class4 = class Worker {

  constructor(_ref2) {
    let operationCountLimit = _ref2.operationCountLimit,
        onSick = _ref2.onSick,
        onCrashed = _ref2.onCrashed,
        onDestroyed = _ref2.onDestroyed;

    this.operationCountLimit = operationCountLimit;
    this.onSick = onSick;
    this.onCrashed = onCrashed;
    this.onDestroyed = onDestroyed;

    this.operationsById = new Map();
    this.completedOperationCount = 0;
    this.sick = false;

    this.rendererProcess = new RendererProcess({
      loadUrl: this.getLoadUrl(operationCountLimit),
      onData: this.handleDataReceived,
      onCancelled: this.handleCancelled,
      onExecStarted: this.handleExecStarted,
      onSpawnError: this.handleSpawnError,
      onStdinError: this.handleStdinError,
      onSick: this.handleSick,
      onCrashed: this.handleCrashed,
      onDestroyed: this.destroy
    });
  }

  isReady() {
    return this.rendererProcess.isReady();
  }

  getLoadUrl(operationCountLimit) {
    const htmlPath = _path2.default.join((0, _helpers.getPackageRoot)(), 'lib', 'renderer.html');
    const rendererJsPath = _path2.default.join((0, _helpers.getPackageRoot)(), 'lib', 'worker.js');
    const qs = _querystring2.default.stringify({
      js: rendererJsPath,
      managerWebContentsId: this.getWebContentsId(),
      operationCountLimit,
      channelName: Worker.channelName
    });
    return `file://${htmlPath}?${qs}`;
  }

  getWebContentsId() {
    return _electron.remote.getCurrentWebContents().id;
  }

  executeOperation(operation) {
    this.operationsById.set(operation.id, operation);
    operation.onComplete(this.onOperationComplete);
    return this.rendererProcess.executeOperation(operation);
  }

  cancelOperation(operation) {
    return this.rendererProcess.cancelOperation(operation);
  }

  handleDataReceived(_ref3) {
    let id = _ref3.id,
        results = _ref3.results;

    const operation = this.operationsById.get(id);
    operation.complete(results, data => {
      const timing = data.timing;

      const totalInternalTime = timing.execTime + timing.spawnTime;
      const ipcTime = operation.getExecutionTime() - totalInternalTime;
      data.timing.ipcTime = ipcTime;
      return data;
    });
  }

  onOperationComplete(operation) {
    this.completedOperationCount++;
    this.operationsById.delete(operation.id);

    if (this.sick && this.operationsById.size === 0) {
      this.destroy();
    }
  }

  handleCancelled(_ref4) {
    let id = _ref4.id;

    const operation = this.operationsById.get(id);
    if (operation) {
      // handleDataReceived() can be received before handleCancelled()
      operation.wasCancelled();
    }
  }

  handleExecStarted(_ref5) {
    let id = _ref5.id;

    const operation = this.operationsById.get(id);
    operation.setInProgress();
  }

  handleSpawnError(_ref6) {
    let id = _ref6.id,
        err = _ref6.err;

    const operation = this.operationsById.get(id);
    operation.error(err);
  }

  handleStdinError(_ref7) {
    let id = _ref7.id,
        stdin = _ref7.stdin,
        err = _ref7.err;

    const operation = this.operationsById.get(id);
    operation.error(err);
  }

  handleSick() {
    this.sick = true;
    this.onSick(this);
  }

  handleCrashed() {
    this.onCrashed(this);
    this.destroy();
  }

  getOperationCountLimit() {
    return this.operationCountLimit;
  }

  getCompletedOperationCount() {
    return this.completedOperationCount;
  }

  getRemainingOperations() {
    return Array.from(this.operationsById.values());
  }

  getPid() {
    return this.rendererProcess.getPid();
  }

  getReadyPromise() {
    return this.rendererProcess.getReadyPromise();
  }

  destroy(force) {
    var _this = this;

    return _asyncToGenerator(function* () {
      _this.onDestroyed(_this);
      if (_this.operationsById.size > 0 && !force) {
        const remainingOperationPromises = _this.getRemainingOperations().map(function (operation) {
          return operation.getPromise().catch(function () {
            return null;
          });
        });
        yield Promise.all(remainingOperationPromises);
      }
      _this.rendererProcess.destroy();
    })();
  }
}, _class4.channelName = 'github:renderer-ipc', _temp2), (_applyDecoratedDescriptor(_class3.prototype, 'handleDataReceived', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class3.prototype, 'handleDataReceived'), _class3.prototype), _applyDecoratedDescriptor(_class3.prototype, 'onOperationComplete', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class3.prototype, 'onOperationComplete'), _class3.prototype), _applyDecoratedDescriptor(_class3.prototype, 'handleCancelled', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class3.prototype, 'handleCancelled'), _class3.prototype), _applyDecoratedDescriptor(_class3.prototype, 'handleExecStarted', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class3.prototype, 'handleExecStarted'), _class3.prototype), _applyDecoratedDescriptor(_class3.prototype, 'handleSpawnError', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class3.prototype, 'handleSpawnError'), _class3.prototype), _applyDecoratedDescriptor(_class3.prototype, 'handleStdinError', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class3.prototype, 'handleStdinError'), _class3.prototype), _applyDecoratedDescriptor(_class3.prototype, 'handleSick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class3.prototype, 'handleSick'), _class3.prototype), _applyDecoratedDescriptor(_class3.prototype, 'handleCrashed', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class3.prototype, 'handleCrashed'), _class3.prototype)), _class3);

/*
Sends operations to renderer processes
*/

let RendererProcess = exports.RendererProcess = (_class5 = class RendererProcess {
  constructor(_ref8) {
    let loadUrl = _ref8.loadUrl,
        onDestroyed = _ref8.onDestroyed,
        onCrashed = _ref8.onCrashed,
        onSick = _ref8.onSick,
        onData = _ref8.onData,
        onCancelled = _ref8.onCancelled,
        onSpawnError = _ref8.onSpawnError,
        onStdinError = _ref8.onStdinError,
        onExecStarted = _ref8.onExecStarted;

    this.onDestroyed = onDestroyed;
    this.onCrashed = onCrashed;
    this.onSick = onSick;
    this.onData = onData;
    this.onCancelled = onCancelled;
    this.onSpawnError = onSpawnError;
    this.onStdinError = onStdinError;
    this.onExecStarted = onExecStarted;

    this.win = new BrowserWindow({ show: !!process.env.ATOM_GITHUB_SHOW_RENDERER_WINDOW });
    this.webContents = this.win.webContents;
    // this.webContents.openDevTools();

    this.emitter = new _eventKit.Emitter();
    this.subscriptions = new _eventKit.CompositeDisposable();
    this.registerListeners();

    this.win.loadURL(loadUrl);
    this.win.webContents.on('crashed', this.handleDestroy);
    this.win.webContents.on('destroyed', this.handleDestroy);
    this.subscriptions.add(new _eventKit.Disposable(() => {
      if (!this.win.isDestroyed()) {
        this.win.webContents.removeListener('crashed', this.handleDestroy);
        this.win.webContents.removeListener('destroyed', this.handleDestroy);
        this.win.destroy();
      }
    }), this.emitter);

    this.ready = false;
    this.readyPromise = new Promise(resolve => {
      this.resolveReady = resolve;
    });
  }

  isReady() {
    return this.ready;
  }

  handleDestroy() {
    this.destroy();
    this.onCrashed(...arguments);
  }

  registerListeners() {
    const handleMessages = (event, _ref9) => {
      let sourceWebContentsId = _ref9.sourceWebContentsId,
          type = _ref9.type,
          data = _ref9.data;

      if (sourceWebContentsId === this.win.webContents.id) {
        this.emitter.emit(type, data);
      }
    };

    _electron.ipcRenderer.on(Worker.channelName, handleMessages);
    this.emitter.on('renderer-ready', (_ref10) => {
      let pid = _ref10.pid;

      this.pid = pid;
      this.ready = true;
      this.resolveReady();
    });
    this.emitter.on('git-data', this.onData);
    this.emitter.on('git-cancelled', this.onCancelled);
    this.emitter.on('git-spawn-error', this.onSpawnError);
    this.emitter.on('git-stdin-error', this.onStdinError);
    this.emitter.on('slow-spawns', this.onSick);

    // not currently used to avoid clogging up ipc channel
    // keeping it around as it's potentially useful for avoiding duplicate write operations upon renderer crashing
    this.emitter.on('exec-started', this.onExecStarted);

    this.subscriptions.add(new _eventKit.Disposable(() => _electron.ipcRenderer.removeListener(Worker.channelName, handleMessages)));
  }

  executeOperation(operation) {
    return operation.execute(payload => {
      if (this.destroyed) {
        return null;
      }
      return this.webContents.send(Worker.channelName, {
        type: 'git-exec',
        data: payload
      });
    });
  }

  cancelOperation(operation) {
    return operation.cancel(payload => {
      if (this.destroyed) {
        return null;
      }
      return this.webContents.send(Worker.channelName, {
        type: 'git-cancel',
        data: payload
      });
    });
  }

  getPid() {
    return this.pid;
  }

  getReadyPromise() {
    return this.readyPromise;
  }

  destroy() {
    this.destroyed = true;
    this.subscriptions.dispose();
  }
}, (_applyDecoratedDescriptor(_class5.prototype, 'handleDestroy', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class5.prototype, 'handleDestroy'), _class5.prototype)), _class5);
let Operation = exports.Operation = (_temp3 = _class6 = class Operation {

  constructor(data, resolve, reject) {
    this.id = Operation.id++;
    this.data = data;
    this.resolve = resolve;
    this.reject = reject;
    this.promise = null;
    this.cancellationResolve = () => {};
    this.startTime = null;
    this.endTime = null;
    this.status = Operation.status.PENDING;
    this.results = null;
    this.emitter = new _eventKit.Emitter();
  }

  onComplete(cb) {
    return this.emitter.on('complete', cb);
  }

  setPromise(promise) {
    this.promise = promise;
  }

  getPromise() {
    return this.promise;
  }

  setInProgress() {
    // after exec has been called but before results a received
    this.status = Operation.status.INPROGRESS;
  }

  getExecutionTime() {
    if (!this.startTime || !this.endTime) {
      return NaN;
    } else {
      return this.endTime - this.startTime;
    }
  }

  complete(results) {
    let mutate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : data => data;

    this.endTime = performance.now();
    this.results = results;
    this.resolve(mutate(results));
    this.cancellationResolve();
    this.status = Operation.status.COMPLETE;
    this.emitter.emit('complete', this);
    this.emitter.dispose();
  }

  wasCancelled() {
    this.status = Operation.status.CANCELLED;
    this.cancellationResolve();
  }

  error(results) {
    this.endTime = performance.now();
    const err = new Error(results.message, results.fileName, results.lineNumber);
    err.stack = results.stack;
    this.reject(err);
  }

  execute(execFn) {
    this.startTime = performance.now();
    return execFn(_extends({}, this.data, { id: this.id }));
  }

  cancel(execFn) {
    return new Promise(resolve => {
      this.status = Operation.status.CANCELLING;
      this.cancellationResolve = resolve;
      execFn({ id: this.id });
    });
  }
}, _class6.status = {
  PENDING: Symbol('pending'),
  INPROGRESS: Symbol('in-progress'),
  COMPLETE: Symbol('complete'),
  CANCELLING: Symbol('cancelling'),
  CANCELLED: Symbol('canceled')
}, _class6.id = 0, _temp3);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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