'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class, _class2, _temp, _class3, _temp2, _class4, _temp3;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _coreDecorators = require('core-decorators');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

function getClasses(staticClasses, active) {
  return (0, _classnames2.default)(...staticClasses, {
    inactive: !active,
    active
  });
}

let TabsNavigationItem = (_class = (_temp = _class2 = class TabsNavigationItem extends _react2.default.Component {

  render() {
    const classes = getClasses(['github-Tabs-NavigationItem'], this.props.active);
    return _react2.default.createElement(
      'div',
      { className: classes, onClick: this.handleClick },
      this.props.title
    );
  }

  handleClick() {
    this.props.onClick(this.props.tabIndex);
  }
}, _class2.propTypes = {
  title: _propTypes2.default.node,
  tabIndex: _propTypes2.default.number.isRequired,
  active: _propTypes2.default.bool,
  onClick: _propTypes2.default.func
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'handleClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleClick'), _class.prototype)), _class);
let Tabs = (_temp2 = _class3 = class Tabs extends _react2.default.Component {

  render() {
    const children = _react2.default.Children.toArray(this.props.children).filter(v => !!v);
    return _react2.default.createElement(
      'div',
      { className: (0, _classnames2.default)('github-Tabs', this.props.className), 'data-tabs-count': children.length },
      _react2.default.createElement(
        'nav',
        { className: 'github-Tabs-NavigationContainer' },
        children.map((child, i) => child && _react2.default.createElement(TabsNavigationItem, {
          key: i,
          title: child.props.title,
          active: this.props.activeIndex === i,
          tabIndex: i,
          onClick: this.props.onChange
        }))
      ),
      _react2.default.createElement(
        'section',
        { className: 'github-Tabs-PanelContainer' },
        children.map((child, i) => child && _react2.default.cloneElement(child, { active: i === this.props.activeIndex }))
      )
    );
  }
}, _class3.propTypes = {
  className: _propTypes2.default.string,
  activeIndex: _propTypes2.default.number.isRequired,
  children: _propTypes2.default.node,
  onChange: _propTypes2.default.func
}, _class3.defaultProps = {
  className: '',
  onChange: () => {}
}, _temp2);
exports.default = Tabs;


Tabs.Panel = (_temp3 = _class4 = class TabPanel extends _react2.default.Component {

  render() {
    // eslint-disable-next-line no-unused-vars
    var _props = this.props;

    const active = _props.active,
          children = _props.children,
          className = _props.className,
          title = _props.title,
          others = _objectWithoutProperties(_props, ['active', 'children', 'className', 'title']);

    return _react2.default.createElement(
      'div',
      _extends({ className: getClasses(['github-Tabs-Panel', className], this.props.active) }, others),
      this.props.children
    );
  }
}, _class4.propTypes = {
  className: _propTypes2.default.string,
  active: _propTypes2.default.bool,
  children: _propTypes2.default.node,
  title: _propTypes2.default.node
}, _class4.defaultProps = {
  className: '',
  active: false
}, _temp3);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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