'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class, _class2, _temp; /** @jsx etch.dom */
/* eslint react/no-unknown-property: "off" */

var _eventKit = require('event-kit');

var _electron = require('electron');

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _coreDecorators = require('core-decorators');

var _filePatchListItemView = require('./file-patch-list-item-view');

var _filePatchListItemView2 = _interopRequireDefault(_filePatchListItemView);

var _mergeConflictListItemView = require('./merge-conflict-list-item-view');

var _mergeConflictListItemView2 = _interopRequireDefault(_mergeConflictListItemView);

var _compositeListSelection = require('./composite-list-selection');

var _compositeListSelection2 = _interopRequireDefault(_compositeListSelection);

var _resolutionProgress = require('../models/conflicts/resolution-progress');

var _resolutionProgress2 = _interopRequireDefault(_resolutionProgress);

var _modelObserver = require('../models/model-observer');

var _modelObserver2 = _interopRequireDefault(_modelObserver);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

const Menu = _electron.remote.Menu,
      MenuItem = _electron.remote.MenuItem;


const debounce = (fn, wait) => {
  let timeout;
  return function () {
    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return new Promise(resolve => {
      clearTimeout(timeout);
      timeout = setTimeout(() => {
        resolve(fn(...args));
      }, wait);
    });
  };
};

const MAXIMUM_LISTED_ENTRIES = 1000;

let StagingView = (_class = (_temp = _class2 = class StagingView {

  constructor(props) {
    this.props = props;
    this.truncatedLists = this.calculateTruncatedLists({
      unstagedChanges: this.props.unstagedChanges,
      stagedChanges: this.props.stagedChanges,
      mergeConflicts: this.props.mergeConflicts || []
    });
    atom.config.observe('github.keyboardNavigationDelay', value => {
      if (value === 0) {
        this.debouncedDidChangeSelectedItem = this.didChangeSelectedItems;
      } else {
        this.debouncedDidChangeSelectedItem = debounce(this.didChangeSelectedItems, value);
      }
    });
    this.mouseSelectionInProgress = false;
    this.listElementsByItem = new WeakMap();

    this.selection = new _compositeListSelection2.default({
      listsByKey: {
        unstaged: this.props.unstagedChanges,
        conflicts: this.props.mergeConflicts || [],
        staged: this.props.stagedChanges
      },
      idForItem: item => item.filePath
    });

    this.resolutionProgressObserver = new _modelObserver2.default({
      didUpdate: () => {
        if (this.element) {
          _etch2.default.update(this);
        }
      }
    });
    this.resolutionProgressObserver.setActiveModel(this.props.resolutionProgress);

    _etch2.default.initialize(this);

    this.subscriptions = new _eventKit.CompositeDisposable();
    this.subscriptions.add(this.props.commandRegistry.add(this.element, {
      'core:move-up': () => this.selectPrevious(),
      'core:move-down': () => this.selectNext(),
      'core:move-left': () => this.diveIntoSelection(),
      'core:select-up': () => this.selectPrevious(true),
      'core:select-down': () => this.selectNext(true),
      'core:select-all': () => this.selectAll(),
      'core:move-to-top': () => this.selectFirst(),
      'core:move-to-bottom': () => this.selectLast(),
      'core:select-to-top': () => this.selectFirst(true),
      'core:select-to-bottom': () => this.selectLast(true),
      'core:confirm': () => this.confirmSelectedItems(),
      'github:activate-next-list': () => this.activateNextList(),
      'github:activate-previous-list': () => this.activatePreviousList(),
      'github:open-file': () => this.openFile(),
      'github:resolve-file-as-ours': () => this.resolveCurrentAsOurs(),
      'github:resolve-file-as-theirs': () => this.resolveCurrentAsTheirs(),
      'core:undo': () => this.props.hasUndoHistory && this.undoLastDiscard()
    }));
    this.subscriptions.add(this.props.commandRegistry.add('atom-workspace', {
      'github:stage-all-changes': () => this.stageAll(),
      'github:unstage-all-changes': () => this.unstageAll(),
      'github:discard-all-changes': () => this.discardAll(),
      'github:undo-last-discard-in-git-tab': () => this.props.hasUndoHistory && this.undoLastDiscard()
    }));
    this.subscriptions.add(this.props.commandRegistry.add(this.refs.unstagedChanges, {
      'github:discard-changes-in-selected-files': () => this.discardChanges()
    }));
    window.addEventListener('mouseup', this.mouseup);
    this.subscriptions.add(new _eventKit.Disposable(() => window.removeEventListener('mouseup', this.mouseup)));
  }

  getSelectedConflictPaths() {
    if (this.selection.getActiveListKey() !== 'conflicts') {
      return [];
    }
    return Array.from(this.selection.getSelectedItems(), item => item.filePath);
  }

  update(props) {
    var _this = this;

    return _asyncToGenerator(function* () {
      const oldProps = _this.props;
      _this.props = _extends({}, _this.props, props);
      _this.truncatedLists = _this.calculateTruncatedLists({
        unstagedChanges: _this.props.unstagedChanges,
        stagedChanges: _this.props.stagedChanges,
        mergeConflicts: _this.props.mergeConflicts || []
      });
      _this.selection.updateLists({
        unstaged: _this.props.unstagedChanges,
        conflicts: _this.props.mergeConflicts || [],
        staged: _this.props.stagedChanges
      });

      if (_this.props.resolutionProgress !== oldProps.resolutionProgress) {
        yield _this.resolutionProgressObserver.setActiveModel(_this.props.resolutionProgress);
      }

      return _etch2.default.update(_this);
    })();
  }

  calculateTruncatedLists(lists) {
    return Object.keys(lists).reduce((acc, key) => {
      const list = lists[key];
      if (list.length <= MAXIMUM_LISTED_ENTRIES) {
        acc[key] = list;
      } else {
        acc[key] = list.slice(0, MAXIMUM_LISTED_ENTRIES);
      }
      return acc;
    }, {});
  }

  openFile() {
    const filePaths = Array.from(this.selection.getSelectedItems()).map(item => item.filePath);
    return this.props.openFiles(filePaths);
  }

  discardChanges() {
    const filePaths = Array.from(this.selection.getSelectedItems()).map(item => item.filePath);
    return this.props.discardWorkDirChangesForPaths(filePaths);
  }

  activateNextList() {
    if (!this.selection.activateNextSelection()) {
      return false;
    }

    this.selection.coalesce();
    this.didChangeSelectedItems();
    _etch2.default.update(this);
    return true;
  }

  activatePreviousList() {
    if (!this.selection.activatePreviousSelection()) {
      return false;
    }

    this.selection.coalesce();
    this.didChangeSelectedItems();
    _etch2.default.update(this);
    return true;
  }

  activateLastList() {
    if (!this.selection.activateLastSelection()) {
      return false;
    }

    this.selection.coalesce();
    this.didChangeSelectedItems();
    _etch2.default.update(this);
    return true;
  }

  stageAll() {
    if (this.props.unstagedChanges.length === 0) {
      return null;
    }
    const filePaths = this.props.unstagedChanges.map(filePatch => filePatch.filePath);
    return this.props.attemptFileStageOperation(filePaths, 'unstaged');
  }

  unstageAll() {
    if (this.props.stagedChanges.length === 0) {
      return null;
    }
    const filePaths = this.props.stagedChanges.map(filePatch => filePatch.filePath);
    return this.props.attemptFileStageOperation(filePaths, 'staged');
  }

  stageAllMergeConflicts() {
    if (this.props.mergeConflicts.length === 0) {
      return null;
    }
    const filePaths = this.props.mergeConflicts.map(conflict => conflict.filePath);
    return this.props.attemptFileStageOperation(filePaths, 'unstaged');
  }

  discardAll() {
    if (this.props.unstagedChanges.length === 0) {
      return null;
    }
    const filePaths = this.props.unstagedChanges.map(filePatch => filePatch.filePath);
    return this.props.discardWorkDirChangesForPaths(filePaths);
  }

  confirmSelectedItems() {
    const itemPaths = Array.from(this.selection.getSelectedItems()).map(item => item.filePath);
    return this.props.attemptFileStageOperation(itemPaths, this.selection.getActiveListKey());
  }

  getNextListUpdatePromise() {
    return this.selection.getNextUpdatePromise();
  }

  selectPrevious() {
    let preserveTail = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

    this.selection.selectPreviousItem(preserveTail);
    this.selection.coalesce();
    if (!preserveTail) {
      this.debouncedDidChangeSelectedItem();
    }
    return _etch2.default.update(this);
  }

  selectNext() {
    let preserveTail = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

    this.selection.selectNextItem(preserveTail);
    this.selection.coalesce();
    if (!preserveTail) {
      this.debouncedDidChangeSelectedItem();
    }
    return _etch2.default.update(this);
  }

  selectAll() {
    this.selection.selectAllItems();
    this.selection.coalesce();
    return _etch2.default.update(this);
  }

  selectFirst() {
    let preserveTail = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

    this.selection.selectFirstItem(preserveTail);
    this.selection.coalesce();
    if (!preserveTail) {
      this.debouncedDidChangeSelectedItem();
    }
    return _etch2.default.update(this);
  }

  selectLast() {
    let preserveTail = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

    this.selection.selectLastItem(preserveTail);
    this.selection.coalesce();
    if (!preserveTail) {
      this.debouncedDidChangeSelectedItem();
    }
    return _etch2.default.update(this);
  }

  diveIntoSelection() {
    const selectedItems = this.selection.getSelectedItems();
    if (selectedItems.size !== 1) {
      return;
    }

    const selectedItem = selectedItems.values().next().value;
    const stagingStatus = this.selection.getActiveListKey();

    if (stagingStatus === 'conflicts') {
      if (this.props.didDiveIntoMergeConflictPath) {
        this.props.didDiveIntoMergeConflictPath(selectedItem.filePath);
      }
    } else {
      if (this.props.didDiveIntoFilePath) {
        const amending = this.props.isAmending && this.selection.getActiveListKey() === 'staged';
        this.props.didDiveIntoFilePath(selectedItem.filePath, this.selection.getActiveListKey(), { amending });
      }
    }
  }

  showBulkResolveMenu(event) {
    const conflictPaths = this.props.mergeConflicts.map(c => c.filePath);

    event.preventDefault();

    const menu = new Menu();

    menu.append(new MenuItem({
      label: 'Resolve All as Ours',
      click: () => this.props.resolveAsOurs(conflictPaths)
    }));

    menu.append(new MenuItem({
      label: 'Resolve All as Theirs',
      click: () => this.props.resolveAsTheirs(conflictPaths)
    }));

    menu.popup(_electron.remote.getCurrentWindow());
  }

  resolveCurrentAsOurs() {
    this.props.resolveAsOurs(this.getSelectedConflictPaths());
  }

  resolveCurrentAsTheirs() {
    this.props.resolveAsTheirs(this.getSelectedConflictPaths());
  }

  writeAfterUpdate() {
    const headItem = this.selection.getHeadItem();
    if (headItem) {
      this.listElementsByItem.get(headItem).scrollIntoViewIfNeeded();
    }
  }

  // Directly modify the selection to include only the item identified by the file path and stagingStatus tuple.
  // Re-render the component, but don't notify didSelectSingleItem() or other callback functions. This is useful to
  // avoid circular callback loops for actions originating in FilePatchView or TextEditors with merge conflicts.
  quietlySelectItem(filePath, stagingStatus) {
    const item = this.selection.findItem((each, key) => each.filePath === filePath && key === stagingStatus);
    if (!item) {
      return Promise.reject(new Error(`Unable to find item at path ${filePath} with staging status ${stagingStatus}`));
    }

    this.selection.selectItem(item);
    return _etch2.default.update(this);
  }

  didChangeSelectedItems() {
    const selectedItems = Array.from(this.selection.getSelectedItems());
    if (selectedItems.length === 1) {
      this.didSelectSingleItem(selectedItems[0]);
    }
  }

  didSelectSingleItem(selectedItem) {
    if (this.selection.getActiveListKey() === 'conflicts') {
      if (this.props.didSelectMergeConflictFile) {
        this.props.didSelectMergeConflictFile(selectedItem.filePath);
      }
    } else {
      if (this.props.didSelectFilePath) {
        const amending = this.props.isAmending && this.selection.getActiveListKey() === 'staged';
        this.props.didSelectFilePath(selectedItem.filePath, this.selection.getActiveListKey(), { amending, activate: true });
      }
    }
  }

  dblclickOnItem(event, item) {
    return this.props.attemptFileStageOperation([item.filePath], this.selection.listKeyForItem(item));
  }

  contextMenuOnItem(event, item) {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      if (!_this2.selection.getSelectedItems().has(item)) {
        event.stopPropagation();
        _this2.selection.selectItem(item, event.shiftKey);
        yield _etch2.default.update(_this2);
        const newEvent = new MouseEvent(event.type, event);
        requestAnimationFrame(function () {
          event.target.parentNode.dispatchEvent(newEvent);
        });
      }
    })();
  }

  mousedownOnItem(event, item) {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      const windows = process.platform === 'win32';
      if (event.ctrlKey && !windows) {
        return;
      } // simply open context menu
      if (event.button === 0) {
        _this3.mouseSelectionInProgress = true;
        _this3.selectionChanged = true;
        if (event.metaKey || event.ctrlKey && windows) {
          _this3.selection.addOrSubtractSelection(item);
        } else {
          _this3.selection.selectItem(item, event.shiftKey);
        }
        yield _etch2.default.update(_this3);
      }
    })();
  }

  mousemoveOnItem(event, item) {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      if (_this4.mouseSelectionInProgress) {
        _this4.selectionChanged = true;
        _this4.selection.selectItem(item, true);
        yield _etch2.default.update(_this4);
      }
    })();
  }

  mouseup() {
    this.selection.coalesce();
    if (this.selectionChanged) {
      this.didChangeSelectedItems();
    }
    this.mouseSelectionInProgress = false;
    this.selectionChanged = false;
  }

  render() {
    const selectedItems = this.selection.getSelectedItems();

    return _etch2.default.dom(
      'div',
      {
        className: `github-StagingView ${this.selection.getActiveListKey()}-changes-focused`,
        style: { width: 200 },
        tabIndex: '-1' },
      _etch2.default.dom(
        'div',
        { className: `github-StagingView-group github-UnstagedChanges ${this.getFocusClass('unstaged')}` },
        _etch2.default.dom(
          'header',
          { className: 'github-StagingView-header' },
          _etch2.default.dom('span', { className: 'icon icon-list-unordered' }),
          _etch2.default.dom(
            'span',
            { className: 'github-StagingView-title' },
            'Unstaged Changes'
          ),
          this.props.unstagedChanges.length ? this.renderStageAllButton() : null
        ),
        this.props.hasUndoHistory ? this.renderUndoButton() : null,
        _etch2.default.dom(
          'div',
          { ref: 'unstagedChanges', className: 'github-StagingView-list github-FilePatchListView' },
          this.truncatedLists.unstagedChanges.map(filePatch => _etch2.default.dom(_filePatchListItemView2.default, {
            key: filePatch.filePath,
            registerItemElement: this.registerItemElement,
            filePatch: filePatch,
            ondblclick: event => this.dblclickOnItem(event, filePatch),
            oncontextmenu: event => this.contextMenuOnItem(event, filePatch),
            onmousedown: event => this.mousedownOnItem(event, filePatch),
            onmousemove: event => this.mousemoveOnItem(event, filePatch),
            selected: selectedItems.has(filePatch)
          }))
        ),
        this.renderTruncatedMessage(this.props.unstagedChanges)
      ),
      this.renderMergeConflicts(),
      _etch2.default.dom(
        'div',
        { className: `github-StagingView-group github-StagedChanges ${this.getFocusClass('staged')}` },
        _etch2.default.dom(
          'header',
          { className: 'github-StagingView-header' },
          _etch2.default.dom('span', { className: 'icon icon-tasklist' }),
          _etch2.default.dom(
            'span',
            { className: 'github-StagingView-title' },
            'Staged Changes',
            this.props.isAmending ? ` (amending ${(0, _helpers.shortenSha)(this.props.lastCommit.getSha())})` : ''
          ),
          this.props.stagedChanges.length ? this.renderUnstageAllButton() : null
        ),
        _etch2.default.dom(
          'div',
          { ref: 'stagedChanges', className: 'github-StagingView-list github-FilePatchListView' },
          this.truncatedLists.stagedChanges.map(filePatch => _etch2.default.dom(_filePatchListItemView2.default, {
            key: filePatch.filePath,
            filePatch: filePatch,
            registerItemElement: this.registerItemElement,
            ondblclick: event => this.dblclickOnItem(event, filePatch),
            oncontextmenu: event => this.contextMenuOnItem(event, filePatch),
            onmousedown: event => this.mousedownOnItem(event, filePatch),
            onmousemove: event => this.mousemoveOnItem(event, filePatch),
            selected: selectedItems.has(filePatch)
          }))
        ),
        this.renderTruncatedMessage(this.props.stagedChanges)
      )
    );
  }

  renderMergeConflicts() {
    const mergeConflicts = this.truncatedLists.mergeConflicts;

    if (mergeConflicts && mergeConflicts.length > 0) {
      const selectedItems = this.selection.getSelectedItems();
      const resolutionProgress = this.resolutionProgressObserver.getActiveModel() || new _resolutionProgress2.default();
      const anyUnresolved = mergeConflicts.map(conflict => _path2.default.join(this.props.workingDirectoryPath, conflict.filePath)).some(conflictPath => resolutionProgress.getRemaining(conflictPath) !== 0);

      const bulkResolveDropdown = anyUnresolved ? _etch2.default.dom('span', {
        className: 'inline-block icon icon-ellipses',
        onclick: this.showBulkResolveMenu
      }) : null;

      return _etch2.default.dom(
        'div',
        { className: `github-StagingView-group github-MergeConflictPaths ${this.getFocusClass('conflicts')}` },
        _etch2.default.dom(
          'header',
          { className: 'github-StagingView-header' },
          _etch2.default.dom('span', { className: 'github-FilePatchListView-icon icon icon-alert status-modified' }),
          _etch2.default.dom(
            'span',
            { className: 'github-StagingView-title' },
            'Merge Conflicts'
          ),
          bulkResolveDropdown,
          _etch2.default.dom(
            'button',
            {
              className: 'github-StagingView-headerButton icon icon-move-down',
              disabled: anyUnresolved,
              onclick: this.stageAllMergeConflicts },
            'Stage All'
          )
        ),
        _etch2.default.dom(
          'div',
          { ref: 'mergeConflicts', className: 'github-StagingView-list github-FilePatchListView' },
          mergeConflicts.map(mergeConflict => {
            const fullPath = _path2.default.join(this.props.workingDirectoryPath, mergeConflict.filePath);

            return _etch2.default.dom(_mergeConflictListItemView2.default, {
              key: fullPath,
              mergeConflict: mergeConflict,
              remainingConflicts: resolutionProgress.getRemaining(fullPath),
              registerItemElement: this.registerItemElement,
              ondblclick: event => this.dblclickOnItem(event, mergeConflict),
              oncontextmenu: event => this.contextMenuOnItem(event, mergeConflict),
              onmousedown: event => this.mousedownOnItem(event, mergeConflict),
              onmousemove: event => this.mousemoveOnItem(event, mergeConflict),
              selected: selectedItems.has(mergeConflict)
            });
          })
        ),
        this.renderTruncatedMessage(mergeConflicts)
      );
    } else {
      return _etch2.default.dom('noscript', null);
    }
  }

  renderStageAllButton() {
    return _etch2.default.dom(
      'button',
      {
        className: 'github-StagingView-headerButton icon icon-move-down',
        onclick: this.stageAll },
      'Stage All'
    );
  }

  renderUnstageAllButton() {
    return _etch2.default.dom(
      'button',
      { className: 'github-StagingView-headerButton icon icon-move-up',
        onclick: this.unstageAll },
      'Unstage All'
    );
  }

  renderUndoButton() {
    return _etch2.default.dom(
      'button',
      { className: 'github-StagingView-headerButton github-StagingView-headerButton--fullWidth icon icon-history',
        onclick: this.undoLastDiscard },
      'Undo Discard'
    );
  }

  renderTruncatedMessage(list) {
    if (list.length > MAXIMUM_LISTED_ENTRIES) {
      return _etch2.default.dom(
        'div',
        { className: 'github-StagingView-group-truncatedMsg' },
        'List truncated to the first ',
        MAXIMUM_LISTED_ENTRIES,
        ' items'
      );
    } else {
      return null;
    }
  }

  undoLastDiscard() {
    return this.props.undoLastDiscard();
  }

  getFocusClass(listKey) {
    return this.selection.getActiveListKey() === listKey ? 'is-focused' : '';
  }

  registerItemElement(item, element) {
    this.listElementsByItem.set(item, element);
  }

  destroy() {
    this.resolutionProgressObserver.destroy();
    this.subscriptions.dispose();
    _etch2.default.destroy(this);
  }

  rememberFocus(event) {
    return this.element.contains(event.target) ? StagingView.focus.STAGING : null;
  }

  setFocus(focus) {
    if (focus === StagingView.focus.STAGING) {
      this.element.focus();
      return true;
    }

    return false;
  }
}, _class2.focus = {
  STAGING: Symbol('staging')
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'activateNextList', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'activateNextList'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'activatePreviousList', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'activatePreviousList'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'stageAll', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'stageAll'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'unstageAll', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'unstageAll'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'stageAllMergeConflicts', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'stageAllMergeConflicts'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'discardAll', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'discardAll'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'diveIntoSelection', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'diveIntoSelection'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'showBulkResolveMenu', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'showBulkResolveMenu'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'resolveCurrentAsOurs', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'resolveCurrentAsOurs'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'resolveCurrentAsTheirs', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'resolveCurrentAsTheirs'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'didChangeSelectedItems', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'didChangeSelectedItems'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'dblclickOnItem', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'dblclickOnItem'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'contextMenuOnItem', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'contextMenuOnItem'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'mousedownOnItem', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'mousedownOnItem'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'mousemoveOnItem', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'mousemoveOnItem'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'mouseup', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'mouseup'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'renderStageAllButton', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'renderStageAllButton'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'undoLastDiscard', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'undoLastDiscard'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'registerItemElement', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'registerItemElement'), _class.prototype)), _class);
exports.default = StagingView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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