'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class, _class2, _temp, _class3, _temp2;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _simpleTooltip = require('./simple-tooltip');

var _simpleTooltip2 = _interopRequireDefault(_simpleTooltip);

var _contextMenuInterceptor = require('../context-menu-interceptor');

var _contextMenuInterceptor2 = _interopRequireDefault(_contextMenuInterceptor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let HunkView = (_class = (_temp = _class2 = class HunkView extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.lineElements = new WeakMap();
    this.lastMousemoveLine = null;
  }

  render() {
    const hunkSelectedClass = this.props.isSelected ? 'is-selected' : '';
    const hunkModeClass = this.props.hunkSelectionMode ? 'is-hunkMode' : '';

    return _react2.default.createElement(
      'div',
      { className: `github-HunkView ${hunkModeClass} ${hunkSelectedClass}`, ref: e => {
          this.element = e;
        } },
      _react2.default.createElement(
        'div',
        { className: 'github-HunkView-header',
          onMouseDown: e => this.props.mousedownOnHeader(e) },
        _react2.default.createElement(
          'span',
          { className: 'github-HunkView-title' },
          this.props.hunk.getHeader().trim(),
          ' ',
          this.props.hunk.getSectionHeading().trim()
        ),
        _react2.default.createElement(
          'button',
          {
            className: 'github-HunkView-stageButton',
            onClick: this.props.didClickStageButton,
            onMouseDown: event => event.stopPropagation() },
          this.props.stageButtonLabel
        ),
        this.props.unstaged && _react2.default.createElement(
          _simpleTooltip2.default,
          {
            tooltips: this.props.tooltips,
            title: this.props.discardButtonLabel },
          _react2.default.createElement('button', {
            className: 'icon-trashcan github-HunkView-discardButton',
            onClick: this.props.didClickDiscardButton,
            onMouseDown: event => event.stopPropagation()
          })
        )
      ),
      this.props.hunk.getLines().map((line, idx) => _react2.default.createElement(LineView, {
        key: idx,
        line: line,
        isSelected: this.props.selectedLines.has(line),
        registerLineElement: this.registerLineElement,
        mousedown: this.mousedownOnLine,
        mousemove: this.mousemoveOnLine,
        contextMenuOnItem: (e, clickedLine) => this.props.contextMenuOnItem(e, this.props.hunk, clickedLine)
      }))
    );
  }

  mousedownOnLine(event, line) {
    this.props.mousedownOnLine(event, this.props.hunk, line);
  }

  mousemoveOnLine(event, line) {
    if (line !== this.lastMousemoveLine) {
      this.lastMousemoveLine = line;
      this.props.mousemoveOnLine(event, this.props.hunk, line);
    }
  }

  registerLineElement(line, element) {
    this.lineElements.set(line, element);
  }

  componentDidUpdate() {
    const selectedLine = Array.from(this.props.selectedLines)[0];
    if (selectedLine && this.lineElements.get(selectedLine)) {
      // QUESTION: why is this setTimeout needed?
      const element = this.lineElements.get(selectedLine);
      setTimeout(() => {
        element.scrollIntoViewIfNeeded();
      }, 0);
    } else if (this.props.headHunk === this.props.hunk) {
      this.element.scrollIntoViewIfNeeded();
    } else if (this.props.headLine && this.lineElements.has(this.props.headLine)) {
      this.lineElements.get(this.props.headLine).scrollIntoViewIfNeeded();
    }
  }
}, _class2.propTypes = {
  tooltips: _propTypes2.default.object.isRequired,
  hunk: _propTypes2.default.object.isRequired,
  headHunk: _propTypes2.default.object,
  headLine: _propTypes2.default.object,
  isSelected: _propTypes2.default.bool.isRequired,
  selectedLines: _propTypes2.default.instanceOf(Set).isRequired,
  hunkSelectionMode: _propTypes2.default.bool.isRequired,
  stageButtonLabel: _propTypes2.default.string.isRequired,
  discardButtonLabel: _propTypes2.default.string.isRequired,
  unstaged: _propTypes2.default.bool.isRequired,
  mousedownOnHeader: _propTypes2.default.func.isRequired,
  mousedownOnLine: _propTypes2.default.func.isRequired,
  mousemoveOnLine: _propTypes2.default.func.isRequired,
  contextMenuOnItem: _propTypes2.default.func.isRequired,
  didClickStageButton: _propTypes2.default.func.isRequired,
  didClickDiscardButton: _propTypes2.default.func.isRequired
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'mousedownOnLine', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'mousedownOnLine'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'mousemoveOnLine', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'mousemoveOnLine'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'registerLineElement', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'registerLineElement'), _class.prototype)), _class);
exports.default = HunkView;
let LineView = (_temp2 = _class3 = class LineView extends _react2.default.Component {

  render() {
    const line = this.props.line;
    const oldLineNumber = line.getOldLineNumber() === -1 ? ' ' : line.getOldLineNumber();
    const newLineNumber = line.getNewLineNumber() === -1 ? ' ' : line.getNewLineNumber();
    const lineSelectedClass = this.props.isSelected ? 'is-selected' : '';

    return _react2.default.createElement(
      _contextMenuInterceptor2.default,
      { onWillShowContextMenu: event => this.props.contextMenuOnItem(event, line) },
      _react2.default.createElement(
        'div',
        {
          className: `github-HunkView-line ${lineSelectedClass} is-${line.getStatus()}`,
          onMouseDown: event => this.props.mousedown(event, line),
          onMouseMove: event => this.props.mousemove(event, line),
          ref: e => this.props.registerLineElement(line, e) },
        _react2.default.createElement(
          'div',
          { className: 'github-HunkView-lineNumber is-old' },
          oldLineNumber
        ),
        _react2.default.createElement(
          'div',
          { className: 'github-HunkView-lineNumber is-new' },
          newLineNumber
        ),
        _react2.default.createElement(
          'div',
          { className: 'github-HunkView-lineContent' },
          _react2.default.createElement(
            'span',
            { className: 'github-HunkView-plusMinus' },
            line.getOrigin()
          ),
          _react2.default.createElement(
            'span',
            null,
            line.getText()
          )
        )
      )
    );
  }
}, _class3.propTypes = {
  line: _propTypes2.default.object.isRequired,
  isSelected: _propTypes2.default.bool.isRequired,
  mousedown: _propTypes2.default.func.isRequired,
  mousemove: _propTypes2.default.func.isRequired,
  contextMenuOnItem: _propTypes2.default.func.isRequired,
  registerLineElement: _propTypes2.default.func.isRequired
}, _temp2);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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