'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FOCUS = undefined;

var _desc, _value, _class;

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _eventKit = require('event-kit');

var _nsfw = require('nsfw');

var _nsfw2 = _interopRequireDefault(_nsfw);

var _coreDecorators = require('core-decorators');

var _eventLogger = require('./event-logger');

var _eventLogger2 = _interopRequireDefault(_eventLogger);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

const FOCUS = exports.FOCUS = Symbol('focus');

let WorkspaceChangeObserver = (_class = class WorkspaceChangeObserver {
  constructor(window, workspace, repository) {
    this.window = window;
    this.repository = repository;
    this.workspace = workspace;
    this.observedBuffers = new WeakSet();
    this.emitter = new _eventKit.Emitter();
    this.disposables = new _eventKit.CompositeDisposable();
    this.logger = new _eventLogger2.default('workspace watcher');
    this.started = false;
  }

  start() {
    var _this = this;

    return _asyncToGenerator(function* () {
      const focusHandler = function (event) {
        if (_this.repository) {
          _this.logger.showFocusEvent();
          _this.didChange([{ special: FOCUS }]);
        }
      };
      _this.window.addEventListener('focus', focusHandler);
      _this.disposables.add(_this.workspace.observeTextEditors(_this.observeTextEditor), new _eventKit.Disposable(function () {
        return _this.window.removeEventListener('focus', focusHandler);
      }));
      yield _this.watchActiveRepositoryGitDirectory();
      _this.started = true;
      return _this;
    })();
  }

  destroy() {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      _this2.started = false;
      _this2.observedBuffers = new WeakSet();
      _this2.emitter.dispose();
      _this2.disposables.dispose();
      yield _this2.stopCurrentFileWatcher();
    })();
  }

  isStarted() {
    return this.started;
  }

  didChange(payload) {
    this.emitter.emit('did-change', payload);
  }

  didChangeWorkdirOrHead() {
    this.emitter.emit('did-change-workdir-or-head');
  }

  onDidChange(callback) {
    return this.emitter.on('did-change', callback);
  }

  onDidChangeWorkdirOrHead(callback) {
    return this.emitter.on('did-change-workdir-or-head', callback);
  }

  getRepository() {
    return this.repository;
  }

  watchActiveRepositoryGitDirectory() {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      const repository = _this3.getRepository();
      const gitDirectoryPath = repository.getGitDirectoryPath();
      if (repository) {
        _this3.currentFileWatcher = yield (0, _nsfw2.default)(gitDirectoryPath, function (events) {
          const filteredEvents = events.filter(function (e) {
            return ['config', 'index', 'HEAD', 'MERGE_HEAD'].includes(e.file || e.newFile) || e.directory.includes(_path2.default.join('.git', 'refs'));
          });
          if (filteredEvents.length) {
            _this3.logger.showEvents(filteredEvents);
            _this3.didChange(filteredEvents);
            const workdirOrHeadEvent = filteredEvents.filter(function (e) {
              return !['config', 'index'].includes(e.file || e.newFile);
            });
            if (workdirOrHeadEvent) {
              _this3.logger.showWorkdirOrHeadEvents();
              _this3.didChangeWorkdirOrHead();
            }
          }
        }, {
          debounceMS: 100,
          errorCallback: function (errors) {
            const workingDirectory = repository.getWorkingDirectoryPath();
            // eslint-disable-next-line no-console
            console.warn(`Error in FileSystemChangeObserver in ${workingDirectory}:`, errors);
            _this3.stopCurrentFileWatcher();
          }
        });
        yield _this3.currentFileWatcher.start();
        _this3.logger.showStarted(gitDirectoryPath);
      }
    })();
  }

  stopCurrentFileWatcher() {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      if (_this4.currentFileWatcher) {
        yield _this4.currentFileWatcher.stop();
        _this4.currentFileWatcher = null;
        _this4.logger.showStopped();
      }
    })();
  }

  activeRepositoryContainsPath(filePath) {
    const repository = this.getRepository();
    if (filePath && repository) {
      return filePath.indexOf(repository.getWorkingDirectoryPath()) !== -1;
    } else {
      return false;
    }
  }

  observeTextEditor(editor) {
    const buffer = editor.getBuffer();
    if (!this.observedBuffers.has(buffer)) {
      const didChange = () => {
        const fullPath = buffer.getPath();
        const events = [{
          directory: _path2.default.dirname(fullPath),
          file: _path2.default.basename(fullPath)
        }];
        this.logger.showEvents(events);
        this.didChange(events);
      };

      this.observedBuffers.add(buffer);
      const disposables = new _eventKit.CompositeDisposable(buffer.onDidSave(() => {
        if (this.activeRepositoryContainsPath(buffer.getPath())) {
          didChange();
        }
      }), buffer.onDidReload(() => {
        if (this.activeRepositoryContainsPath(buffer.getPath())) {
          didChange();
        }
      }), buffer.onDidDestroy(() => {
        if (this.activeRepositoryContainsPath(buffer.getPath())) {
          didChange();
        }
        disposables.dispose();
      }));
      this.disposables.add(disposables);
    }
  }
}, (_applyDecoratedDescriptor(_class.prototype, 'observeTextEditor', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'observeTextEditor'), _class.prototype)), _class);
exports.default = WorkspaceChangeObserver;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndvcmtzcGFjZS1jaGFuZ2Utb2JzZXJ2ZXIuanMiXSwibmFtZXMiOlsiRk9DVVMiLCJTeW1ib2wiLCJXb3Jrc3BhY2VDaGFuZ2VPYnNlcnZlciIsImNvbnN0cnVjdG9yIiwid2luZG93Iiwid29ya3NwYWNlIiwicmVwb3NpdG9yeSIsIm9ic2VydmVkQnVmZmVycyIsIldlYWtTZXQiLCJlbWl0dGVyIiwiZGlzcG9zYWJsZXMiLCJsb2dnZXIiLCJzdGFydGVkIiwic3RhcnQiLCJmb2N1c0hhbmRsZXIiLCJzaG93Rm9jdXNFdmVudCIsImRpZENoYW5nZSIsInNwZWNpYWwiLCJhZGRFdmVudExpc3RlbmVyIiwiYWRkIiwib2JzZXJ2ZVRleHRFZGl0b3JzIiwib2JzZXJ2ZVRleHRFZGl0b3IiLCJyZW1vdmVFdmVudExpc3RlbmVyIiwid2F0Y2hBY3RpdmVSZXBvc2l0b3J5R2l0RGlyZWN0b3J5IiwiZGVzdHJveSIsImRpc3Bvc2UiLCJzdG9wQ3VycmVudEZpbGVXYXRjaGVyIiwiaXNTdGFydGVkIiwicGF5bG9hZCIsImVtaXQiLCJkaWRDaGFuZ2VXb3JrZGlyT3JIZWFkIiwib25EaWRDaGFuZ2UiLCJjYWxsYmFjayIsIm9uIiwib25EaWRDaGFuZ2VXb3JrZGlyT3JIZWFkIiwiZ2V0UmVwb3NpdG9yeSIsImdpdERpcmVjdG9yeVBhdGgiLCJnZXRHaXREaXJlY3RvcnlQYXRoIiwiY3VycmVudEZpbGVXYXRjaGVyIiwiZmlsdGVyZWRFdmVudHMiLCJldmVudHMiLCJmaWx0ZXIiLCJpbmNsdWRlcyIsImUiLCJmaWxlIiwibmV3RmlsZSIsImRpcmVjdG9yeSIsImpvaW4iLCJsZW5ndGgiLCJzaG93RXZlbnRzIiwid29ya2Rpck9ySGVhZEV2ZW50Iiwic2hvd1dvcmtkaXJPckhlYWRFdmVudHMiLCJkZWJvdW5jZU1TIiwiZXJyb3JDYWxsYmFjayIsIndvcmtpbmdEaXJlY3RvcnkiLCJnZXRXb3JraW5nRGlyZWN0b3J5UGF0aCIsImNvbnNvbGUiLCJ3YXJuIiwiZXJyb3JzIiwic2hvd1N0YXJ0ZWQiLCJzdG9wIiwic2hvd1N0b3BwZWQiLCJhY3RpdmVSZXBvc2l0b3J5Q29udGFpbnNQYXRoIiwiZmlsZVBhdGgiLCJpbmRleE9mIiwiZWRpdG9yIiwiYnVmZmVyIiwiZ2V0QnVmZmVyIiwiaGFzIiwiZnVsbFBhdGgiLCJnZXRQYXRoIiwiZGlybmFtZSIsImJhc2VuYW1lIiwib25EaWRTYXZlIiwib25EaWRSZWxvYWQiLCJvbkRpZERlc3Ryb3kiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztBQUFBOzs7O0FBQ0E7O0FBRUE7Ozs7QUFDQTs7QUFFQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQUVPLE1BQU1BLHdCQUFRQyxPQUFPLE9BQVAsQ0FBZDs7SUFFY0MsdUIsYUFBTixNQUFNQSx1QkFBTixDQUE4QjtBQUMzQ0MsY0FBWUMsTUFBWixFQUFvQkMsU0FBcEIsRUFBK0JDLFVBQS9CLEVBQTJDO0FBQ3pDLFNBQUtGLE1BQUwsR0FBY0EsTUFBZDtBQUNBLFNBQUtFLFVBQUwsR0FBa0JBLFVBQWxCO0FBQ0EsU0FBS0QsU0FBTCxHQUFpQkEsU0FBakI7QUFDQSxTQUFLRSxlQUFMLEdBQXVCLElBQUlDLE9BQUosRUFBdkI7QUFDQSxTQUFLQyxPQUFMLEdBQWUsdUJBQWY7QUFDQSxTQUFLQyxXQUFMLEdBQW1CLG1DQUFuQjtBQUNBLFNBQUtDLE1BQUwsR0FBYywwQkFBZ0IsbUJBQWhCLENBQWQ7QUFDQSxTQUFLQyxPQUFMLEdBQWUsS0FBZjtBQUNEOztBQUVLQyxPQUFOLEdBQWM7QUFBQTs7QUFBQTtBQUNaLFlBQU1DLGVBQWUsaUJBQVM7QUFDNUIsWUFBSSxNQUFLUixVQUFULEVBQXFCO0FBQ25CLGdCQUFLSyxNQUFMLENBQVlJLGNBQVo7QUFDQSxnQkFBS0MsU0FBTCxDQUFlLENBQUMsRUFBQ0MsU0FBU2pCLEtBQVYsRUFBRCxDQUFmO0FBQ0Q7QUFDRixPQUxEO0FBTUEsWUFBS0ksTUFBTCxDQUFZYyxnQkFBWixDQUE2QixPQUE3QixFQUFzQ0osWUFBdEM7QUFDQSxZQUFLSixXQUFMLENBQWlCUyxHQUFqQixDQUNFLE1BQUtkLFNBQUwsQ0FBZWUsa0JBQWYsQ0FBa0MsTUFBS0MsaUJBQXZDLENBREYsRUFFRSx5QkFBZTtBQUFBLGVBQU0sTUFBS2pCLE1BQUwsQ0FBWWtCLG1CQUFaLENBQWdDLE9BQWhDLEVBQXlDUixZQUF6QyxDQUFOO0FBQUEsT0FBZixDQUZGO0FBSUEsWUFBTSxNQUFLUyxpQ0FBTCxFQUFOO0FBQ0EsWUFBS1gsT0FBTCxHQUFlLElBQWY7QUFDQTtBQWRZO0FBZWI7O0FBRUtZLFNBQU4sR0FBZ0I7QUFBQTs7QUFBQTtBQUNkLGFBQUtaLE9BQUwsR0FBZSxLQUFmO0FBQ0EsYUFBS0wsZUFBTCxHQUF1QixJQUFJQyxPQUFKLEVBQXZCO0FBQ0EsYUFBS0MsT0FBTCxDQUFhZ0IsT0FBYjtBQUNBLGFBQUtmLFdBQUwsQ0FBaUJlLE9BQWpCO0FBQ0EsWUFBTSxPQUFLQyxzQkFBTCxFQUFOO0FBTGM7QUFNZjs7QUFFREMsY0FBWTtBQUNWLFdBQU8sS0FBS2YsT0FBWjtBQUNEOztBQUVESSxZQUFVWSxPQUFWLEVBQW1CO0FBQ2pCLFNBQUtuQixPQUFMLENBQWFvQixJQUFiLENBQWtCLFlBQWxCLEVBQWdDRCxPQUFoQztBQUNEOztBQUVERSwyQkFBeUI7QUFDdkIsU0FBS3JCLE9BQUwsQ0FBYW9CLElBQWIsQ0FBa0IsNEJBQWxCO0FBQ0Q7O0FBRURFLGNBQVlDLFFBQVosRUFBc0I7QUFDcEIsV0FBTyxLQUFLdkIsT0FBTCxDQUFhd0IsRUFBYixDQUFnQixZQUFoQixFQUE4QkQsUUFBOUIsQ0FBUDtBQUNEOztBQUVERSwyQkFBeUJGLFFBQXpCLEVBQW1DO0FBQ2pDLFdBQU8sS0FBS3ZCLE9BQUwsQ0FBYXdCLEVBQWIsQ0FBZ0IsNEJBQWhCLEVBQThDRCxRQUE5QyxDQUFQO0FBQ0Q7O0FBRURHLGtCQUFnQjtBQUNkLFdBQU8sS0FBSzdCLFVBQVo7QUFDRDs7QUFFS2lCLG1DQUFOLEdBQTBDO0FBQUE7O0FBQUE7QUFDeEMsWUFBTWpCLGFBQWEsT0FBSzZCLGFBQUwsRUFBbkI7QUFDQSxZQUFNQyxtQkFBbUI5QixXQUFXK0IsbUJBQVgsRUFBekI7QUFDQSxVQUFJL0IsVUFBSixFQUFnQjtBQUNkLGVBQUtnQyxrQkFBTCxHQUEwQixNQUFNLG9CQUM5QkYsZ0JBRDhCLEVBRTlCLGtCQUFVO0FBQ1IsZ0JBQU1HLGlCQUFpQkMsT0FBT0MsTUFBUCxDQUFjLGFBQUs7QUFDeEMsbUJBQU8sQ0FBQyxRQUFELEVBQVcsT0FBWCxFQUFvQixNQUFwQixFQUE0QixZQUE1QixFQUEwQ0MsUUFBMUMsQ0FBbURDLEVBQUVDLElBQUYsSUFBVUQsRUFBRUUsT0FBL0QsS0FDTEYsRUFBRUcsU0FBRixDQUFZSixRQUFaLENBQXFCLGVBQUtLLElBQUwsQ0FBVSxNQUFWLEVBQWtCLE1BQWxCLENBQXJCLENBREY7QUFFRCxXQUhzQixDQUF2QjtBQUlBLGNBQUlSLGVBQWVTLE1BQW5CLEVBQTJCO0FBQ3pCLG1CQUFLckMsTUFBTCxDQUFZc0MsVUFBWixDQUF1QlYsY0FBdkI7QUFDQSxtQkFBS3ZCLFNBQUwsQ0FBZXVCLGNBQWY7QUFDQSxrQkFBTVcscUJBQXFCWCxlQUFlRSxNQUFmLENBQXNCO0FBQUEscUJBQUssQ0FBQyxDQUFDLFFBQUQsRUFBVyxPQUFYLEVBQW9CQyxRQUFwQixDQUE2QkMsRUFBRUMsSUFBRixJQUFVRCxFQUFFRSxPQUF6QyxDQUFOO0FBQUEsYUFBdEIsQ0FBM0I7QUFDQSxnQkFBSUssa0JBQUosRUFBd0I7QUFDdEIscUJBQUt2QyxNQUFMLENBQVl3Qyx1QkFBWjtBQUNBLHFCQUFLckIsc0JBQUw7QUFDRDtBQUNGO0FBQ0YsU0FoQjZCLEVBaUI5QjtBQUNFc0Isc0JBQVksR0FEZDtBQUVFQyx5QkFBZSxrQkFBVTtBQUN2QixrQkFBTUMsbUJBQW1CaEQsV0FBV2lELHVCQUFYLEVBQXpCO0FBQ0E7QUFDQUMsb0JBQVFDLElBQVIsQ0FBYyx3Q0FBdUNILGdCQUFpQixHQUF0RSxFQUEwRUksTUFBMUU7QUFDQSxtQkFBS2hDLHNCQUFMO0FBQ0Q7QUFQSCxTQWpCOEIsQ0FBaEM7QUEyQkEsY0FBTSxPQUFLWSxrQkFBTCxDQUF3QnpCLEtBQXhCLEVBQU47QUFDQSxlQUFLRixNQUFMLENBQVlnRCxXQUFaLENBQXdCdkIsZ0JBQXhCO0FBQ0Q7QUFqQ3VDO0FBa0N6Qzs7QUFFS1Ysd0JBQU4sR0FBK0I7QUFBQTs7QUFBQTtBQUM3QixVQUFJLE9BQUtZLGtCQUFULEVBQTZCO0FBQzNCLGNBQU0sT0FBS0Esa0JBQUwsQ0FBd0JzQixJQUF4QixFQUFOO0FBQ0EsZUFBS3RCLGtCQUFMLEdBQTBCLElBQTFCO0FBQ0EsZUFBSzNCLE1BQUwsQ0FBWWtELFdBQVo7QUFDRDtBQUw0QjtBQU05Qjs7QUFFREMsK0JBQTZCQyxRQUE3QixFQUF1QztBQUNyQyxVQUFNekQsYUFBYSxLQUFLNkIsYUFBTCxFQUFuQjtBQUNBLFFBQUk0QixZQUFZekQsVUFBaEIsRUFBNEI7QUFDMUIsYUFBT3lELFNBQVNDLE9BQVQsQ0FBaUIxRCxXQUFXaUQsdUJBQVgsRUFBakIsTUFBMkQsQ0FBQyxDQUFuRTtBQUNELEtBRkQsTUFFTztBQUNMLGFBQU8sS0FBUDtBQUNEO0FBQ0Y7O0FBR0RsQyxvQkFBa0I0QyxNQUFsQixFQUEwQjtBQUN4QixVQUFNQyxTQUFTRCxPQUFPRSxTQUFQLEVBQWY7QUFDQSxRQUFJLENBQUMsS0FBSzVELGVBQUwsQ0FBcUI2RCxHQUFyQixDQUF5QkYsTUFBekIsQ0FBTCxFQUF1QztBQUNyQyxZQUFNbEQsWUFBWSxNQUFNO0FBQ3RCLGNBQU1xRCxXQUFXSCxPQUFPSSxPQUFQLEVBQWpCO0FBQ0EsY0FBTTlCLFNBQVMsQ0FBQztBQUNkTSxxQkFBVyxlQUFLeUIsT0FBTCxDQUFhRixRQUFiLENBREc7QUFFZHpCLGdCQUFNLGVBQUs0QixRQUFMLENBQWNILFFBQWQ7QUFGUSxTQUFELENBQWY7QUFJQSxhQUFLMUQsTUFBTCxDQUFZc0MsVUFBWixDQUF1QlQsTUFBdkI7QUFDQSxhQUFLeEIsU0FBTCxDQUFld0IsTUFBZjtBQUNELE9BUkQ7O0FBVUEsV0FBS2pDLGVBQUwsQ0FBcUJZLEdBQXJCLENBQXlCK0MsTUFBekI7QUFDQSxZQUFNeEQsY0FBYyxrQ0FDbEJ3RCxPQUFPTyxTQUFQLENBQWlCLE1BQU07QUFDckIsWUFBSSxLQUFLWCw0QkFBTCxDQUFrQ0ksT0FBT0ksT0FBUCxFQUFsQyxDQUFKLEVBQXlEO0FBQ3ZEdEQ7QUFDRDtBQUNGLE9BSkQsQ0FEa0IsRUFNbEJrRCxPQUFPUSxXQUFQLENBQW1CLE1BQU07QUFDdkIsWUFBSSxLQUFLWiw0QkFBTCxDQUFrQ0ksT0FBT0ksT0FBUCxFQUFsQyxDQUFKLEVBQXlEO0FBQ3ZEdEQ7QUFDRDtBQUNGLE9BSkQsQ0FOa0IsRUFXbEJrRCxPQUFPUyxZQUFQLENBQW9CLE1BQU07QUFDeEIsWUFBSSxLQUFLYiw0QkFBTCxDQUFrQ0ksT0FBT0ksT0FBUCxFQUFsQyxDQUFKLEVBQXlEO0FBQ3ZEdEQ7QUFDRDtBQUNETixvQkFBWWUsT0FBWjtBQUNELE9BTEQsQ0FYa0IsQ0FBcEI7QUFrQkEsV0FBS2YsV0FBTCxDQUFpQlMsR0FBakIsQ0FBcUJULFdBQXJCO0FBQ0Q7QUFDRjtBQXJKMEMsQztrQkFBeEJSLHVCIiwiZmlsZSI6IndvcmtzcGFjZS1jaGFuZ2Utb2JzZXJ2ZXIuanMiLCJzb3VyY2VSb290IjoiL2hvbWUvYW5kcmVpL2F0b20tMS4xOS4yL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0IHtDb21wb3NpdGVEaXNwb3NhYmxlLCBEaXNwb3NhYmxlLCBFbWl0dGVyfSBmcm9tICdldmVudC1raXQnO1xuXG5pbXBvcnQgbnNmdyBmcm9tICduc2Z3JztcbmltcG9ydCB7YXV0b2JpbmR9IGZyb20gJ2NvcmUtZGVjb3JhdG9ycyc7XG5cbmltcG9ydCBFdmVudExvZ2dlciBmcm9tICcuL2V2ZW50LWxvZ2dlcic7XG5cbmV4cG9ydCBjb25zdCBGT0NVUyA9IFN5bWJvbCgnZm9jdXMnKTtcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgV29ya3NwYWNlQ2hhbmdlT2JzZXJ2ZXIge1xuICBjb25zdHJ1Y3Rvcih3aW5kb3csIHdvcmtzcGFjZSwgcmVwb3NpdG9yeSkge1xuICAgIHRoaXMud2luZG93ID0gd2luZG93O1xuICAgIHRoaXMucmVwb3NpdG9yeSA9IHJlcG9zaXRvcnk7XG4gICAgdGhpcy53b3Jrc3BhY2UgPSB3b3Jrc3BhY2U7XG4gICAgdGhpcy5vYnNlcnZlZEJ1ZmZlcnMgPSBuZXcgV2Vha1NldCgpO1xuICAgIHRoaXMuZW1pdHRlciA9IG5ldyBFbWl0dGVyKCk7XG4gICAgdGhpcy5kaXNwb3NhYmxlcyA9IG5ldyBDb21wb3NpdGVEaXNwb3NhYmxlKCk7XG4gICAgdGhpcy5sb2dnZXIgPSBuZXcgRXZlbnRMb2dnZXIoJ3dvcmtzcGFjZSB3YXRjaGVyJyk7XG4gICAgdGhpcy5zdGFydGVkID0gZmFsc2U7XG4gIH1cblxuICBhc3luYyBzdGFydCgpIHtcbiAgICBjb25zdCBmb2N1c0hhbmRsZXIgPSBldmVudCA9PiB7XG4gICAgICBpZiAodGhpcy5yZXBvc2l0b3J5KSB7XG4gICAgICAgIHRoaXMubG9nZ2VyLnNob3dGb2N1c0V2ZW50KCk7XG4gICAgICAgIHRoaXMuZGlkQ2hhbmdlKFt7c3BlY2lhbDogRk9DVVN9XSk7XG4gICAgICB9XG4gICAgfTtcbiAgICB0aGlzLndpbmRvdy5hZGRFdmVudExpc3RlbmVyKCdmb2N1cycsIGZvY3VzSGFuZGxlcik7XG4gICAgdGhpcy5kaXNwb3NhYmxlcy5hZGQoXG4gICAgICB0aGlzLndvcmtzcGFjZS5vYnNlcnZlVGV4dEVkaXRvcnModGhpcy5vYnNlcnZlVGV4dEVkaXRvciksXG4gICAgICBuZXcgRGlzcG9zYWJsZSgoKSA9PiB0aGlzLndpbmRvdy5yZW1vdmVFdmVudExpc3RlbmVyKCdmb2N1cycsIGZvY3VzSGFuZGxlcikpLFxuICAgICk7XG4gICAgYXdhaXQgdGhpcy53YXRjaEFjdGl2ZVJlcG9zaXRvcnlHaXREaXJlY3RvcnkoKTtcbiAgICB0aGlzLnN0YXJ0ZWQgPSB0cnVlO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgYXN5bmMgZGVzdHJveSgpIHtcbiAgICB0aGlzLnN0YXJ0ZWQgPSBmYWxzZTtcbiAgICB0aGlzLm9ic2VydmVkQnVmZmVycyA9IG5ldyBXZWFrU2V0KCk7XG4gICAgdGhpcy5lbWl0dGVyLmRpc3Bvc2UoKTtcbiAgICB0aGlzLmRpc3Bvc2FibGVzLmRpc3Bvc2UoKTtcbiAgICBhd2FpdCB0aGlzLnN0b3BDdXJyZW50RmlsZVdhdGNoZXIoKTtcbiAgfVxuXG4gIGlzU3RhcnRlZCgpIHtcbiAgICByZXR1cm4gdGhpcy5zdGFydGVkO1xuICB9XG5cbiAgZGlkQ2hhbmdlKHBheWxvYWQpIHtcbiAgICB0aGlzLmVtaXR0ZXIuZW1pdCgnZGlkLWNoYW5nZScsIHBheWxvYWQpO1xuICB9XG5cbiAgZGlkQ2hhbmdlV29ya2Rpck9ySGVhZCgpIHtcbiAgICB0aGlzLmVtaXR0ZXIuZW1pdCgnZGlkLWNoYW5nZS13b3JrZGlyLW9yLWhlYWQnKTtcbiAgfVxuXG4gIG9uRGlkQ2hhbmdlKGNhbGxiYWNrKSB7XG4gICAgcmV0dXJuIHRoaXMuZW1pdHRlci5vbignZGlkLWNoYW5nZScsIGNhbGxiYWNrKTtcbiAgfVxuXG4gIG9uRGlkQ2hhbmdlV29ya2Rpck9ySGVhZChjYWxsYmFjaykge1xuICAgIHJldHVybiB0aGlzLmVtaXR0ZXIub24oJ2RpZC1jaGFuZ2Utd29ya2Rpci1vci1oZWFkJywgY2FsbGJhY2spO1xuICB9XG5cbiAgZ2V0UmVwb3NpdG9yeSgpIHtcbiAgICByZXR1cm4gdGhpcy5yZXBvc2l0b3J5O1xuICB9XG5cbiAgYXN5bmMgd2F0Y2hBY3RpdmVSZXBvc2l0b3J5R2l0RGlyZWN0b3J5KCkge1xuICAgIGNvbnN0IHJlcG9zaXRvcnkgPSB0aGlzLmdldFJlcG9zaXRvcnkoKTtcbiAgICBjb25zdCBnaXREaXJlY3RvcnlQYXRoID0gcmVwb3NpdG9yeS5nZXRHaXREaXJlY3RvcnlQYXRoKCk7XG4gICAgaWYgKHJlcG9zaXRvcnkpIHtcbiAgICAgIHRoaXMuY3VycmVudEZpbGVXYXRjaGVyID0gYXdhaXQgbnNmdyhcbiAgICAgICAgZ2l0RGlyZWN0b3J5UGF0aCxcbiAgICAgICAgZXZlbnRzID0+IHtcbiAgICAgICAgICBjb25zdCBmaWx0ZXJlZEV2ZW50cyA9IGV2ZW50cy5maWx0ZXIoZSA9PiB7XG4gICAgICAgICAgICByZXR1cm4gWydjb25maWcnLCAnaW5kZXgnLCAnSEVBRCcsICdNRVJHRV9IRUFEJ10uaW5jbHVkZXMoZS5maWxlIHx8IGUubmV3RmlsZSkgfHxcbiAgICAgICAgICAgICAgZS5kaXJlY3RvcnkuaW5jbHVkZXMocGF0aC5qb2luKCcuZ2l0JywgJ3JlZnMnKSk7XG4gICAgICAgICAgfSk7XG4gICAgICAgICAgaWYgKGZpbHRlcmVkRXZlbnRzLmxlbmd0aCkge1xuICAgICAgICAgICAgdGhpcy5sb2dnZXIuc2hvd0V2ZW50cyhmaWx0ZXJlZEV2ZW50cyk7XG4gICAgICAgICAgICB0aGlzLmRpZENoYW5nZShmaWx0ZXJlZEV2ZW50cyk7XG4gICAgICAgICAgICBjb25zdCB3b3JrZGlyT3JIZWFkRXZlbnQgPSBmaWx0ZXJlZEV2ZW50cy5maWx0ZXIoZSA9PiAhWydjb25maWcnLCAnaW5kZXgnXS5pbmNsdWRlcyhlLmZpbGUgfHwgZS5uZXdGaWxlKSk7XG4gICAgICAgICAgICBpZiAod29ya2Rpck9ySGVhZEV2ZW50KSB7XG4gICAgICAgICAgICAgIHRoaXMubG9nZ2VyLnNob3dXb3JrZGlyT3JIZWFkRXZlbnRzKCk7XG4gICAgICAgICAgICAgIHRoaXMuZGlkQ2hhbmdlV29ya2Rpck9ySGVhZCgpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgIH1cbiAgICAgICAgfSxcbiAgICAgICAge1xuICAgICAgICAgIGRlYm91bmNlTVM6IDEwMCxcbiAgICAgICAgICBlcnJvckNhbGxiYWNrOiBlcnJvcnMgPT4ge1xuICAgICAgICAgICAgY29uc3Qgd29ya2luZ0RpcmVjdG9yeSA9IHJlcG9zaXRvcnkuZ2V0V29ya2luZ0RpcmVjdG9yeVBhdGgoKTtcbiAgICAgICAgICAgIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby1jb25zb2xlXG4gICAgICAgICAgICBjb25zb2xlLndhcm4oYEVycm9yIGluIEZpbGVTeXN0ZW1DaGFuZ2VPYnNlcnZlciBpbiAke3dvcmtpbmdEaXJlY3Rvcnl9OmAsIGVycm9ycyk7XG4gICAgICAgICAgICB0aGlzLnN0b3BDdXJyZW50RmlsZVdhdGNoZXIoKTtcbiAgICAgICAgICB9LFxuICAgICAgICB9LFxuICAgICAgKTtcbiAgICAgIGF3YWl0IHRoaXMuY3VycmVudEZpbGVXYXRjaGVyLnN0YXJ0KCk7XG4gICAgICB0aGlzLmxvZ2dlci5zaG93U3RhcnRlZChnaXREaXJlY3RvcnlQYXRoKTtcbiAgICB9XG4gIH1cblxuICBhc3luYyBzdG9wQ3VycmVudEZpbGVXYXRjaGVyKCkge1xuICAgIGlmICh0aGlzLmN1cnJlbnRGaWxlV2F0Y2hlcikge1xuICAgICAgYXdhaXQgdGhpcy5jdXJyZW50RmlsZVdhdGNoZXIuc3RvcCgpO1xuICAgICAgdGhpcy5jdXJyZW50RmlsZVdhdGNoZXIgPSBudWxsO1xuICAgICAgdGhpcy5sb2dnZXIuc2hvd1N0b3BwZWQoKTtcbiAgICB9XG4gIH1cblxuICBhY3RpdmVSZXBvc2l0b3J5Q29udGFpbnNQYXRoKGZpbGVQYXRoKSB7XG4gICAgY29uc3QgcmVwb3NpdG9yeSA9IHRoaXMuZ2V0UmVwb3NpdG9yeSgpO1xuICAgIGlmIChmaWxlUGF0aCAmJiByZXBvc2l0b3J5KSB7XG4gICAgICByZXR1cm4gZmlsZVBhdGguaW5kZXhPZihyZXBvc2l0b3J5LmdldFdvcmtpbmdEaXJlY3RvcnlQYXRoKCkpICE9PSAtMTtcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbiAgfVxuXG4gIEBhdXRvYmluZFxuICBvYnNlcnZlVGV4dEVkaXRvcihlZGl0b3IpIHtcbiAgICBjb25zdCBidWZmZXIgPSBlZGl0b3IuZ2V0QnVmZmVyKCk7XG4gICAgaWYgKCF0aGlzLm9ic2VydmVkQnVmZmVycy5oYXMoYnVmZmVyKSkge1xuICAgICAgY29uc3QgZGlkQ2hhbmdlID0gKCkgPT4ge1xuICAgICAgICBjb25zdCBmdWxsUGF0aCA9IGJ1ZmZlci5nZXRQYXRoKCk7XG4gICAgICAgIGNvbnN0IGV2ZW50cyA9IFt7XG4gICAgICAgICAgZGlyZWN0b3J5OiBwYXRoLmRpcm5hbWUoZnVsbFBhdGgpLFxuICAgICAgICAgIGZpbGU6IHBhdGguYmFzZW5hbWUoZnVsbFBhdGgpLFxuICAgICAgICB9XTtcbiAgICAgICAgdGhpcy5sb2dnZXIuc2hvd0V2ZW50cyhldmVudHMpO1xuICAgICAgICB0aGlzLmRpZENoYW5nZShldmVudHMpO1xuICAgICAgfTtcblxuICAgICAgdGhpcy5vYnNlcnZlZEJ1ZmZlcnMuYWRkKGJ1ZmZlcik7XG4gICAgICBjb25zdCBkaXNwb3NhYmxlcyA9IG5ldyBDb21wb3NpdGVEaXNwb3NhYmxlKFxuICAgICAgICBidWZmZXIub25EaWRTYXZlKCgpID0+IHtcbiAgICAgICAgICBpZiAodGhpcy5hY3RpdmVSZXBvc2l0b3J5Q29udGFpbnNQYXRoKGJ1ZmZlci5nZXRQYXRoKCkpKSB7XG4gICAgICAgICAgICBkaWRDaGFuZ2UoKTtcbiAgICAgICAgICB9XG4gICAgICAgIH0pLFxuICAgICAgICBidWZmZXIub25EaWRSZWxvYWQoKCkgPT4ge1xuICAgICAgICAgIGlmICh0aGlzLmFjdGl2ZVJlcG9zaXRvcnlDb250YWluc1BhdGgoYnVmZmVyLmdldFBhdGgoKSkpIHtcbiAgICAgICAgICAgIGRpZENoYW5nZSgpO1xuICAgICAgICAgIH1cbiAgICAgICAgfSksXG4gICAgICAgIGJ1ZmZlci5vbkRpZERlc3Ryb3koKCkgPT4ge1xuICAgICAgICAgIGlmICh0aGlzLmFjdGl2ZVJlcG9zaXRvcnlDb250YWluc1BhdGgoYnVmZmVyLmdldFBhdGgoKSkpIHtcbiAgICAgICAgICAgIGRpZENoYW5nZSgpO1xuICAgICAgICAgIH1cbiAgICAgICAgICBkaXNwb3NhYmxlcy5kaXNwb3NlKCk7XG4gICAgICAgIH0pLFxuICAgICAgKTtcbiAgICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKGRpc3Bvc2FibGVzKTtcbiAgICB9XG4gIH1cbn1cbiJdfQ==