'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _state = require('./state');

var _state2 = _interopRequireDefault(_state);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * The working directory exists, but contains no git repository yet.
 */
let Empty = class Empty extends _state2.default {
  isEmpty() {
    return true;
  }

  init() {
    return this.transitionTo('Initializing');
  }

  clone(remoteUrl) {
    return this.transitionTo('Cloning', remoteUrl);
  }

  showGitTabInit() {
    return true;
  }
};
exports.default = Empty;


_state2.default.register(Empty);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVtcHR5LmpzIl0sIm5hbWVzIjpbIkVtcHR5IiwiaXNFbXB0eSIsImluaXQiLCJ0cmFuc2l0aW9uVG8iLCJjbG9uZSIsInJlbW90ZVVybCIsInNob3dHaXRUYWJJbml0IiwicmVnaXN0ZXIiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7Ozs7O0FBRUE7OztJQUdxQkEsSyxHQUFOLE1BQU1BLEtBQU4seUJBQTBCO0FBQ3ZDQyxZQUFVO0FBQ1IsV0FBTyxJQUFQO0FBQ0Q7O0FBRURDLFNBQU87QUFDTCxXQUFPLEtBQUtDLFlBQUwsQ0FBa0IsY0FBbEIsQ0FBUDtBQUNEOztBQUVEQyxRQUFNQyxTQUFOLEVBQWlCO0FBQ2YsV0FBTyxLQUFLRixZQUFMLENBQWtCLFNBQWxCLEVBQTZCRSxTQUE3QixDQUFQO0FBQ0Q7O0FBRURDLG1CQUFpQjtBQUNmLFdBQU8sSUFBUDtBQUNEO0FBZnNDLEM7a0JBQXBCTixLOzs7QUFrQnJCLGdCQUFNTyxRQUFOLENBQWVQLEtBQWYiLCJmaWxlIjoiZW1wdHkuanMiLCJzb3VyY2VSb290IjoiL2hvbWUvYW5kcmVpL2F0b20tMS4xOS4yL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBTdGF0ZSBmcm9tICcuL3N0YXRlJztcblxuLyoqXG4gKiBUaGUgd29ya2luZyBkaXJlY3RvcnkgZXhpc3RzLCBidXQgY29udGFpbnMgbm8gZ2l0IHJlcG9zaXRvcnkgeWV0LlxuICovXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBFbXB0eSBleHRlbmRzIFN0YXRlIHtcbiAgaXNFbXB0eSgpIHtcbiAgICByZXR1cm4gdHJ1ZTtcbiAgfVxuXG4gIGluaXQoKSB7XG4gICAgcmV0dXJuIHRoaXMudHJhbnNpdGlvblRvKCdJbml0aWFsaXppbmcnKTtcbiAgfVxuXG4gIGNsb25lKHJlbW90ZVVybCkge1xuICAgIHJldHVybiB0aGlzLnRyYW5zaXRpb25UbygnQ2xvbmluZycsIHJlbW90ZVVybCk7XG4gIH1cblxuICBzaG93R2l0VGFiSW5pdCgpIHtcbiAgICByZXR1cm4gdHJ1ZTtcbiAgfVxufVxuXG5TdGF0ZS5yZWdpc3RlcihFbXB0eSk7XG4iXX0=