'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _state = require('./state');

var _state2 = _interopRequireDefault(_state);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Initial state to be used when we anticipate that the workspace will contain zero or many projects once bootstrapping
 * has completed. Presents in the UI like the Absent state, but is "sticky" during the initial package activation.
 */
let AbsentGuess = class AbsentGuess extends _state2.default {
  isAbsentGuess() {
    return true;
  }

  isUndetermined() {
    return true;
  }

  showGitTabLoading() {
    return false;
  }

  showGitTabInit() {
    return true;
  }

  hasDirectory() {
    return false;
  }
};
exports.default = AbsentGuess;


_state2.default.register(AbsentGuess);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFic2VudC1ndWVzcy5qcyJdLCJuYW1lcyI6WyJBYnNlbnRHdWVzcyIsImlzQWJzZW50R3Vlc3MiLCJpc1VuZGV0ZXJtaW5lZCIsInNob3dHaXRUYWJMb2FkaW5nIiwic2hvd0dpdFRhYkluaXQiLCJoYXNEaXJlY3RvcnkiLCJyZWdpc3RlciJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOzs7Ozs7QUFFQTs7OztJQUlxQkEsVyxHQUFOLE1BQU1BLFdBQU4seUJBQWdDO0FBQzdDQyxrQkFBZ0I7QUFDZCxXQUFPLElBQVA7QUFDRDs7QUFFREMsbUJBQWlCO0FBQ2YsV0FBTyxJQUFQO0FBQ0Q7O0FBRURDLHNCQUFvQjtBQUNsQixXQUFPLEtBQVA7QUFDRDs7QUFFREMsbUJBQWlCO0FBQ2YsV0FBTyxJQUFQO0FBQ0Q7O0FBRURDLGlCQUFlO0FBQ2IsV0FBTyxLQUFQO0FBQ0Q7QUFuQjRDLEM7a0JBQTFCTCxXOzs7QUFzQnJCLGdCQUFNTSxRQUFOLENBQWVOLFdBQWYiLCJmaWxlIjoiYWJzZW50LWd1ZXNzLmpzIiwic291cmNlUm9vdCI6Ii9ob21lL2FuZHJlaS9hdG9tLTEuMTkuMi9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgU3RhdGUgZnJvbSAnLi9zdGF0ZSc7XG5cbi8qKlxuICogSW5pdGlhbCBzdGF0ZSB0byBiZSB1c2VkIHdoZW4gd2UgYW50aWNpcGF0ZSB0aGF0IHRoZSB3b3Jrc3BhY2Ugd2lsbCBjb250YWluIHplcm8gb3IgbWFueSBwcm9qZWN0cyBvbmNlIGJvb3RzdHJhcHBpbmdcbiAqIGhhcyBjb21wbGV0ZWQuIFByZXNlbnRzIGluIHRoZSBVSSBsaWtlIHRoZSBBYnNlbnQgc3RhdGUsIGJ1dCBpcyBcInN0aWNreVwiIGR1cmluZyB0aGUgaW5pdGlhbCBwYWNrYWdlIGFjdGl2YXRpb24uXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEFic2VudEd1ZXNzIGV4dGVuZHMgU3RhdGUge1xuICBpc0Fic2VudEd1ZXNzKCkge1xuICAgIHJldHVybiB0cnVlO1xuICB9XG5cbiAgaXNVbmRldGVybWluZWQoKSB7XG4gICAgcmV0dXJuIHRydWU7XG4gIH1cblxuICBzaG93R2l0VGFiTG9hZGluZygpIHtcbiAgICByZXR1cm4gZmFsc2U7XG4gIH1cblxuICBzaG93R2l0VGFiSW5pdCgpIHtcbiAgICByZXR1cm4gdHJ1ZTtcbiAgfVxuXG4gIGhhc0RpcmVjdG9yeSgpIHtcbiAgICByZXR1cm4gZmFsc2U7XG4gIH1cbn1cblxuU3RhdGUucmVnaXN0ZXIoQWJzZW50R3Vlc3MpO1xuIl19