'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
let Position = class Position {
  constructor(name, cssClass) {
    this.name = name.toLowerCase();

    this.cssClass = cssClass;
  }

  getName() {
    return this.name;
  }

  when(actions) {
    const chosen = actions[this.name] || actions.default || (() => {
      throw new Error(`Unexpected conflict side position: ${this.name}`);
    });
    return chosen();
  }

  getBlockCSSClass() {
    return this.cssClass + 'Block';
  }

  toString() {
    return `<Position: ${this.name.toUpperCase()}>`;
  }
};
const TOP = exports.TOP = new Position('TOP', 'github-ConflictTop');
const MIDDLE = exports.MIDDLE = new Position('MIDDLE', 'github-ConflictMiddle');
const BOTTOM = exports.BOTTOM = new Position('BOTTOM', 'github-ConflictBottom');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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