'use strict';

var _githubPackage = require('./github-package');

var _githubPackage2 = _interopRequireDefault(_githubPackage);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let pack;
const entry = {
  initialize() {
    pack = new _githubPackage2.default(atom.workspace, atom.project, atom.commands, atom.notifications, atom.tooltips, atom.styles, atom.config, atom.confirm.bind(atom), atom.getConfigDirPath(), atom.getLoadSettings.bind(atom));
  }
};

module.exports = new Proxy(entry, {
  get(target, name) {
    if (pack && Reflect.has(pack, name)) {
      let item = pack[name];
      if (typeof item === 'function') {
        item = item.bind(pack);
      }
      return item;
    } else {
      return target[name];
    }
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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