'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class;

var _electron = require('electron');

var _eventKit = require('event-kit');

var _coreDecorators = require('core-decorators');

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let DeferredCallbackQueue = (_class = class DeferredCallbackQueue {
  constructor(wait, callback) {
    let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    this.wait = wait;
    const currentWindow = _electron.remote.getCurrentWindow();

    const onDidFocus = options.onDidFocus || function (cb) {
      currentWindow.on('focus', cb);
      return new _eventKit.Disposable(() => {
        currentWindow.removeListener('focus', cb);
      });
    };
    const onDidBlur = options.onDidBlur || function (cb) {
      if (atom.inSpecMode()) {
        return new _eventKit.Disposable();
      }
      currentWindow.on('blur', cb);
      return new _eventKit.Disposable(() => {
        currentWindow.removeListener('blur', cb);
      });
    };

    this.callback = callback;
    this.subscriptions = new _eventKit.CompositeDisposable();
    this.items = new Set();

    this.paused = !currentWindow.isFocused() && !atom.inSpecMode();
    this.subscriptions.add(onDidFocus(this.resume));
    this.subscriptions.add(onDidBlur(this.pause));
  }

  pause() {
    if (this.paused) {
      return;
    }
    this.paused = true;
  }

  resume() {
    if (!this.paused) {
      return;
    }
    this.paused = false;
    if (this.timer) {
      clearTimeout(this.timer);
    }
    this.flush();
  }

  resetTimer() {
    if (this.timer) {
      clearTimeout(this.timer);
    }
    this.timer = setTimeout(this.flush, this.wait);
  }

  flush() {
    delete this.timer;
    if (this.items.size) {
      this.callback([...this.items]);
      this.items.clear();
    }
  }

  push() {
    for (var _len = arguments.length, items = Array(_len), _key = 0; _key < _len; _key++) {
      items[_key] = arguments[_key];
    }

    if (this.paused) {
      items.forEach(item => this.items.add(item));
      this.resetTimer();
    } else {
      this.callback(items);
    }
  }

  destroy() {
    this.subscriptions.dispose();
  }
}, (_applyDecoratedDescriptor(_class.prototype, 'pause', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'pause'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'resume', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'resume'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'flush', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'flush'), _class.prototype)), _class);
exports.default = DeferredCallbackQueue;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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