'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.default = ObserveModelDecorator;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _hoistNonReactStatics = require('hoist-non-react-statics');

var _hoistNonReactStatics2 = _interopRequireDefault(_hoistNonReactStatics);

var _modelObserver = require('../models/model-observer');

var _modelObserver2 = _interopRequireDefault(_modelObserver);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Wraps a component in a HOC that watches for a model to change
 * and passes data to the wrapped component as props.
 * Utilizes `ModelObserver` to watch for model changes.
 *
 *   @ObserveModelDecorator({
 *     // getModel takes the props passed to the outer component
 *     // and should return the model to watch; defaults to `props.model`
 *     getModel: props => props.repository,
 *     // fetchData takes the model instance and the props passed
 *     // to the outer component and should return an object (or promise
 *     // of an object) specifying the data to be passed to the
 *     // inner component as props
 *     fetchData: (repo, props) => ({ stuff: repo.getStuff() }),
 *   })
 *   class MyComponent extends React.Component { ... }
 */
function ObserveModelDecorator(spec) {
  const getModel = spec.getModel || (props => props.model);
  const fetchData = spec.fetchData || (() => {});

  return function (Target) {
    var _class, _temp;

    let Wrapper = (_temp = _class = class Wrapper extends _react2.default.Component {

      static getWrappedComponentClass() {
        return Target;
      }

      constructor(props, context) {
        super(props, context);
        this.mounted = true;
        this.resolve = () => {};

        this.state = {
          modelData: {}
        };

        this.modelObserver = new _modelObserver2.default({
          fetchData: model => fetchData(model, this.props),
          didUpdate: () => {
            if (this.mounted) {
              this.setState({ modelData: this.modelObserver.getActiveModelData() }, () => {
                /* eslint-disable react/prop-types */
                if (this.props.switchboard) {
                  this.props.switchboard.didFinishRender('ObserveModel.didUpdate');
                }
                /* eslint-enable react/prop-types */
                this.resolve();
              });
            }
          }
        });
      }

      componentWillMount() {
        this.modelObserver.setActiveModel(getModel(this.props));
      }

      componentWillReceiveProps(nextProps) {
        this.modelObserver.setActiveModel(getModel(nextProps));
      }

      render() {
        const data = this.state.modelData;
        return _react2.default.createElement(Target, _extends({ ref: c => {
            this.wrapped = c;
          } }, data, this.props));
      }

      getWrappedComponentInstance() {
        return this.wrapped;
      }

      componentWillUnmount() {
        this.mounted = false;
        this.modelObserver.destroy();
      }

      refreshModelData() {
        return new Promise(resolve => {
          this.resolve = resolve;

          const model = getModel(this.props);
          if (model !== this.modelObserver.getActiveModel()) {
            this.modelObserver.setActiveModel(model);
          } else {
            this.modelObserver.refreshModelData();
          }
        });
      }
    }, _class.displayName = `ObserveModelDecorator(${Target.name})`, _temp);


    (0, _hoistNonReactStatics2.default)(Wrapper, Target);

    return Wrapper;
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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