'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _class, _temp, _desc, _value, _class2, _class3, _temp2;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _yubikiri = require('yubikiri');

var _yubikiri2 = _interopRequireDefault(_yubikiri);

var _remotePrController = require('./remote-pr-controller');

var _remotePrController2 = _interopRequireDefault(_remotePrController);

var _githubLoginModel = require('../models/github-login-model');

var _githubLoginModel2 = _interopRequireDefault(_githubLoginModel);

var _observeModel = require('../views/observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _propTypes3 = require('../prop-types');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let RemoteSelector = (_temp = _class = class RemoteSelector extends _react2.default.Component {

  render() {
    var _props = this.props;
    const remotes = _props.remotes,
          currentBranchName = _props.currentBranchName,
          selectRemote = _props.selectRemote;

    return _react2.default.createElement(
      'div',
      { className: 'github-RemoteSelector' },
      _react2.default.createElement(
        'p',
        null,
        'This repository has multiple remotes hosted at GitHub.com. Select a remote to see pull requests associated with the ',
        _react2.default.createElement(
          'strong',
          null,
          currentBranchName
        ),
        ' branch.'
      ),
      _react2.default.createElement(
        'ul',
        null,
        remotes.map(remote => _react2.default.createElement(
          'li',
          { key: remote.getName() },
          _react2.default.createElement(
            'a',
            { href: '#', onClick: e => selectRemote(e, remote) },
            remote.getName(),
            ' (',
            remote.getOwner(),
            '/',
            remote.getRepo(),
            ')'
          )
        ))
      )
    );
  }
}, _class.propTypes = {
  remotes: _propTypes2.default.arrayOf(_propTypes3.RemotePropType).isRequired,
  currentBranchName: _propTypes2.default.string.isRequired,
  selectRemote: _propTypes2.default.func.isRequired
}, _temp);
let GithubTabController = (_class2 = (_temp2 = _class3 = class GithubTabController extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    this.loginModel = _githubLoginModel2.default.get();
  }

  fetchModelData(repo) {
    return (0, _yubikiri2.default)({
      remotes: repo.getRemotes().then(remotes => remotes.filter(remote => remote.isGithubRepo())),
      currentBranch: repo.getCurrentBranch(),
      selectedRemoteName: repo.getConfig('atomGithub.currentRemote'),
      selectedPrUrl: (() => {
        var _ref = _asyncToGenerator(function* (query) {
          const branch = yield query.currentBranch;
          if (!branch.isPresent() || branch.isDetached()) {
            return null;
          }
          return repo.getConfig(`branch.${branch.getName()}.atomPrUrl`);
        });

        return function selectedPrUrl(_x) {
          return _ref.apply(this, arguments);
        };
      })()
    });
  }

  serialize() {
    return {
      deserializer: 'GithubTabControllerStub'
    };
  }

  render() {
    return _react2.default.createElement(
      _observeModel2.default,
      { model: this.props.repository, fetchData: this.fetchModelData },
      data => {
        return data ? this.renderWithData(data) : null;
      }
    );
  }

  renderWithData(_ref2) {
    let remotes = _ref2.remotes,
        currentBranch = _ref2.currentBranch,
        selectedRemoteName = _ref2.selectedRemoteName,
        selectedPrUrl = _ref2.selectedPrUrl;

    if (!this.props.repository.isPresent() || !remotes) {
      return null;
    }

    if (!currentBranch.isPresent() || currentBranch.isDetached()) {
      return null;
    }

    let remote = remotes.find(r => r.getName() === selectedRemoteName);
    let manyRemotesAvailable = false;
    if (!remote && remotes.length === 1) {
      remote = remotes[0];
    } else if (!remote && remotes.length > 1) {
      manyRemotesAvailable = true;
    }

    return _react2.default.createElement(
      'div',
      { ref: c => {
          this.root = c;
        }, className: 'github-GithubTabController' },
      _react2.default.createElement(
        'div',
        { className: 'github-GithubTabController-content' },
        remote && _react2.default.createElement(_remotePrController2.default, {
          host: 'https://api.github.com',
          loginModel: this.loginModel,
          onSelectPr: prUrl => this.handleSelectPrByUrl(prUrl, currentBranch),
          selectedPrUrl: selectedPrUrl,
          onUnpinPr: () => this.handleUnpinPr(currentBranch),
          remote: remote,
          currentBranchName: currentBranch.getName()
        }),
        !remote && manyRemotesAvailable && _react2.default.createElement(RemoteSelector, {
          remotes: remotes,
          currentBranchName: currentBranch.getName(),
          selectRemote: this.handleRemoteSelect
        }),
        !remote && !manyRemotesAvailable && this.renderNoRemotes()
      )
    );
  }

  handleSelectPrByUrl(prUrl, currentBranch) {
    return this.props.repository.setConfig(`branch.${currentBranch.getName()}.atomPrUrl`, prUrl);
  }

  handleUnpinPr(currentBranch) {
    return this.props.repository.unsetConfig(`branch.${currentBranch.getName()}.atomPrUrl`);
  }

  getTitle() {
    return 'GitHub (preview)';
  }

  getIconName() {
    return 'octoface';
  }

  getDefaultLocation() {
    return 'right';
  }

  getPreferredWidth() {
    return 400;
  }

  getURI() {
    return 'atom-github://stub-uri/github-tab-controller';
  }

  getWorkingDirectory() {
    return this.props.repository.getWorkingDirectoryPath();
  }

  renderNoRemotes() {
    return _react2.default.createElement(
      'div',
      { className: 'github-GithubTabController-no-remotes' },
      'This repository does not have any remotes hosted at GitHub.com.'
    );
  }

  handleRemoteSelect(e, remote) {
    e.preventDefault();
    this.props.repository.setConfig('atomGithub.currentRemote', remote.getName());
  }

  hasFocus() {
    return this.root && this.root.contains(document.activeElement);
  }

  restoreFocus() {
    // No-op
  }
}, _class3.propTypes = {
  repository: _propTypes2.default.object
}, _temp2), (_applyDecoratedDescriptor(_class2.prototype, 'handleSelectPrByUrl', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class2.prototype, 'handleSelectPrByUrl'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'handleUnpinPr', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class2.prototype, 'handleUnpinPr'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'handleRemoteSelect', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class2.prototype, 'handleRemoteSelect'), _class2.prototype)), _class2);
exports.default = GithubTabController;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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