'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class, _class2, _temp; /** @jsx etch.dom */
/* eslint react/no-unknown-property: "off" */

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _coreDecorators = require('core-decorators');

var _commitView = require('../views/commit-view');

var _commitView2 = _interopRequireDefault(_commitView);

var _modelStateRegistry = require('../models/model-state-registry');

var _modelStateRegistry2 = _interopRequireDefault(_modelStateRegistry);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let CommitViewController = (_class = (_temp = _class2 = class CommitViewController {

  constructor(props) {
    var _this = this;

    this.props = props;

    this.repoStateRegistry = new _modelStateRegistry2.default(CommitViewController, {
      initialModel: props.repository,
      save: () => {
        return {
          regularCommitMessage: this.regularCommitMessage,
          amendingCommitMessage: this.amendingCommitMessage
        };
      },
      restore: function () {
        let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        _this.regularCommitMessage = state.regularCommitMessage || '';
        _this.amendingCommitMessage = state.amendingCommitMessage || '';
      }
    });

    if (this.props.isMerging && this.props.mergeMessage) {
      this.regularCommitMessage = this.props.mergeMessage;
    }
    _etch2.default.initialize(this);
  }

  update(props) {
    const wasAmending = this.props.isAmending;
    const wasMerging = this.props.isMerging;
    this.props = _extends({}, this.props, props);
    this.repoStateRegistry.setModel(this.props.repository);
    // If we just checked the "amend" box and we don't yet have a saved amending message,
    // initialize it to be the message from the last commit.
    if (!wasAmending && this.props.isAmending && !this.amendingCommitMessage && this.props.lastCommit.isPresent()) {
      this.amendingCommitMessage = props.lastCommit.getMessage();
    } else if (!wasMerging && this.props.isMerging && !this.regularCommitMessage) {
      this.regularCommitMessage = this.props.mergeMessage || '';
    }
    return _etch2.default.update(this);
  }

  render() {
    const message = this.getCommitMessage();

    return _etch2.default.dom(_commitView2.default, {
      ref: 'commitView',
      stagedChangesExist: this.props.stagedChangesExist,
      mergeConflictsExist: this.props.mergeConflictsExist,
      prepareToCommit: this.props.prepareToCommit,
      commit: this.commit,
      setAmending: this.props.setAmending,
      abortMerge: this.props.abortMerge,
      branchName: this.props.branchName,
      commandRegistry: this.props.commandRegistry,
      maximumCharacterLimit: 72,
      message: message,
      isMerging: this.props.isMerging,
      isAmending: this.props.isAmending,
      lastCommit: this.props.lastCommit,
      onChangeMessage: this.handleMessageChange,
      didMoveUpOnFirstLine: this.props.didMoveUpOnFirstLine
    });
  }

  commit(message) {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      try {
        yield _this2.props.commit(message);
        _this2.regularCommitMessage = '';
        _this2.amendingCommitMessage = '';
        _etch2.default.update(_this2);
      } catch (e) {
        _this2.props.notificationManager.addError('Unable to commit', {
          dismissable: true,
          description: `<pre>${e.stdErr || e.stack}</pre>`
        });
      }
    })();
  }

  getCommitMessage() {
    const message = this.props.isAmending ? this.amendingCommitMessage : this.regularCommitMessage;
    return message || '';
  }

  handleMessageChange(newMessage) {
    if (this.props.isAmending) {
      this.amendingCommitMessage = newMessage;
    } else {
      this.regularCommitMessage = newMessage;
    }
    _etch2.default.update(this);
  }

  rememberFocus(event) {
    return this.refs.commitView.rememberFocus(event);
  }

  setFocus(focus) {
    return this.refs.commitView.setFocus(focus);
  }

  hasFocus() {
    return this.element.contains(document.activeElement);
  }

  destroy() {
    this.repoStateRegistry.save();
    return _etch2.default.destroy(this);
  }
}, _class2.focus = _extends({}, _commitView2.default.focus), _temp), (_applyDecoratedDescriptor(_class.prototype, 'commit', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'commit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handleMessageChange', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleMessageChange'), _class.prototype)), _class);
exports.default = CommitViewController;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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