'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = RelayRootContainer;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * This is a copy of `RelayRootContainer` from the Relay
 * codebase, but with an optional `environment` prop
 * that can be used instead of the singleton `RelayStore`.
 */
function RelayRootContainer(_ref) {
  let Component = _ref.Component,
      forceFetch = _ref.forceFetch,
      onReadyStateChange = _ref.onReadyStateChange,
      renderFailure = _ref.renderFailure,
      renderFetched = _ref.renderFetched,
      renderLoading = _ref.renderLoading,
      route = _ref.route,
      shouldFetch = _ref.shouldFetch,
      environment = _ref.environment;

  return _react2.default.createElement(_reactRelay2.default.Renderer, {
    Container: Component,
    forceFetch: forceFetch,
    onReadyStateChange: onReadyStateChange,
    queryConfig: route,
    environment: environment || _reactRelay2.default.Store,
    shouldFetch: shouldFetch,
    render: (_ref2) => {
      let done = _ref2.done,
          error = _ref2.error,
          props = _ref2.props,
          retry = _ref2.retry,
          stale = _ref2.stale;

      if (error) {
        if (renderFailure) {
          return renderFailure(error, retry);
        }
      } else if (props) {
        if (renderFetched) {
          return renderFetched(props, { done, stale });
        } else {
          return _react2.default.createElement(Component, props);
        }
      } else {
        if (renderLoading) {
          return renderLoading();
        }
      }
      return undefined;
    }
  });
}

RelayRootContainer.propTypes = {
  Component: _reactRelay2.default.PropTypes.Container,
  forceFetch: _propTypes2.default.bool,
  onReadyStateChange: _propTypes2.default.func,
  renderFailure: _propTypes2.default.func,
  renderFetched: _propTypes2.default.func,
  renderLoading: _propTypes2.default.func,
  route: _reactRelay2.default.PropTypes.QueryConfig.isRequired,
  shouldFetch: _propTypes2.default.bool,
  environment: _propTypes2.default.object
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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