'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _os = require('os');

var _os2 = _interopRequireDefault(_os);

var _helpers = require('./helpers');

var _asyncQueue = require('./async-queue');

var _asyncQueue2 = _interopRequireDefault(_asyncQueue);

var _gitShellOutStrategy = require('./git-shell-out-strategy');

var _gitShellOutStrategy2 = _interopRequireDefault(_gitShellOutStrategy);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  create(workingDir) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    return this.withStrategies([_gitShellOutStrategy2.default])(workingDir, options);
  },

  withStrategies(strategies) {
    return function createForStrategies(workingDir) {
      let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      const parallelism = options.parallelism || Math.max(3, _os2.default.cpus().length);
      const commandQueue = new _asyncQueue2.default({ parallelism });
      const strategyOptions = _extends({}, options, { queue: commandQueue });

      const strategyInstances = strategies.map(Strategy => new Strategy(workingDir, strategyOptions));
      return (0, _helpers.firstImplementer)(...strategyInstances);
    };
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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