Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _os = require('os');

var _os2 = _interopRequireDefault(_os);

var _stackTrace = require('stack-trace');

var _stackTrace2 = _interopRequireDefault(_stackTrace);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var API_KEY = '7ddca14cb60cbd1cd12d1b252473b076';
var LIB_VERSION = require('../package.json')['version'];
var StackTraceCache = new WeakMap();

var Reporter = (function () {
  function Reporter() {
    var params = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

    _classCallCheck(this, Reporter);

    this.request = params.request || window.fetch;
    this.alwaysReport = params.hasOwnProperty('alwaysReport') ? params.alwaysReport : false;
    this.reportPreviousErrors = params.hasOwnProperty('reportPreviousErrors') ? params.reportPreviousErrors : true;
    this.reportedErrors = [];
    this.reportedAssertionFailures = [];
  }

  _createClass(Reporter, [{
    key: 'buildNotificationJSON',
    value: function buildNotificationJSON(error, params) {
      return {
        apiKey: API_KEY,
        notifier: {
          name: 'Atom',
          version: LIB_VERSION,
          url: 'https://www.atom.io'
        },
        events: [{
          payloadVersion: "2",
          exceptions: [this.buildExceptionJSON(error, params.projectRoot)],
          severity: params.severity,
          user: {
            id: params.userId
          },
          app: {
            version: params.appVersion,
            releaseStage: params.releaseStage
          },
          device: {
            osVersion: params.osVersion
          },
          metaData: error.metadata
        }]
      };
    }
  }, {
    key: 'buildExceptionJSON',
    value: function buildExceptionJSON(error, projectRoot) {
      return {
        errorClass: error.constructor.name,
        message: error.message,
        stacktrace: this.buildStackTraceJSON(error, projectRoot)
      };
    }
  }, {
    key: 'buildStackTraceJSON',
    value: function buildStackTraceJSON(error, projectRoot) {
      var _this = this;

      return this.parseStackTrace(error).map(function (callSite) {
        return {
          file: _this.normalizePath(callSite.getFileName()),
          method: callSite.getMethodName() || callSite.getFunctionName() || "none",
          lineNumber: callSite.getLineNumber(),
          columnNumber: callSite.getColumnNumber(),
          inProject: !/node_modules/.test(callSite.getFileName())
        };
      });
    }
  }, {
    key: 'normalizePath',
    value: function normalizePath(path) {
      return path.replace('file:///', '') // Randomly inserted file url protocols
      .replace(/[/]/g, '\\') // Temp switch for Windows home matching
      .replace(_fsPlus2['default'].getHomeDirectory(), '~') // Remove users home dir for apm-dev'ed packages
      .replace(/\\/g, '/') // Switch \ back to / for everyone
      .replace(/.*(\/(app\.asar|packages\/).*)/, '$1'); // Remove everything before app.asar or pacakges
    }
  }, {
    key: 'getDefaultNotificationParams',
    value: function getDefaultNotificationParams() {
      return {
        userId: atom.config.get('exception-reporting.userId'),
        appVersion: atom.getVersion(),
        releaseStage: this.getReleaseChannel(atom.getVersion()),
        projectRoot: atom.getLoadSettings().resourcePath,
        osVersion: _os2['default'].platform() + '-' + _os2['default'].arch() + '-' + _os2['default'].release()
      };
    }
  }, {
    key: 'getReleaseChannel',
    value: function getReleaseChannel(version) {
      return version.indexOf('beta') > -1 ? 'beta' : version.indexOf('dev') > -1 ? 'dev' : 'stable';
    }
  }, {
    key: 'performRequest',
    value: function performRequest(json) {
      this.request.call(null, 'https://notify.bugsnag.com', {
        method: 'POST',
        headers: new Headers({ 'Content-Type': 'application/json' }),
        body: JSON.stringify(json)
      });
    }
  }, {
    key: 'shouldReport',
    value: function shouldReport(error) {
      if (this.alwaysReport) return true; // Used in specs
      if (atom.config.get('core.telemetryConsent') !== 'limited') return false;
      if (atom.inDevMode()) return false;

      var topFrame = this.parseStackTrace(error)[0];
      return topFrame && topFrame.getFileName() && topFrame.getFileName().indexOf(atom.getLoadSettings().resourcePath) === 0;
    }
  }, {
    key: 'parseStackTrace',
    value: function parseStackTrace(error) {
      var callSites = StackTraceCache.get(error);
      if (callSites) {
        return callSites;
      } else {
        callSites = _stackTrace2['default'].parse(error);
        StackTraceCache.set(error, callSites);
        return callSites;
      }
    }
  }, {
    key: 'requestPrivateMetadataConsent',
    value: function requestPrivateMetadataConsent(error, message, reportFn) {
      var notification = undefined,
          dismissSubscription = undefined;

      function reportWithoutPrivateMetadata() {
        if (dismissSubscription) {
          dismissSubscription.dispose();
        }
        delete error.privateMetadata;
        delete error.privateMetadataDescription;
        reportFn(error);
        if (notification) {
          notification.dismiss();
        }
      }

      function reportWithPrivateMetadata() {
        if (error.metadata == null) {
          error.metadata = {};
        }
        for (var key in error.privateMetadata) {
          var value = error.privateMetadata[key];
          error.metadata[key] = value;
        }
        reportWithoutPrivateMetadata();
      }

      var name = error.privateMetadataRequestName;
      if (name != null) {
        if (localStorage.getItem('private-metadata-request:' + name)) {
          return reportWithoutPrivateMetadata(error);
        } else {
          localStorage.setItem('private-metadata-request:' + name, true);
        }
      }

      notification = atom.notifications.addInfo(message, {
        detail: error.privateMetadataDescription,
        description: "Are you willing to submit this information to a private server for debugging purposes?",
        dismissable: true,
        buttons: [{
          text: "No",
          onDidClick: reportWithoutPrivateMetadata
        }, {
          text: "Yes, Submit for Debugging",
          onDidClick: reportWithPrivateMetadata
        }]
      });

      dismissSubscription = notification.onDidDismiss(reportWithoutPrivateMetadata);
    }
  }, {
    key: 'addPackageMetadata',
    value: function addPackageMetadata(error) {
      var activePackages = atom.packages.getActivePackages();
      if (activePackages.length > 0) {
        var userPackages = {};
        var bundledPackages = {};
        for (var pack of atom.packages.getActivePackages()) {
          if (/\/app\.asar\//.test(pack.path)) {
            bundledPackages[pack.name] = pack.metadata.version;
          } else {
            userPackages[pack.name] = pack.metadata.version;
          }
        }

        if (error.metadata == null) {
          error.metadata = {};
        }
        error.metadata.bundledPackages = bundledPackages;
        error.metadata.userPackages = userPackages;
      }
    }
  }, {
    key: 'addPreviousErrorsMetadata',
    value: function addPreviousErrorsMetadata(error) {
      if (!this.reportPreviousErrors) return;
      if (!error.metadata) error.metadata = {};
      error.metadata.previousErrors = this.reportedErrors.map(function (error) {
        return error.message;
      });
      error.metadata.previousAssertionFailures = this.reportedAssertionFailures.map(function (error) {
        return error.message;
      });
    }
  }, {
    key: 'reportUncaughtException',
    value: function reportUncaughtException(error) {
      var _this2 = this;

      if (!this.shouldReport(error)) return;

      this.addPackageMetadata(error);
      this.addPreviousErrorsMetadata(error);

      if (error.privateMetadata != null && error.privateMetadataDescription != null) {
        this.requestPrivateMetadataConsent(error, "The Atom team would like to collect the following information to resolve this error:", function (error) {
          return _this2.reportUncaughtException(error);
        });
        return;
      }

      var params = this.getDefaultNotificationParams();
      params.severity = "error";
      this.performRequest(this.buildNotificationJSON(error, params));
      this.reportedErrors.push(error);
    }
  }, {
    key: 'reportFailedAssertion',
    value: function reportFailedAssertion(error) {
      var _this3 = this;

      if (!this.shouldReport(error)) return;

      this.addPackageMetadata(error);
      this.addPreviousErrorsMetadata(error);

      if (error.privateMetadata != null && error.privateMetadataDescription != null) {
        this.requestPrivateMetadataConsent(error, "The Atom team would like to collect some information to resolve an unexpected condition:", function (error) {
          return _this3.reportFailedAssertion(error);
        });
        return;
      }

      var params = this.getDefaultNotificationParams();
      params.severity = "warning";
      this.performRequest(this.buildNotificationJSON(error, params));
      this.reportedAssertionFailures.push(error);
    }

    // Used in specs
  }, {
    key: 'setRequestFunction',
    value: function setRequestFunction(requestFunction) {
      this.request = requestFunction;
    }
  }]);

  return Reporter;
})();

exports['default'] = Reporter;

Reporter.API_KEY = API_KEY;
Reporter.LIB_VERSION = LIB_VERSION;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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