(function() {
  var EncodingListView, EncodingStatusView, commandSubscription, encodingListView, encodingStatusView, encodings, toggleEncodingListView;

  EncodingListView = require('./encoding-list-view');

  EncodingStatusView = require('./encoding-status-view');

  encodingListView = null;

  encodingStatusView = null;

  commandSubscription = null;

  module.exports = {
    activate: function() {
      return commandSubscription = atom.commands.add('atom-text-editor', 'encoding-selector:show', toggleEncodingListView);
    },
    deactivate: function() {
      if (commandSubscription != null) {
        commandSubscription.dispose();
      }
      commandSubscription = null;
      if (encodingStatusView != null) {
        encodingStatusView.destroy();
      }
      encodingStatusView = null;
      if (encodingListView != null) {
        encodingListView.destroy();
      }
      return encodingListView = null;
    },
    consumeStatusBar: function(statusBar) {
      encodingStatusView = new EncodingStatusView(statusBar, encodings);
      return encodingStatusView.attach();
    }
  };

  toggleEncodingListView = function() {
    if (encodingListView == null) {
      encodingListView = new EncodingListView(encodings);
    }
    return encodingListView.toggle();
  };

  encodings = {
    utf8: {
      list: 'UTF-8',
      status: 'UTF-8'
    },
    utf16le: {
      list: 'UTF-16 LE',
      status: 'UTF-16 LE'
    },
    utf16be: {
      list: 'UTF-16 BE',
      status: 'UTF-16 BE'
    },
    windows1252: {
      list: 'Western (Windows 1252)',
      status: 'Windows 1252'
    },
    iso88591: {
      list: 'Western (ISO 8859-1)',
      status: 'ISO 8859-1'
    },
    iso88593: {
      list: 'Western (ISO 8859-3)',
      status: 'ISO 8859-3'
    },
    iso885915: {
      list: 'Western (ISO 8859-15)',
      status: 'ISO 8859-15'
    },
    macroman: {
      list: 'Western (Mac Roman)',
      status: 'Mac Roman'
    },
    cp437: {
      list: 'DOS (CP 437)',
      status: 'CP437'
    },
    cp850: {
      list: 'DOS (CP 850)',
      status: 'CP850'
    },
    windows1256: {
      list: 'Arabic (Windows 1256)',
      status: 'Windows 1256'
    },
    iso88596: {
      list: 'Arabic (ISO 8859-6)',
      status: 'ISO 8859-6'
    },
    windows1257: {
      list: 'Baltic (Windows 1257)',
      status: 'Windows 1257'
    },
    iso88594: {
      list: 'Baltic (ISO 8859-4)',
      status: 'ISO 8859-4'
    },
    iso885914: {
      list: 'Celtic (ISO 8859-14)',
      status: 'ISO 8859-14'
    },
    windows1250: {
      list: 'Central European (Windows 1250)',
      status: 'Windows 1250'
    },
    iso88592: {
      list: 'Central European (ISO 8859-2)',
      status: 'ISO 8859-2'
    },
    windows1251: {
      list: 'Cyrillic (Windows 1251)',
      status: 'Windows 1251'
    },
    cp866: {
      list: 'Cyrillic (CP 866)',
      status: 'CP 866'
    },
    iso88595: {
      list: 'Cyrillic (ISO 8859-5)',
      status: 'ISO 8859-5'
    },
    koi8r: {
      list: 'Cyrillic (KOI8-R)',
      status: 'KOI8-R'
    },
    koi8u: {
      list: 'Cyrillic (KOI8-U)',
      status: 'KOI8-U'
    },
    iso885913: {
      list: 'Estonian (ISO 8859-13)',
      status: 'ISO 8859-13'
    },
    windows1253: {
      list: 'Greek (Windows 1253)',
      status: 'Windows 1253'
    },
    iso88597: {
      list: 'Greek (ISO 8859-7)',
      status: 'ISO 8859-7'
    },
    windows1255: {
      list: 'Hebrew (Windows 1255)',
      status: 'Windows 1255'
    },
    iso88598: {
      list: 'Hebrew (ISO 8859-8)',
      status: 'ISO 8859-8'
    },
    iso885910: {
      list: 'Nordic (ISO 8859-10)',
      status: 'ISO 8859-10'
    },
    iso885916: {
      list: 'Romanian (ISO 8859-16)',
      status: 'ISO 8859-16'
    },
    windows1254: {
      list: 'Turkish (Windows 1254)',
      status: 'Windows 1254'
    },
    iso88599: {
      list: 'Turkish (ISO 8859-9)',
      status: 'ISO 8859-9'
    },
    windows1258: {
      list: 'Vietnamese (Windows 1254)',
      status: 'Windows 1254'
    },
    gbk: {
      list: 'Chinese (GBK)',
      status: 'GBK'
    },
    gb18030: {
      list: 'Chinese (GB18030)',
      status: 'GB18030'
    },
    cp950: {
      list: 'Traditional Chinese (Big5)',
      status: 'Big5'
    },
    big5hkscs: {
      list: 'Traditional Chinese (Big5-HKSCS)',
      status: 'Big5-HKSCS'
    },
    shiftjis: {
      list: 'Japanese (Shift JIS)',
      status: 'Shift JIS'
    },
    cp932: {
      list: 'Japanese (CP 932)',
      status: 'CP 932'
    },
    eucjp: {
      list: 'Japanese (EUC-JP)',
      status: 'EUC-JP'
    },
    euckr: {
      list: 'Korean (EUC-KR)',
      status: 'EUC-KR'
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
