(function() {
  var UIWatcher;

  UIWatcher = require('./ui-watcher');

  module.exports = {
    commandDisposable: null,
    activate: function(state) {
      var activatedDisposable, uiWatcher;
      if (!(atom.inDevMode() && !atom.inSpecMode())) {
        return;
      }
      uiWatcher = null;
      activatedDisposable = atom.packages.onDidActivateInitialPackages(function() {
        uiWatcher = new UIWatcher({
          themeManager: atom.themes
        });
        return activatedDisposable.dispose();
      });
      return this.commandDisposable = atom.commands.add('atom-workspace', 'dev-live-reload:reload-all', function() {
        return uiWatcher != null ? uiWatcher.reloadAll() : void 0;
      });
    },
    deactivate: function() {
      var ref;
      return (ref = this.commandDisposable) != null ? ref.dispose() : void 0;
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2hvbWUvYW5kcmVpL2F0b20tMS4xOS4yL291dC9hcHAvbm9kZV9tb2R1bGVzL2Rldi1saXZlLXJlbG9hZC9saWIvbWFpbi5jb2ZmZWUiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQSxNQUFBOztFQUFBLFNBQUEsR0FBWSxPQUFBLENBQVEsY0FBUjs7RUFFWixNQUFNLENBQUMsT0FBUCxHQUNFO0lBQUEsaUJBQUEsRUFBbUIsSUFBbkI7SUFDQSxRQUFBLEVBQVUsU0FBQyxLQUFEO0FBQ1IsVUFBQTtNQUFBLElBQUEsQ0FBQSxDQUFjLElBQUksQ0FBQyxTQUFMLENBQUEsQ0FBQSxJQUFxQixDQUFJLElBQUksQ0FBQyxVQUFMLENBQUEsQ0FBdkMsQ0FBQTtBQUFBLGVBQUE7O01BRUEsU0FBQSxHQUFZO01BQ1osbUJBQUEsR0FBc0IsSUFBSSxDQUFDLFFBQVEsQ0FBQyw0QkFBZCxDQUEyQyxTQUFBO1FBQy9ELFNBQUEsR0FBZ0IsSUFBQSxTQUFBLENBQVU7VUFBQSxZQUFBLEVBQWMsSUFBSSxDQUFDLE1BQW5CO1NBQVY7ZUFDaEIsbUJBQW1CLENBQUMsT0FBcEIsQ0FBQTtNQUYrRCxDQUEzQzthQUl0QixJQUFDLENBQUEsaUJBQUQsR0FBcUIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFkLENBQWtCLGdCQUFsQixFQUFvQyw0QkFBcEMsRUFBa0UsU0FBQTttQ0FDckYsU0FBUyxDQUFFLFNBQVgsQ0FBQTtNQURxRixDQUFsRTtJQVJiLENBRFY7SUFZQSxVQUFBLEVBQVksU0FBQTtBQUNWLFVBQUE7eURBQWtCLENBQUUsT0FBcEIsQ0FBQTtJQURVLENBWlo7O0FBSEYiLCJzb3VyY2VzQ29udGVudCI6WyJVSVdhdGNoZXIgPSByZXF1aXJlICcuL3VpLXdhdGNoZXInXG5cbm1vZHVsZS5leHBvcnRzID1cbiAgY29tbWFuZERpc3Bvc2FibGU6IG51bGxcbiAgYWN0aXZhdGU6IChzdGF0ZSkgLT5cbiAgICByZXR1cm4gdW5sZXNzIGF0b20uaW5EZXZNb2RlKCkgYW5kIG5vdCBhdG9tLmluU3BlY01vZGUoKVxuXG4gICAgdWlXYXRjaGVyID0gbnVsbFxuICAgIGFjdGl2YXRlZERpc3Bvc2FibGUgPSBhdG9tLnBhY2thZ2VzLm9uRGlkQWN0aXZhdGVJbml0aWFsUGFja2FnZXMgLT5cbiAgICAgIHVpV2F0Y2hlciA9IG5ldyBVSVdhdGNoZXIodGhlbWVNYW5hZ2VyOiBhdG9tLnRoZW1lcylcbiAgICAgIGFjdGl2YXRlZERpc3Bvc2FibGUuZGlzcG9zZSgpXG5cbiAgICBAY29tbWFuZERpc3Bvc2FibGUgPSBhdG9tLmNvbW1hbmRzLmFkZCAnYXRvbS13b3Jrc3BhY2UnLCAnZGV2LWxpdmUtcmVsb2FkOnJlbG9hZC1hbGwnLCAtPlxuICAgICAgdWlXYXRjaGVyPy5yZWxvYWRBbGwoKVxuXG4gIGRlYWN0aXZhdGU6IC0+XG4gICAgQGNvbW1hbmREaXNwb3NhYmxlPy5kaXNwb3NlKClcbiJdfQ==
