Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var _underscorePlus = require('underscore-plus');

var _fuzzaldrin = require('fuzzaldrin');

var _fuzzaldrin2 = _interopRequireDefault(_fuzzaldrin);

var _fuzzaldrinPlus = require('fuzzaldrin-plus');

var _fuzzaldrinPlus2 = _interopRequireDefault(_fuzzaldrinPlus);

var CommandPaletteView = (function () {
  function CommandPaletteView() {
    var _this = this;

    _classCallCheck(this, CommandPaletteView);

    this.keyBindingsForActiveElement = [];
    this.commandsForActiveElement = [];
    this.selectListView = new _atomSelectList2['default']({
      items: this.commandsForActiveElement,
      emptyMessage: 'No matches found',
      filterKeyForItem: function filterKeyForItem(item) {
        return item.displayName;
      },
      elementForItem: function elementForItem(_ref) {
        var name = _ref.name;
        var displayName = _ref.displayName;

        var li = document.createElement('li');
        li.classList.add('event');
        li.dataset.eventName = name;

        var div = document.createElement('div');
        div.classList.add('pull-right');
        for (var keyBinding of _this.keyBindingsForActiveElement) {
          if (keyBinding.command === name) {
            var kbd = document.createElement('kbd');
            kbd.classList.add('key-binding');
            kbd.textContent = (0, _underscorePlus.humanizeKeystroke)(keyBinding.keystrokes);
            div.appendChild(kbd);
          }
        }
        li.appendChild(div);

        var span = document.createElement('span');
        span.title = name;

        var query = _this.selectListView.getQuery();
        var matches = _this.useAlternateScoring ? _fuzzaldrinPlus2['default'].match(displayName, query) : _fuzzaldrin2['default'].match(displayName, query);
        var matchedChars = [];
        var lastIndex = 0;
        for (var matchIndex of matches) {
          var _unmatched = displayName.substring(lastIndex, matchIndex);
          if (_unmatched) {
            if (matchedChars.length > 0) {
              var matchSpan = document.createElement('span');
              matchSpan.classList.add('character-match');
              matchSpan.textContent = matchedChars.join('');
              span.appendChild(matchSpan);
              matchedChars = [];
            }

            span.appendChild(document.createTextNode(_unmatched));
          }

          matchedChars.push(displayName[matchIndex]);
          lastIndex = matchIndex + 1;
        }

        if (matchedChars.length > 0) {
          var matchSpan = document.createElement('span');
          matchSpan.classList.add('character-match');
          matchSpan.textContent = matchedChars.join('');
          span.appendChild(matchSpan);
        }

        var unmatched = displayName.substring(lastIndex);
        if (unmatched) {
          span.appendChild(document.createTextNode(unmatched));
        }

        li.appendChild(span);
        return li;
      },
      didConfirmSelection: function didConfirmSelection(keyBinding) {
        _this.hide();
        var event = new CustomEvent(keyBinding.name, { bubbles: true, cancelable: true });
        _this.activeElement.dispatchEvent(event);
      },
      didCancelSelection: function didCancelSelection() {
        _this.hide();
      }
    });
    this.selectListView.element.classList.add('command-palette');
  }

  _createClass(CommandPaletteView, [{
    key: 'destroy',
    value: _asyncToGenerator(function* () {
      yield this.selectListView.destroy();
    })
  }, {
    key: 'toggle',
    value: function toggle() {
      if (this.panel && this.panel.isVisible()) {
        this.hide();
        return Promise.resolve();
      } else {
        return this.show();
      }
    }
  }, {
    key: 'show',
    value: _asyncToGenerator(function* () {
      if (!this.panel) {
        this.panel = atom.workspace.addModalPanel({ item: this.selectListView });
      }

      if (!this.preserveLastSearch) {
        this.selectListView.reset();
      } else {
        this.selectListView.refs.queryEditor.selectAll();
      }

      this.activeElement = document.activeElement === document.body ? atom.views.getView(atom.workspace) : document.activeElement;
      this.keyBindingsForActiveElement = atom.keymaps.findKeyBindings({ target: this.activeElement });
      this.commandsForActiveElement = atom.commands.findCommands({ target: this.activeElement });
      this.commandsForActiveElement.sort(function (a, b) {
        return a.displayName.localeCompare(b.displayName);
      });
      yield this.selectListView.update({ items: this.commandsForActiveElement });

      this.previouslyFocusedElement = document.activeElement;
      this.panel.show();
      this.selectListView.focus();
    })
  }, {
    key: 'hide',
    value: function hide() {
      this.panel.hide();
      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'update',
    value: _asyncToGenerator(function* (props) {
      if (props.hasOwnProperty('preserveLastSearch')) {
        this.preserveLastSearch = props.preserveLastSearch;
      }

      if (props.hasOwnProperty('useAlternateScoring')) {
        this.useAlternateScoring = props.useAlternateScoring;
        if (this.useAlternateScoring) {
          yield this.selectListView.update({
            filter: function filter(items, query) {
              return query ? _fuzzaldrinPlus2['default'].filter(items, query, { key: 'displayName' }) : items;
            }
          });
        } else {
          yield this.selectListView.update({ filter: null });
        }
      }
    })
  }]);

  return CommandPaletteView;
})();

exports['default'] = CommandPaletteView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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