(function() {
  var SnippetsProvider, ascendingPrefixComparator, firstCharsEqual;

  module.exports = SnippetsProvider = (function() {
    SnippetsProvider.prototype.selector = '*';

    SnippetsProvider.prototype.disableForSelector = '.comment, .string';

    SnippetsProvider.prototype.inclusionPriority = 1;

    SnippetsProvider.prototype.suggestionPriority = 2;

    SnippetsProvider.prototype.filterSuggestions = true;

    function SnippetsProvider() {
      this.showIcon = atom.config.get('autocomplete-plus.defaultProvider') === 'Symbol';
      this.snippetsSource = {
        snippetsForScopes: function(scopeDescriptor) {
          return atom.config.get('snippets', {
            scope: scopeDescriptor
          });
        }
      };
    }

    SnippetsProvider.prototype.setSnippetsSource = function(snippetsSource) {
      if (typeof (snippetsSource != null ? snippetsSource.snippetsForScopes : void 0) === "function") {
        return this.snippetsSource = snippetsSource;
      }
    };

    SnippetsProvider.prototype.getSuggestions = function(arg) {
      var prefix, scopeDescriptor, scopeSnippets;
      scopeDescriptor = arg.scopeDescriptor, prefix = arg.prefix;
      if (!(prefix != null ? prefix.length : void 0)) {
        return;
      }
      scopeSnippets = this.snippetsSource.snippetsForScopes(scopeDescriptor);
      return this.findSuggestionsForPrefix(scopeSnippets, prefix);
    };

    SnippetsProvider.prototype.findSuggestionsForPrefix = function(snippets, prefix) {
      var snippet, snippetPrefix, suggestions;
      if (snippets == null) {
        return [];
      }
      suggestions = [];
      for (snippetPrefix in snippets) {
        snippet = snippets[snippetPrefix];
        if (!(snippet && snippetPrefix && prefix && firstCharsEqual(snippetPrefix, prefix))) {
          continue;
        }
        suggestions.push({
          iconHTML: this.showIcon ? void 0 : false,
          type: 'snippet',
          text: snippet.prefix,
          replacementPrefix: prefix,
          rightLabel: snippet.name,
          rightLabelHTML: snippet.rightLabelHTML,
          leftLabel: snippet.leftLabel,
          leftLabelHTML: snippet.leftLabelHTML,
          description: snippet.description,
          descriptionMoreURL: snippet.descriptionMoreURL
        });
      }
      suggestions.sort(ascendingPrefixComparator);
      return suggestions;
    };

    SnippetsProvider.prototype.onDidInsertSuggestion = function(arg) {
      var editor;
      editor = arg.editor;
      return atom.commands.dispatch(atom.views.getView(editor), 'snippets:expand');
    };

    return SnippetsProvider;

  })();

  ascendingPrefixComparator = function(a, b) {
    return a.text.localeCompare(b.text);
  };

  firstCharsEqual = function(str1, str2) {
    return str1[0].toLowerCase() === str2[0].toLowerCase();
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
