(function() {
  var AttributesURL, fetch, filterExcerpt, fs, mdnHTMLURL, mdnJSONAPI, path, request;

  path = require('path');

  fs = require('fs');

  request = require('request');

  mdnHTMLURL = 'https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes';

  mdnJSONAPI = 'https://developer.mozilla.org/en-US/search.json?topic=html&highlight=false';

  AttributesURL = 'https://raw.githubusercontent.com/adobe/brackets/master/src/extensions/default/HTMLCodeHints/HtmlAttributes.json';

  fetch = function() {
    var attributesPromise;
    attributesPromise = new Promise(function(resolve) {
      return request({
        json: true,
        url: AttributesURL
      }, function(error, response, attributes) {
        if (error != null) {
          console.error(error.message);
          resolve(null);
        }
        if (response.statusCode !== 200) {
          console.error("Request for HtmlAttributes.json failed: " + response.statusCode);
          resolve(null);
        }
        return resolve(attributes);
      });
    });
    return attributesPromise.then(function(attributes) {
      var MAX, attribute, docs, options, queue, running;
      if (attributes == null) {
        return;
      }
      MAX = 10;
      queue = [];
      for (attribute in attributes) {
        options = attributes[attribute];
        if (options.global && !attribute.startsWith('aria') && !attribute.startsWith('on') && attribute !== 'role') {
          queue.push(attribute);
        }
      }
      running = [];
      docs = {};
      return new Promise(function(resolve) {
        var checkEnd, handleRequest, i, ref, removeRunning, run, runNext;
        checkEnd = function() {
          if (queue.length === 0 && running.length === 0) {
            return resolve(docs);
          }
        };
        removeRunning = function(attributeName) {
          var index;
          index = running.indexOf(attributeName);
          if (index > -1) {
            return running.splice(index, 1);
          }
        };
        runNext = function() {
          var attributeName;
          checkEnd();
          if (queue.length !== 0) {
            attributeName = queue.pop();
            running.push(attributeName);
            return run(attributeName);
          }
        };
        run = function(attributeName) {
          var url;
          url = mdnJSONAPI + "&q=" + attributeName;
          return request({
            json: true,
            url: url
          }, function(error, response, searchResults) {
            if ((error == null) && response.statusCode === 200) {
              handleRequest(attributeName, searchResults);
            } else {
              console.error("Req failed " + url + "; " + response.statusCode + ", " + error);
            }
            removeRunning(attributeName);
            return runNext();
          });
        };
        handleRequest = function(attributeName, searchResults) {
          var doc, i, len, ref;
          if (searchResults.documents != null) {
            ref = searchResults.documents;
            for (i = 0, len = ref.length; i < len; i++) {
              doc = ref[i];
              if (doc.url === (mdnHTMLURL + "/" + attributeName)) {
                docs[attributeName] = filterExcerpt(attributeName, doc.excerpt);
                return;
              }
            }
          }
          return console.log("Could not find documentation for " + attributeName);
        };
        for (i = 0, ref = MAX; 0 <= ref ? i <= ref : i >= ref; 0 <= ref ? i++ : i--) {
          runNext();
        }
      });
    });
  };

  filterExcerpt = function(attributeName, excerpt) {
    var beginningPattern, periodIndex;
    beginningPattern = /^the [a-z-]+ global attribute (is )?(\w+)/i;
    excerpt = excerpt.replace(beginningPattern, function(match) {
      var firstWord, matches;
      matches = beginningPattern.exec(match);
      firstWord = matches[2];
      return firstWord[0].toUpperCase() + firstWord.slice(1);
    });
    periodIndex = excerpt.indexOf('.');
    if (periodIndex > -1) {
      excerpt = excerpt.slice(0, periodIndex + 1);
    }
    return excerpt;
  };

  if (require.main === module) {
    fetch().then(function(docs) {
      if (docs != null) {
        return fs.writeFileSync(path.join(__dirname, 'global-attribute-docs.json'), (JSON.stringify(docs, null, '  ')) + "\n");
      } else {
        return console.error('No docs');
      }
    });
  }

  module.exports = fetch;

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
