(function() {
  var convertMethodToSuggestion, convertPropertyToSuggestion, fs, getDocLink, isVisible, path, request, requestOptions, textComparator;

  path = require('path');

  fs = require('fs');

  request = require('request');

  requestOptions = {
    url: 'https://api.github.com/repos/atom/atom/releases/latest',
    json: true,
    headers: {
      'User-Agent': 'agent'
    }
  };

  request(requestOptions, function(error, response, release) {
    var apiAsset, apiRequestOptions;
    if (error != null) {
      console.error(error.message);
      return process.exit(1);
    }
    apiAsset = release.assets.filter(function(arg1) {
      var name;
      name = arg1.name;
      return name === 'atom-api.json';
    })[0];
    if (!(apiAsset != null ? apiAsset.browser_download_url : void 0)) {
      console.error('No atom-api.json asset found in latest release');
      return process.exit(1);
    }
    apiRequestOptions = {
      json: true,
      url: apiAsset.browser_download_url
    };
    return request(apiRequestOptions, function(error, response, atomApi) {
      var classes, instanceMethods, instanceProperties, methods, name, pluckMethodAttributes, pluckPropertyAttributes, properties, publicClasses, ref;
      if (error != null) {
        console.error(error.message);
        return process.exit(1);
      }
      classes = atomApi.classes;
      publicClasses = {};
      for (name in classes) {
        ref = classes[name], instanceProperties = ref.instanceProperties, instanceMethods = ref.instanceMethods;
        pluckPropertyAttributes = convertPropertyToSuggestion.bind(this, name);
        pluckMethodAttributes = convertMethodToSuggestion.bind(this, name);
        properties = instanceProperties.filter(isVisible).map(pluckPropertyAttributes).sort(textComparator);
        methods = instanceMethods.filter(isVisible).map(pluckMethodAttributes).sort(textComparator);
        if ((properties != null ? properties.length : void 0) > 0 || methods.length > 0) {
          publicClasses[name] = properties.concat(methods);
        }
      }
      return fs.writeFileSync('completions.json', JSON.stringify(publicClasses));
    });
  });

  isVisible = function(arg1) {
    var visibility;
    visibility = arg1.visibility;
    return visibility === 'Essential' || visibility === 'Extended' || visibility === 'Public';
  };

  convertMethodToSuggestion = function(className, method) {
    var arg, args, description, descriptionMoreURL, i, j, len, name, ref, returnValue, returnValues, snippet, snippets, summary, text;
    name = method.name, summary = method.summary, returnValues = method.returnValues;
    args = method['arguments'];
    snippets = [];
    if (args != null ? args.length : void 0) {
      for (i = j = 0, len = args.length; j < len; i = ++j) {
        arg = args[i];
        snippets.push("${" + (i + 1) + ":" + arg.name + "}");
      }
    }
    text = null;
    snippet = null;
    if (snippets.length) {
      snippet = name + "(" + (snippets.join(', ')) + ")";
    } else {
      text = name + "()";
    }
    returnValue = returnValues != null ? (ref = returnValues[0]) != null ? ref.type : void 0 : void 0;
    description = summary;
    descriptionMoreURL = getDocLink(className, name);
    return {
      name: name,
      text: text,
      snippet: snippet,
      description: description,
      descriptionMoreURL: descriptionMoreURL,
      leftLabel: returnValue,
      type: 'method'
    };
  };

  convertPropertyToSuggestion = function(className, arg1) {
    var description, descriptionMoreURL, name, ref, returnValue, summary, text;
    name = arg1.name, summary = arg1.summary;
    text = name;
    returnValue = summary != null ? (ref = summary.match(/\{(\w+)\}/)) != null ? ref[1] : void 0 : void 0;
    description = summary;
    descriptionMoreURL = getDocLink(className, name);
    return {
      name: name,
      text: text,
      description: description,
      descriptionMoreURL: descriptionMoreURL,
      leftLabel: returnValue,
      type: 'property'
    };
  };

  getDocLink = function(className, instanceName) {
    return "https://atom.io/docs/api/latest/" + className + "#instance-" + instanceName;
  };

  textComparator = function(a, b) {
    if (a.name > b.name) {
      return 1;
    }
    if (a.name < b.name) {
      return -1;
    }
    return 0;
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
