(function() {
  var Package, ThemePackage, path,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  path = require('path');

  Package = require('./package');

  module.exports = ThemePackage = (function(superClass) {
    extend(ThemePackage, superClass);

    function ThemePackage() {
      return ThemePackage.__super__.constructor.apply(this, arguments);
    }

    ThemePackage.prototype.getType = function() {
      return 'theme';
    };

    ThemePackage.prototype.getStyleSheetPriority = function() {
      return 1;
    };

    ThemePackage.prototype.enable = function() {
      return this.config.unshiftAtKeyPath('core.themes', this.name);
    };

    ThemePackage.prototype.disable = function() {
      return this.config.removeAtKeyPath('core.themes', this.name);
    };

    ThemePackage.prototype.preload = function() {
      this.loadTime = 0;
      return this.configSchemaRegisteredOnLoad = this.registerConfigSchemaFromMetadata();
    };

    ThemePackage.prototype.finishLoading = function() {
      return this.path = path.join(this.packageManager.resourcePath, this.path);
    };

    ThemePackage.prototype.load = function() {
      this.loadTime = 0;
      this.configSchemaRegisteredOnLoad = this.registerConfigSchemaFromMetadata();
      return this;
    };

    ThemePackage.prototype.activate = function() {
      return this.activationPromise != null ? this.activationPromise : this.activationPromise = new Promise((function(_this) {
        return function(resolve, reject) {
          _this.resolveActivationPromise = resolve;
          _this.rejectActivationPromise = reject;
          return _this.measure('activateTime', function() {
            var error;
            try {
              _this.loadStylesheets();
              return _this.activateNow();
            } catch (error1) {
              error = error1;
              return _this.handleError("Failed to activate the " + _this.name + " theme", error);
            }
          });
        };
      })(this));
    };

    return ThemePackage;

  })(Package);

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
