(function() {
  var CompositeDisposable, PaneAxisElement, PaneResizeHandleElement,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  CompositeDisposable = require('event-kit').CompositeDisposable;

  PaneResizeHandleElement = require('./pane-resize-handle-element');

  PaneAxisElement = (function(superClass) {
    extend(PaneAxisElement, superClass);

    function PaneAxisElement() {
      return PaneAxisElement.__super__.constructor.apply(this, arguments);
    }

    PaneAxisElement.prototype.attachedCallback = function() {
      var child, i, index, len, ref, results;
      if (this.subscriptions == null) {
        this.subscriptions = this.subscribeToModel();
      }
      ref = this.model.getChildren();
      results = [];
      for (index = i = 0, len = ref.length; i < len; index = ++i) {
        child = ref[index];
        results.push(this.childAdded({
          child: child,
          index: index
        }));
      }
      return results;
    };

    PaneAxisElement.prototype.detachedCallback = function() {
      var child, i, len, ref, results;
      this.subscriptions.dispose();
      this.subscriptions = null;
      ref = this.model.getChildren();
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        child = ref[i];
        results.push(this.childRemoved({
          child: child
        }));
      }
      return results;
    };

    PaneAxisElement.prototype.initialize = function(model, viewRegistry) {
      var child, i, index, len, ref;
      this.model = model;
      this.viewRegistry = viewRegistry;
      if (this.subscriptions == null) {
        this.subscriptions = this.subscribeToModel();
      }
      ref = this.model.getChildren();
      for (index = i = 0, len = ref.length; i < len; index = ++i) {
        child = ref[index];
        this.childAdded({
          child: child,
          index: index
        });
      }
      switch (this.model.getOrientation()) {
        case 'horizontal':
          this.classList.add('horizontal', 'pane-row');
          break;
        case 'vertical':
          this.classList.add('vertical', 'pane-column');
      }
      return this;
    };

    PaneAxisElement.prototype.subscribeToModel = function() {
      var subscriptions;
      subscriptions = new CompositeDisposable;
      subscriptions.add(this.model.onDidAddChild(this.childAdded.bind(this)));
      subscriptions.add(this.model.onDidRemoveChild(this.childRemoved.bind(this)));
      subscriptions.add(this.model.onDidReplaceChild(this.childReplaced.bind(this)));
      subscriptions.add(this.model.observeFlexScale(this.flexScaleChanged.bind(this)));
      return subscriptions;
    };

    PaneAxisElement.prototype.isPaneResizeHandleElement = function(element) {
      return (element != null ? element.nodeName.toLowerCase() : void 0) === 'atom-pane-resize-handle';
    };

    PaneAxisElement.prototype.childAdded = function(arg) {
      var child, index, nextElement, prevElement, resizeHandle, view;
      child = arg.child, index = arg.index;
      view = this.viewRegistry.getView(child);
      this.insertBefore(view, this.children[index * 2]);
      prevElement = view.previousSibling;
      if ((prevElement != null) && !this.isPaneResizeHandleElement(prevElement)) {
        resizeHandle = document.createElement('atom-pane-resize-handle');
        this.insertBefore(resizeHandle, view);
      }
      nextElement = view.nextSibling;
      if ((nextElement != null) && !this.isPaneResizeHandleElement(nextElement)) {
        resizeHandle = document.createElement('atom-pane-resize-handle');
        return this.insertBefore(resizeHandle, nextElement);
      }
    };

    PaneAxisElement.prototype.childRemoved = function(arg) {
      var child, siblingView, view;
      child = arg.child;
      view = this.viewRegistry.getView(child);
      siblingView = view.previousSibling;
      if ((siblingView != null) && this.isPaneResizeHandleElement(siblingView)) {
        siblingView.remove();
      }
      return view.remove();
    };

    PaneAxisElement.prototype.childReplaced = function(arg) {
      var focusedElement, index, newChild, oldChild;
      index = arg.index, oldChild = arg.oldChild, newChild = arg.newChild;
      if (this.hasFocus()) {
        focusedElement = document.activeElement;
      }
      this.childRemoved({
        child: oldChild,
        index: index
      });
      this.childAdded({
        child: newChild,
        index: index
      });
      if (document.activeElement === document.body) {
        return focusedElement != null ? focusedElement.focus() : void 0;
      }
    };

    PaneAxisElement.prototype.flexScaleChanged = function(flexScale) {
      return this.style.flexGrow = flexScale;
    };

    PaneAxisElement.prototype.hasFocus = function() {
      return this === document.activeElement || this.contains(document.activeElement);
    };

    return PaneAxisElement;

  })(HTMLElement);

  module.exports = PaneAxisElement = document.registerElement('atom-pane-axis', {
    prototype: PaneAxisElement.prototype
  });

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
