(function() {
  var CSON, KeymapManager, bundledKeymaps, fs, path, ref;

  fs = require('fs-plus');

  path = require('path');

  KeymapManager = require('atom-keymap');

  CSON = require('season');

  bundledKeymaps = (ref = require('../package.json')) != null ? ref._atomKeymaps : void 0;

  KeymapManager.prototype.onDidLoadBundledKeymaps = function(callback) {
    return this.emitter.on('did-load-bundled-keymaps', callback);
  };

  KeymapManager.prototype.onDidLoadUserKeymap = function(callback) {
    return this.emitter.on('did-load-user-keymap', callback);
  };

  KeymapManager.prototype.canLoadBundledKeymapsFromMemory = function() {
    return bundledKeymaps != null;
  };

  KeymapManager.prototype.loadBundledKeymaps = function() {
    var keymap, keymapName, keymapPath, keymapsPath, ref1;
    if (bundledKeymaps != null) {
      for (keymapName in bundledKeymaps) {
        keymap = bundledKeymaps[keymapName];
        keymapPath = "core:" + keymapName;
        this.add(keymapPath, keymap, 0, (ref1 = this.devMode) != null ? ref1 : false);
      }
    } else {
      keymapsPath = path.join(this.resourcePath, 'keymaps');
      this.loadKeymap(keymapsPath);
    }
    return this.emitter.emit('did-load-bundled-keymaps');
  };

  KeymapManager.prototype.getUserKeymapPath = function() {
    var userKeymapPath;
    if (this.configDirPath == null) {
      return "";
    }
    if (userKeymapPath = CSON.resolve(path.join(this.configDirPath, 'keymap'))) {
      return userKeymapPath;
    } else {
      return path.join(this.configDirPath, 'keymap.cson');
    }
  };

  KeymapManager.prototype.loadUserKeymap = function() {
    var detail, error, message, stack, userKeymapPath;
    userKeymapPath = this.getUserKeymapPath();
    if (!fs.isFileSync(userKeymapPath)) {
      return;
    }
    try {
      this.loadKeymap(userKeymapPath, {
        watch: true,
        suppressErrors: true,
        priority: 100
      });
    } catch (error1) {
      error = error1;
      if (error.message.indexOf('Unable to watch path') > -1) {
        message = "Unable to watch path: `" + (path.basename(userKeymapPath)) + "`. Make sure you\nhave permission to read `" + userKeymapPath + "`.\n\nOn linux there are currently problems with watch sizes. See\n[this document][watches] for more info.\n[watches]:https://github.com/atom/atom/blob/master/docs/build-instructions/linux.md#typeerror-unable-to-watch-path";
        this.notificationManager.addError(message, {
          dismissable: true
        });
      } else {
        detail = error.path;
        stack = error.stack;
        this.notificationManager.addFatalError(error.message, {
          detail: detail,
          stack: stack,
          dismissable: true
        });
      }
    }
    return this.emitter.emit('did-load-user-keymap');
  };

  KeymapManager.prototype.subscribeToFileReadFailure = function() {
    return this.onDidFailToReadFile((function(_this) {
      return function(error) {
        var detail, message, userKeymapPath;
        userKeymapPath = _this.getUserKeymapPath();
        message = "Failed to load `" + userKeymapPath + "`";
        detail = error.location != null ? error.stack : error.message;
        return _this.notificationManager.addError(message, {
          detail: detail,
          dismissable: true
        });
      };
    })(this));
  };

  module.exports = KeymapManager;

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
