(function() {
  var cloneObject, ipcHelpers;

  ipcHelpers = require('./ipc-helpers');

  cloneObject = function(object) {
    var clone, key, value;
    clone = {};
    for (key in object) {
      value = object[key];
      clone[key] = value;
    }
    return clone;
  };

  module.exports = function(arg) {
    var ApplicationDelegate, AtomEnvironment, Clipboard, CompileCache, FindParentDir, TextEditor, blobStore, buildAtomEnvironment, buildDefaultApplicationDelegate, clipboard, error, exitWithStatusCode, exportsPath, getWindowLoadSettings, handleKeydown, headless, ipcRenderer, legacyTestRunner, legacyTestRunnerPath, logFile, packageMetadata, packageRoot, path, promise, ref, ref1, remote, startCrashReporter, testPaths, testRunner, testRunnerPath;
    blobStore = arg.blobStore;
    startCrashReporter = require('./crash-reporter-start');
    remote = require('electron').remote;
    startCrashReporter();
    exitWithStatusCode = function(status) {
      remote.app.emit('will-quit');
      return remote.process.exit(status);
    };
    try {
      path = require('path');
      ipcRenderer = require('electron').ipcRenderer;
      getWindowLoadSettings = require('./get-window-load-settings');
      CompileCache = require('./compile-cache');
      AtomEnvironment = require('../src/atom-environment');
      ApplicationDelegate = require('../src/application-delegate');
      Clipboard = require('../src/clipboard');
      TextEditor = require('../src/text-editor');
      require('./electron-shims');
      ref = getWindowLoadSettings(), testRunnerPath = ref.testRunnerPath, legacyTestRunnerPath = ref.legacyTestRunnerPath, headless = ref.headless, logFile = ref.logFile, testPaths = ref.testPaths;
      if (!headless) {
        remote.getCurrentWindow().show();
      }
      handleKeydown = function(event) {
        if ((event.metaKey || event.ctrlKey) && event.keyCode === 82) {
          ipcHelpers.call('window-method', 'reload');
        }
        if (event.keyCode === 73 && ((process.platform === 'darwin' && event.metaKey && event.altKey) || (process.platform !== 'darwin' && event.ctrlKey && event.shiftKey))) {
          ipcHelpers.call('window-method', 'toggleDevTools');
        }
        if ((event.metaKey || event.ctrlKey) && event.keyCode === 87) {
          ipcHelpers.call('window-method', 'close');
        }
        if ((event.metaKey || event.ctrlKey) && event.keyCode === 67) {
          return ipcHelpers.call('window-method', 'copy');
        }
      };
      window.addEventListener('keydown', handleKeydown, true);
      exportsPath = path.join(getWindowLoadSettings().resourcePath, 'exports');
      require('module').globalPaths.push(exportsPath);
      process.env.NODE_PATH = exportsPath;
      FindParentDir = require('find-parent-dir');
      if (packageRoot = FindParentDir.sync(testPaths[0], 'package.json')) {
        packageMetadata = require(path.join(packageRoot, 'package.json'));
        if (packageMetadata.atomTranspilers) {
          CompileCache.addTranspilerConfigForPath(packageRoot, packageMetadata.name, packageMetadata, packageMetadata.atomTranspilers);
        }
      }
      document.title = "Spec Suite";
      clipboard = new Clipboard;
      TextEditor.setClipboard(clipboard);
      TextEditor.viewForItem = function(item) {
        return atom.views.getView(item);
      };
      testRunner = require(testRunnerPath);
      legacyTestRunner = require(legacyTestRunnerPath);
      buildDefaultApplicationDelegate = function() {
        return new ApplicationDelegate();
      };
      buildAtomEnvironment = function(params) {
        var atomEnvironment;
        params = cloneObject(params);
        if (!params.hasOwnProperty("clipboard")) {
          params.clipboard = clipboard;
        }
        if (!params.hasOwnProperty("blobStore")) {
          params.blobStore = blobStore;
        }
        if (!params.hasOwnProperty("onlyLoadBaseStyleSheets")) {
          params.onlyLoadBaseStyleSheets = true;
        }
        atomEnvironment = new AtomEnvironment(params);
        atomEnvironment.initialize(params);
        return atomEnvironment;
      };
      promise = testRunner({
        logFile: logFile,
        headless: headless,
        testPaths: testPaths,
        buildAtomEnvironment: buildAtomEnvironment,
        buildDefaultApplicationDelegate: buildDefaultApplicationDelegate,
        legacyTestRunner: legacyTestRunner
      });
      return promise.then(function(statusCode) {
        if (getWindowLoadSettings().headless) {
          return exitWithStatusCode(statusCode);
        }
      });
    } catch (error1) {
      error = error1;
      if (getWindowLoadSettings().headless) {
        console.error((ref1 = error.stack) != null ? ref1 : error);
        return exitWithStatusCode(1);
      } else {
        throw error;
      }
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
