(function() {
  var DefaultDirectoryProvider, Directory, fs, path, url;

  Directory = require('pathwatcher').Directory;

  fs = require('fs-plus');

  path = require('path');

  url = require('url');

  module.exports = DefaultDirectoryProvider = (function() {
    function DefaultDirectoryProvider() {}

    DefaultDirectoryProvider.prototype.directoryForURISync = function(uri) {
      var directory, directoryPath, host, normalizedPath;
      normalizedPath = this.normalizePath(uri);
      host = url.parse(uri).host;
      directoryPath = host ? uri : !fs.isDirectorySync(normalizedPath) && fs.isDirectorySync(path.dirname(normalizedPath)) ? path.dirname(normalizedPath) : normalizedPath;
      directory = new Directory(directoryPath);
      if (host) {
        directory.path = directoryPath;
        if (fs.isCaseInsensitive()) {
          directory.lowerCasePath = directoryPath.toLowerCase();
        }
      }
      return directory;
    };

    DefaultDirectoryProvider.prototype.directoryForURI = function(uri) {
      return Promise.resolve(this.directoryForURISync(uri));
    };

    DefaultDirectoryProvider.prototype.normalizePath = function(uri) {
      var matchData, pathWithNormalizedDiskDriveLetter;
      pathWithNormalizedDiskDriveLetter = process.platform === 'win32' && (matchData = uri.match(/^([a-z]):/)) ? "" + (matchData[1].toUpperCase()) + (uri.slice(1)) : uri;
      return path.normalize(pathWithNormalizedDiskDriveLetter);
    };

    return DefaultDirectoryProvider;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
