Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _eventKit = require('event-kit');

'use babel';

var AutoUpdateManager = (function () {
  function AutoUpdateManager(_ref) {
    var applicationDelegate = _ref.applicationDelegate;

    _classCallCheck(this, AutoUpdateManager);

    this.applicationDelegate = applicationDelegate;
    this.subscriptions = new _eventKit.CompositeDisposable();
    this.emitter = new _eventKit.Emitter();
  }

  _createClass(AutoUpdateManager, [{
    key: 'initialize',
    value: function initialize() {
      var _this = this;

      this.subscriptions.add(this.applicationDelegate.onDidBeginCheckingForUpdate(function () {
        _this.emitter.emit('did-begin-checking-for-update');
      }), this.applicationDelegate.onDidBeginDownloadingUpdate(function () {
        _this.emitter.emit('did-begin-downloading-update');
      }), this.applicationDelegate.onDidCompleteDownloadingUpdate(function (details) {
        _this.emitter.emit('did-complete-downloading-update', details);
      }), this.applicationDelegate.onUpdateNotAvailable(function () {
        _this.emitter.emit('update-not-available');
      }), this.applicationDelegate.onUpdateError(function () {
        _this.emitter.emit('update-error');
      }));
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      this.emitter.dispose();
    }
  }, {
    key: 'checkForUpdate',
    value: function checkForUpdate() {
      this.applicationDelegate.checkForUpdate();
    }
  }, {
    key: 'restartAndInstallUpdate',
    value: function restartAndInstallUpdate() {
      this.applicationDelegate.restartAndInstallUpdate();
    }
  }, {
    key: 'getState',
    value: function getState() {
      return this.applicationDelegate.getAutoUpdateManagerState();
    }
  }, {
    key: 'getErrorMessage',
    value: function getErrorMessage() {
      return this.applicationDelegate.getAutoUpdateManagerErrorMessage();
    }
  }, {
    key: 'platformSupportsUpdates',
    value: function platformSupportsUpdates() {
      return atom.getReleaseChannel() !== 'dev' && this.getState() !== 'unsupported';
    }
  }, {
    key: 'onDidBeginCheckingForUpdate',
    value: function onDidBeginCheckingForUpdate(callback) {
      return this.emitter.on('did-begin-checking-for-update', callback);
    }
  }, {
    key: 'onDidBeginDownloadingUpdate',
    value: function onDidBeginDownloadingUpdate(callback) {
      return this.emitter.on('did-begin-downloading-update', callback);
    }
  }, {
    key: 'onDidCompleteDownloadingUpdate',
    value: function onDidCompleteDownloadingUpdate(callback) {
      return this.emitter.on('did-complete-downloading-update', callback);
    }

    // TODO: When https://github.com/atom/electron/issues/4587 is closed, we can
    // add an update-available event.
    // onUpdateAvailable (callback) {
    //   return this.emitter.on('update-available', callback)
    // }

  }, {
    key: 'onUpdateNotAvailable',
    value: function onUpdateNotAvailable(callback) {
      return this.emitter.on('update-not-available', callback);
    }
  }, {
    key: 'onUpdateError',
    value: function onUpdateError(callback) {
      return this.emitter.on('update-error', callback);
    }
  }, {
    key: 'getPlatform',
    value: function getPlatform() {
      return process.platform;
    }
  }]);

  return AutoUpdateManager;
})();

exports['default'] = AutoUpdateManager;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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